/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.threats;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;
import org.joda.time.DateTime;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ListThreatIndicators;
import rs.co.ast.aspen.gui.module.threats.AnalysisTableModel;
import rs.co.ast.aspen.gui.module.threats.InMemoryDatabase;
import rs.co.ast.aspen.gui.module.threats.TableTransferHandler;
import rs.co.ast.aspen.gui.module.threats.ThreatTableModel;

@TopComponent.Description(preferredID="ThreatsTopComponent", iconBase="threat.png", persistenceType=1)
public class ThreatsTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(ThreatsTopComponent.class.getName());
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private ThreatTableModel threatTableModel = (ThreatTableModel)Lookup.getDefault().lookup(ThreatTableModel.class);
    private AnalysisTableModel analysisTableModel = (AnalysisTableModel)Lookup.getDefault().lookup(AnalysisTableModel.class);
    private InMemoryDatabase memDB = (InMemoryDatabase)Lookup.getDefault().lookup(InMemoryDatabase.class);
    private final int MAX_COUNT_BY_PAGE = 2000;
    private int totalPageCount = 0;
    private int page = 0;
    private long prevTimeStart = 0L;
    private long prevTimeFinish = 0L;
    private String sourcePrevSearch = ".*";
    private String typePrevSearch = ".*";
    private String confidencePrevSearch = ".*";
    private String tagPrevSearch = ".*";
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private final Collection<? extends Action> sqlFunctionActions = Lookups.forPath((String)"SQLFunctionsThreatsPopupMenu/SQLFunctions").lookupAll(Action.class);
    private JButton bNext;
    private JButton bPrevious;
    private JButton bSearch;
    private JXDatePicker dtpTimeFinish;
    private JXDatePicker dtpTimeStart;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JLabel lPageNumber;
    private JLabel lSearchOverview;
    private JXBusyLabel loadingIndicator;
    private JPopupMenu pmSQLFunctions;
    private JTable tAnalysis;
    private JTable tThreats;
    private JTextField tfConfidenceLevel;
    private JTextField tfSource;
    private JTextField tfSourceType;
    private JTextField tfTableFilter;
    private JTextField tfTags;

    public ThreatsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ThreatsTopComponent.class, (String)"CTL_ThreatsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ThreatsTopComponent.class, (String)"HINT_ThreatsTopComponent"));
        for (Action action : this.sqlFunctionActions) {
            this.pmSQLFunctions.add(action);
        }
        this.numberFormat.setGroupingUsed(true);
        this.tThreats.setModel(this.threatTableModel);
        this.tThreats.setAutoResizeMode(4);
        this.tThreats.setTransferHandler(new TableTransferHandler());
        this.tThreats.setAutoCreateRowSorter(true);
        this.tThreats.setCellSelectionEnabled(true);
        this.tThreats.setSelectionMode(2);
        this.tThreats.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = ThreatsTopComponent.this.tThreats.rowAtPoint(e.getPoint());
                    int column = ThreatsTopComponent.this.tThreats.columnAtPoint(e.getPoint());
                    if (row > -1 && column > -1) {
                        ThreatsTopComponent.this.tThreats.setRowSelectionInterval(row, row);
                        ThreatsTopComponent.this.tThreats.setColumnSelectionInterval(column, column);
                    }
                    ThreatsTopComponent.this.tThreats.changeSelection(row, column, false, false);
                    ThreatsTopComponent.this.pmSQLFunctions.show(e.getComponent(), e.getX(), e.getY());
                    ThreatsTopComponent.this.threatTableModel.setNewlyAddedColumn(ThreatsTopComponent.this.threatTableModel.getColumnName(column));
                } else {
                    int selectedRow = ThreatsTopComponent.this.tThreats.getSelectedRow();
                    int selectedColumn = ThreatsTopComponent.this.tThreats.getSelectedColumn();
                    if (selectedRow > -1 && selectedColumn > -1) {
                        ThreatsTopComponent.this.threatTableModel.setNewlyAddedColumn(ThreatsTopComponent.this.tThreats.getColumnName(selectedColumn));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.threatTableModel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("DATA_ADDED")) {
                // empty if block
            }
        });
        this.analysisTableModel.addPropertyChangeSupport(evt -> {
            if (evt.getPropertyName().equals("ENABLE_ANALYSIS_TAB")) {
                this.jTabbedPane1.setEnabledAt(1, true);
            }
        });
        this.tAnalysis.setModel(this.analysisTableModel);
        this.tAnalysis.setAutoResizeMode(4);
        this.tAnalysis.setTransferHandler(new TableTransferHandler());
        this.tAnalysis.setAutoCreateRowSorter(true);
        this.tAnalysis.setCellSelectionEnabled(true);
        this.tAnalysis.setSelectionMode(2);
        this.tAnalysis.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ThreatsTopComponent.this.analysisTableModel.getColumnCount() > 0) {
                    TableRowSorter rowSorter = (TableRowSorter)ThreatsTopComponent.this.tAnalysis.getRowSorter();
                    ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
                    RowSorter.SortKey sortKey = new RowSorter.SortKey(0, SortOrder.DESCENDING);
                    keys.add(sortKey);
                    rowSorter.setSortKeys(keys);
                    rowSorter.sort();
                }
            }
        });
        this.jTabbedPane1.setEnabledAt(1, false);
        this.dtpTimeStart.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeStart.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeFinish.setFormats(new String[]{"yyyy-MM-dd"});
        this.dtpTimeFinish.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.dtpTimeStart.setTimeZone(TimeZone.getDefault());
        this.dtpTimeFinish.setTimeZone(TimeZone.getDefault());
        long now = System.currentTimeMillis();
        this.dtpTimeStart.setDate(new DateTime(now - 86400000L).withTimeAtStartOfDay().toDate());
        this.dtpTimeFinish.setDate(new DateTime(now).withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).withMillisOfSecond(0).toDate());
        this.dtpTimeStart.addActionListener(e -> {
            if (this.dtpTimeStart.getDate().getTime() == this.prevTimeStart) {
                this.bSearch.setForeground(Color.black);
            } else {
                this.bSearch.setForeground(Color.red);
            }
        });
        this.dtpTimeFinish.addActionListener(e -> {
            if (this.dtpTimeFinish.getDate().getTime() == this.prevTimeFinish) {
                this.bSearch.setForeground(Color.black);
            } else {
                this.bSearch.setForeground(Color.red);
            }
        });
        this.tfSource.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ThreatsTopComponent.this.startSearch();
                }
            }
        });
        this.tfSource.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            private void checkSearchParameters() {
                if (ThreatsTopComponent.this.tfSource.getText().equals(ThreatsTopComponent.this.sourcePrevSearch)) {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.red);
                }
            }
        });
        this.tfSourceType.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ThreatsTopComponent.this.startSearch();
                }
            }
        });
        this.tfSourceType.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            private void checkSearchParameters() {
                if (ThreatsTopComponent.this.tfSourceType.getText().equals(ThreatsTopComponent.this.typePrevSearch)) {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.red);
                }
            }
        });
        this.tfTags.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ThreatsTopComponent.this.startSearch();
                }
            }
        });
        this.tfTags.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            private void checkSearchParameters() {
                if (ThreatsTopComponent.this.tfTags.getText().equals(ThreatsTopComponent.this.tagPrevSearch)) {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.red);
                }
            }
        });
        this.tfConfidenceLevel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ThreatsTopComponent.this.startSearch();
                }
            }
        });
        this.tfConfidenceLevel.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkSearchParameters();
            }

            private void checkSearchParameters() {
                if (ThreatsTopComponent.this.tfConfidenceLevel.getText().equals(ThreatsTopComponent.this.confidencePrevSearch)) {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    ThreatsTopComponent.this.bSearch.setForeground(Color.red);
                }
            }
        });
        this.tfTableFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            private void filter() {
                ThreatsTopComponent.this.memDB.filter(ThreatsTopComponent.this.tfTableFilter.getText());
            }
        });
    }

    private void initComponents() {
        this.pmSQLFunctions = new JPopupMenu();
        this.jPanel2 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel10 = new JLabel();
        this.dtpTimeStart = new JXDatePicker();
        this.dtpTimeFinish = new JXDatePicker();
        this.jLabel14 = new JLabel();
        this.loadingIndicator = new JXBusyLabel();
        this.bSearch = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel15 = new JLabel();
        this.tfSource = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.tfSourceType = new JTextField();
        this.jLabel8 = new JLabel();
        this.tfTags = new JTextField();
        this.jLabel16 = new JLabel();
        this.tfConfidenceLevel = new JTextField();
        this.lSearchOverview = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.bPrevious = new JButton();
        this.lPageNumber = new JLabel();
        this.bNext = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tThreats = new JTable();
        this.jLabel2 = new JLabel();
        this.tfTableFilter = new JTextField();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tAnalysis = new JTable();
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel10.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel14.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dtpTimeFinish, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dtpTimeStart, -2, -1, -2))).addGap(0, 6, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeStart, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.dtpTimeFinish, -2, -1, -2).addComponent(this.jLabel14)).addContainerGap(26, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.loadingIndicator, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.loadingIndicator.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.bSearch.text"));
        this.bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThreatsTopComponent.this.bSearchActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.loadingIndicator, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearch).addGap(0, 0, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent((Component)this.loadingIndicator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.bSearch)).addComponent(this.jPanel3, -2, -1, -2))));
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel15.text"));
        this.tfSource.setText(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.tfSource.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel7.text"));
        this.tfSourceType.setText(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.tfSourceType.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel8.text"));
        this.tfTags.setText(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.tfTags.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel16.text"));
        this.tfConfidenceLevel.setText(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.tfConfidenceLevel.text"));
        Mnemonics.setLocalizedText((JLabel)this.lSearchOverview, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.lSearchOverview.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lSearchOverview, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tfSourceType, -1, 250, Short.MAX_VALUE).addComponent(this.tfSource)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tfConfidenceLevel, -1, 250, Short.MAX_VALUE).addComponent(this.tfTags)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel15).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfTags, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jLabel8)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSource, -2, -1, -2).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSourceType, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel16).addComponent(this.tfConfidenceLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lSearchOverview).addGap(31, 31, 31)));
        this.jSeparator1.setOrientation(1);
        Mnemonics.setLocalizedText((AbstractButton)this.bPrevious, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.bPrevious.text"));
        this.bPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThreatsTopComponent.this.bPreviousActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lPageNumber, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.lPageNumber.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bNext, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.bNext.text"));
        this.bNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThreatsTopComponent.this.bNextActionPerformed(evt);
            }
        });
        this.tThreats.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane1.setViewportView(this.tThreats);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jLabel2.text"));
        this.tfTableFilter.setText(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.tfTableFilter.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.bPrevious).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lPageNumber).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bNext)).addComponent(this.jScrollPane1, -1, 1269, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfTableFilter))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tfTableFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 469, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bNext).addComponent(this.bPrevious).addComponent(this.lPageNumber)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        this.tAnalysis.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane2.setViewportView(this.tAnalysis);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 1263, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 531, Short.MAX_VALUE));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.jPanel5.TabConstraints.tabTitle"), this.jPanel5);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 3, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addComponent(this.jPanel4, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 576, Short.MAX_VALUE).addContainerGap()));
    }

    private void bSearchActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void bNextActionPerformed(ActionEvent evt) {
        if (this.page < this.totalPageCount - 1) {
            this.jTabbedPane1.setEnabledAt(1, false);
            ++this.page;
            new Updater().execute();
        }
    }

    private void bPreviousActionPerformed(ActionEvent evt) {
        if (this.page != 0) {
            this.jTabbedPane1.setEnabledAt(1, false);
            --this.page;
            new Updater().execute();
        }
    }

    private long getStartTime() {
        return this.dtpTimeStart.getDate().getTime();
    }

    private long getFinishTime() {
        return this.getEndOfDayFrom(this.dtpTimeFinish.getDate().getTime());
    }

    private long getEndOfDayFrom(long time) {
        return time + 86400000L;
    }

    protected void componentOpened() {
        this.bSearch.setForeground(Color.red);
        this.lPageNumber.setText(String.format(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.lPageNumber.text"), 0, 0));
    }

    protected void componentClosed() {
        this.memDB.dispose();
        this.tfTableFilter.setText("");
        this.threatTableModel.resetData();
        this.analysisTableModel.resetData();
    }

    private void startSearch() {
        this.jTabbedPane1.setSelectedIndex(0);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.page = 0;
        new Updater().execute();
    }

    private void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            int width = 15;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component comp = table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            if (width > 310) {
                width = 310;
            }
            columnModel.getColumn(column).setPreferredWidth(width);
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "7.1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void toggleLoading() {
        this.loadingIndicator.setBusy(!this.loadingIndicator.isBusy());
    }

    private void setPrevSearches() {
        this.sourcePrevSearch = this.tfSource.getText();
        this.typePrevSearch = this.tfSourceType.getText();
        this.confidencePrevSearch = this.tfConfidenceLevel.getText();
        this.tagPrevSearch = this.tfTags.getText();
    }

    public class Updater
    extends SwingWorker<ListThreatIndicators, Void> {
        @Override
        protected ListThreatIndicators doInBackground() throws Exception {
            ThreatsTopComponent.this.toggleLoading();
            ThreatsTopComponent.this.memDB.dispose();
            ThreatsTopComponent.this.tfTableFilter.setText("");
            ThreatsTopComponent.this.threatTableModel.resetData();
            ThreatsTopComponent.this.analysisTableModel.resetData();
            ThreatsTopComponent.this.setPrevSearches();
            try {
                return ThreatsTopComponent.this.apiService.getThreatIndicatorsBy(ThreatsTopComponent.this.tfSourceType.getText(), ThreatsTopComponent.this.tfSource.getText(), ThreatsTopComponent.this.tfTags.getText(), ThreatsTopComponent.this.tfConfidenceLevel.getText(), ThreatsTopComponent.this.getStartTime(), ThreatsTopComponent.this.getFinishTime(), ThreatsTopComponent.this.page, 2000);
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        protected void done() {
            try {
                ListThreatIndicators get = (ListThreatIndicators)this.get();
                if (get != null) {
                    ThreatsTopComponent.this.memDB.initDB(get.getIndicators(), ThreatsTopComponent.this.threatTableModel.getColumnNames());
                    ThreatsTopComponent.this.totalPageCount = get.getTotalPages();
                    ThreatsTopComponent.this.lSearchOverview.setText(String.format(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.lSearchResult.msg"), ThreatsTopComponent.this.numberFormat.format(get.getTotalCount()), ThreatsTopComponent.this.numberFormat.format(get.getIndicators().size())));
                    ThreatsTopComponent.this.lPageNumber.setText(String.format(NbBundle.getMessage(ThreatsTopComponent.class, (String)"ThreatsTopComponent.lPageNumber.text"), ThreatsTopComponent.this.page + 1, ThreatsTopComponent.this.totalPageCount));
                    ThreatsTopComponent.this.prevTimeStart = ThreatsTopComponent.this.getStartTime();
                    ThreatsTopComponent.this.prevTimeFinish = ThreatsTopComponent.this.getFinishTime();
                    ThreatsTopComponent.this.bSearch.setForeground(Color.black);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ThreatsTopComponent.this.toggleLoading();
        }
    }
}

