/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class DocumentationPanel
extends JPanel {
    private JButton bSearch;
    private JScrollPane jScrollPane2;
    private JTextPane taDoc;
    private JTextField tfSearch;

    public DocumentationPanel() {
        this.initComponents();
        this.taDoc.setContentType("text/html");
        this.taDoc.setEditable(false);
        this.loadDocumentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDocumentation() {
        BufferedReader in = null;
        try {
            StringBuilder sb = new StringBuilder();
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("correlation_documentation.txt");
            in = new BufferedReader(new InputStreamReader(resourceAsStream));
            String line = in.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = in.readLine();
            }
            this.taDoc.setText(sb.toString());
            this.taDoc.setCaretPosition(0);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.tfSearch = new JTextField();
        this.bSearch = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.taDoc = new JTextPane();
        this.tfSearch.setText(NbBundle.getMessage(DocumentationPanel.class, (String)"DocumentationPanel.tfSearch.text", (Object[])new Object[0]));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentationPanel.this.tfSearchActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(DocumentationPanel.class, (String)"DocumentationPanel.bSearch.text", (Object[])new Object[0]));
        this.bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentationPanel.this.bSearchActionPerformed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.taDoc);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addComponent(this.tfSearch, -1, 304, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bSearch))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bSearch).addComponent(this.tfSearch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 257, Short.MAX_VALUE).addContainerGap()));
    }

    private void bSearchActionPerformed(ActionEvent evt) {
        this.highLight();
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.highLight();
    }

    public void highLight() {
        try {
            String pattern = this.tfSearch.getText();
            Document doc = this.taDoc.getDocument();
            int pos = this.taDoc.getCaretPosition();
            boolean found = false;
            int findLength = pattern.length();
            if (pos + findLength > doc.getLength()) {
                pos = 0;
            }
            while (pos + findLength <= doc.getLength()) {
                String match = doc.getText(pos, findLength).toLowerCase();
                if (match.equals(pattern) && pos - 1 >= 0 && Character.isWhitespace(doc.getText(pos - 1, 1).charAt(0)) && (pos + findLength == doc.getLength() || Character.isWhitespace(doc.getText(pos + findLength, 1).charAt(0)))) {
                    found = true;
                    break;
                }
                ++pos;
            }
            if (found) {
                this.taDoc.setSelectionStart(pos);
                this.taDoc.setSelectionEnd(pos + pattern.length());
                this.taDoc.getCaret().setSelectionVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

