/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.FloatFromJS;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.hollywood.Step;

public class StartRecordingStep
extends Step {
    private final File destination;

    public static StartRecordingStep fromJsonMap(Map<String, Object> map) {
        Object start = map.get("start");
        String fileName = (String)map.get("fileName");
        if (start == null) {
            throw new IllegalArgumentException("start time missing");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName missing");
        }
        return new StartRecordingStep(FloatFromJS.get(start), fileName);
    }

    public StartRecordingStep(float start, String fileName) {
        super(start, 0.0f);
        String formatted = new SimpleDateFormat(fileName).format(new Date());
        this.destination = new File(formatted);
    }

    @Override
    public void trigger(Renderer renderer) {
        renderer.hideStats();
        renderer.startRecording(this.destination);
    }
}

