/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import java.util.Random;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RendererProperties;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.SpatialAppState;

public class TwoDSpatialState
implements SpatialAppState {
    private static final Random RND = new Random();
    private static final Random SEEDED_RND = new Random();
    private boolean active;
    private Renderer app;
    private boolean initialized = false;
    private InputManager inputManager;
    private boolean leftMouseKeyPressed = false;
    private final InputListener lmkListener = new ActionListener(){

        public void onAction(String name, boolean isPressed, float tpf) {
            if (isPressed && !TwoDSpatialState.this.leftMouseKeyPressed) {
                TwoDSpatialState.this.inputManager.setCursorVisible(false);
            } else if (!isPressed && TwoDSpatialState.this.leftMouseKeyPressed) {
                TwoDSpatialState.this.inputManager.setCursorVisible(true);
            }
            TwoDSpatialState.this.leftMouseKeyPressed = isPressed;
        }
    };
    private final InputListener moveCameraListener = new AnalogListener(){

        public void onAnalog(String name, float value, float tpf) {
            float val = ((TwoDSpatialState)TwoDSpatialState.this).props.CAM2D_ZOOM_SPEED * value / tpf;
            switch (name) {
                case "Move+": {
                    TwoDSpatialState.this.app.getCameraNode().move(0.0f, -val, 0.0f);
                    break;
                }
                case "Move-": {
                    TwoDSpatialState.this.app.getCameraNode().move(0.0f, val, 0.0f);
                }
            }
        }
    };
    private final InputListener panCameraListener = new AnalogListener(){

        public void onAnalog(String name, float value, float tpf) {
            if (!TwoDSpatialState.this.leftMouseKeyPressed) {
                return;
            }
            float val = ((TwoDSpatialState)TwoDSpatialState.this).props.CAM2D_PAN_SPEED * value / tpf;
            switch (name) {
                case "move_left": {
                    TwoDSpatialState.this.app.getCameraNode().move(-val, 0.0f, 0.0f);
                    break;
                }
                case "move_right": {
                    TwoDSpatialState.this.app.getCameraNode().move(val, 0.0f, 0.0f);
                    break;
                }
                case "move_up": {
                    TwoDSpatialState.this.app.getCameraNode().move(0.0f, 0.0f, val);
                    break;
                }
                case "move_down": {
                    TwoDSpatialState.this.app.getCameraNode().move(0.0f, 0.0f, -val);
                }
            }
        }
    };
    private final RendererProperties props;

    public TwoDSpatialState(RendererProperties props) {
        this.props = props;
    }

    public void cleanup() {
        if (this.inputManager != null) {
            if (this.lmkListener != null) {
                this.inputManager.removeListener(this.lmkListener);
            }
            if (this.panCameraListener != null) {
                this.inputManager.removeListener(this.panCameraListener);
            }
            if (this.moveCameraListener != null) {
                this.inputManager.removeListener(this.moveCameraListener);
            }
            this.inputManager.deleteTrigger("LMK", (Trigger)new MouseButtonTrigger(0));
            this.inputManager.deleteTrigger("move_left", (Trigger)new MouseAxisTrigger(0, false));
            this.inputManager.deleteTrigger("move_right", (Trigger)new MouseAxisTrigger(0, true));
            this.inputManager.deleteTrigger("move_up", (Trigger)new MouseAxisTrigger(1, false));
            this.inputManager.deleteTrigger("move_down", (Trigger)new MouseAxisTrigger(1, true));
            this.inputManager.deleteTrigger("Move+", (Trigger)new MouseAxisTrigger(2, false));
            this.inputManager.deleteTrigger("Move-", (Trigger)new MouseAxisTrigger(2, true));
            this.initialized = false;
        }
    }

    @Override
    public Vector3f createPos(Node node) {
        return this.createPos(node, false);
    }

    @Override
    public Vector3f createPos(Node node, boolean trueRandom) {
        int y;
        int x;
        Random rnd;
        String pos = node.get("%pos", "222");
        if (trueRandom) {
            rnd = RND;
        } else {
            SEEDED_RND.setSeed(node.hashCode());
            rnd = SEEDED_RND;
        }
        float rx = this.props.SECTOR_SIZE / 2.0f - rnd.nextFloat() * this.props.SECTOR_SIZE;
        float ry = this.props.SECTOR_SIZE / 2.0f - rnd.nextFloat() * this.props.SECTOR_SIZE;
        try {
            x = Integer.parseInt(pos.substring(0, 1)) - 2;
            y = Integer.parseInt(pos.substring(1, 2)) - 2;
        }
        catch (NumberFormatException ex) {
            y = 0;
            x = 0;
        }
        return new Vector3f((float)x * this.props.SECTOR_SIZE + rx, 0.0f, (float)y * this.props.SECTOR_SIZE + ry);
    }

    public void initialize(AppStateManager stateManager, Application app) {
        this.app = (Renderer)app;
        this.inputManager = app.getInputManager();
        System.out.println("Adding mapping 2d");
        this.inputManager.addMapping("LMK", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addMapping("move_left", new Trigger[]{new MouseAxisTrigger(0, false)});
        this.inputManager.addMapping("move_right", new Trigger[]{new MouseAxisTrigger(0, true)});
        this.inputManager.addMapping("move_up", new Trigger[]{new MouseAxisTrigger(1, false)});
        this.inputManager.addMapping("move_down", new Trigger[]{new MouseAxisTrigger(1, true)});
        this.inputManager.addMapping("Move+", new Trigger[]{new MouseAxisTrigger(2, false)});
        this.inputManager.addMapping("Move-", new Trigger[]{new MouseAxisTrigger(2, true)});
        this.inputManager.addListener(this.lmkListener, new String[]{"LMK"});
        this.inputManager.addListener(this.panCameraListener, new String[]{"move_left"});
        this.inputManager.addListener(this.panCameraListener, new String[]{"move_right"});
        this.inputManager.addListener(this.panCameraListener, new String[]{"move_up"});
        this.inputManager.addListener(this.panCameraListener, new String[]{"move_down"});
        this.inputManager.addListener(this.moveCameraListener, new String[]{"Move+"});
        this.inputManager.addListener(this.moveCameraListener, new String[]{"Move-"});
        this.initialized = true;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void setEnabled(boolean active) {
        this.active = active;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void postRender() {
    }

    public void render(RenderManager rm) {
    }

    public void stateAttached(AppStateManager stateManager) {
    }

    public void stateDetached(AppStateManager stateManager) {
        this.cleanup();
    }

    public void update(float tpf) {
    }
}

