/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import java.util.Random;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.RendererProperties;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.SpatialAppState;

public class ThreeDSpatialState
implements SpatialAppState {
    private static final Random RND = new Random();
    private static final Random SEEDED_RND = new Random();
    private boolean active;
    private Renderer app;
    private boolean initialized;
    private InputManager inputManager;
    private boolean leftMouseKeyPressed = false;
    private final InputListener lmkListener = new ActionListener(){

        public void onAction(String name, boolean isPressed, float tpf) {
            if (isPressed && !ThreeDSpatialState.this.leftMouseKeyPressed) {
                ThreeDSpatialState.this.inputManager.setCursorVisible(false);
            } else if (!isPressed && ThreeDSpatialState.this.leftMouseKeyPressed) {
                ThreeDSpatialState.this.inputManager.setCursorVisible(true);
            }
            ThreeDSpatialState.this.leftMouseKeyPressed = isPressed;
        }
    };
    private final InputListener moveCameraListener = new AnalogListener(){

        public void onAnalog(String name, float value, float tpf) {
            float val = ((ThreeDSpatialState)ThreeDSpatialState.this).props.CAM3D_MOVE_SPEED * value / tpf;
            switch (name) {
                case "Move+": {
                    ThreeDSpatialState.this.app.getCameraNode().move(0.0f, -val, 0.0f);
                    break;
                }
                case "Move-": {
                    ThreeDSpatialState.this.app.getCameraNode().move(0.0f, val, 0.0f);
                }
            }
        }
    };
    private final RendererProperties props;
    private final InputListener rotateCameraListener = new AnalogListener(){

        public void onAnalog(String name, float value, float tpf) {
            if (!ThreeDSpatialState.this.leftMouseKeyPressed) {
                return;
            }
            float val = ((ThreeDSpatialState)ThreeDSpatialState.this).props.CAM3D_ROTATION_SPEED * value / tpf;
            switch (name) {
                case "Rotate_XZ+": {
                    ThreeDSpatialState.this.app.getCameraTarget().rotate(val, 0.0f, 0.0f);
                    break;
                }
                case "Rotate_XZ-": {
                    ThreeDSpatialState.this.app.getCameraTarget().rotate(-val, 0.0f, 0.0f);
                    break;
                }
                case "Rotate_XY+": {
                    ThreeDSpatialState.this.app.getCameraTarget().rotate(0.0f, 0.0f, val);
                    break;
                }
                case "Rotate_XY-": {
                    ThreeDSpatialState.this.app.getCameraTarget().rotate(0.0f, 0.0f, -val);
                }
            }
        }
    };

    public ThreeDSpatialState(RendererProperties props) {
        this.props = props;
    }

    public void cleanup() {
        if (this.inputManager != null) {
            if (this.lmkListener != null) {
                this.inputManager.removeListener(this.lmkListener);
            }
            if (this.rotateCameraListener != null) {
                this.inputManager.removeListener(this.rotateCameraListener);
                this.inputManager.removeListener(this.rotateCameraListener);
                this.inputManager.removeListener(this.rotateCameraListener);
                this.inputManager.removeListener(this.rotateCameraListener);
            }
            if (this.moveCameraListener != null) {
                this.inputManager.removeListener(this.moveCameraListener);
                this.inputManager.removeListener(this.moveCameraListener);
            }
            this.inputManager.deleteTrigger("LMK", (Trigger)new MouseButtonTrigger(0));
            this.inputManager.deleteTrigger("Rotate_XY+", (Trigger)new MouseAxisTrigger(0, false));
            this.inputManager.deleteTrigger("Rotate_XY-", (Trigger)new MouseAxisTrigger(0, true));
            this.inputManager.deleteTrigger("Rotate_XZ+", (Trigger)new MouseAxisTrigger(1, false));
            this.inputManager.deleteTrigger("Rotate_XZ-", (Trigger)new MouseAxisTrigger(1, true));
            this.inputManager.deleteTrigger("Move+", (Trigger)new MouseAxisTrigger(2, false));
            this.inputManager.deleteTrigger("Move-", (Trigger)new MouseAxisTrigger(2, true));
            this.initialized = false;
        }
    }

    @Override
    public Vector3f createPos(Node node) {
        return this.createPos(node, false);
    }

    @Override
    public Vector3f createPos(Node node, boolean trueRandom) {
        int z;
        int y;
        int x;
        Random rnd;
        String pos = node.get("%pos", "222");
        if (trueRandom) {
            rnd = RND;
        } else {
            SEEDED_RND.setSeed(node.hashCode());
            rnd = SEEDED_RND;
        }
        float rx = this.props.SECTOR_SIZE / 2.0f - rnd.nextFloat() * this.props.SECTOR_SIZE;
        float ry = this.props.SECTOR_SIZE / 2.0f - rnd.nextFloat() * this.props.SECTOR_SIZE;
        float rz = this.props.SECTOR_SIZE / 2.0f - rnd.nextFloat() * this.props.SECTOR_SIZE;
        try {
            x = Integer.parseInt(pos.substring(0, 1)) - 2;
            y = Integer.parseInt(pos.substring(1, 2)) - 2;
            z = Integer.parseInt(pos.substring(2, 3)) - 2;
        }
        catch (NumberFormatException ex) {
            z = 0;
            y = 0;
            x = 0;
        }
        return new Vector3f((float)x * this.props.SECTOR_SIZE + rx, (float)z * this.props.SECTOR_SIZE + rz, (float)y * this.props.SECTOR_SIZE + ry);
    }

    public void initialize(AppStateManager stateManager, Application app) {
        this.app = (Renderer)app;
        this.inputManager = app.getInputManager();
        this.inputManager.addMapping("LMK", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addMapping("Rotate_XY+", new Trigger[]{new MouseAxisTrigger(0, false)});
        this.inputManager.addMapping("Rotate_XY-", new Trigger[]{new MouseAxisTrigger(0, true)});
        this.inputManager.addMapping("Rotate_XZ+", new Trigger[]{new MouseAxisTrigger(1, false)});
        this.inputManager.addMapping("Rotate_XZ-", new Trigger[]{new MouseAxisTrigger(1, true)});
        this.inputManager.addMapping("Move+", new Trigger[]{new MouseAxisTrigger(2, false)});
        this.inputManager.addMapping("Move-", new Trigger[]{new MouseAxisTrigger(2, true)});
        this.inputManager.addListener(this.lmkListener, new String[]{"LMK"});
        this.inputManager.addListener(this.rotateCameraListener, new String[]{"Rotate_XY+"});
        this.inputManager.addListener(this.rotateCameraListener, new String[]{"Rotate_XY-"});
        this.inputManager.addListener(this.rotateCameraListener, new String[]{"Rotate_XZ+"});
        this.inputManager.addListener(this.rotateCameraListener, new String[]{"Rotate_XZ-"});
        this.inputManager.addListener(this.moveCameraListener, new String[]{"Move+"});
        this.inputManager.addListener(this.moveCameraListener, new String[]{"Move-"});
        this.initialized = true;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void setEnabled(boolean active) {
        this.active = active;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void postRender() {
    }

    public void render(RenderManager rm) {
    }

    public void stateAttached(AppStateManager stateManager) {
    }

    public void stateDetached(AppStateManager stateManager) {
        this.cleanup();
    }

    public void update(float tpf) {
    }
}

