/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.asset.AssetKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.awt.Color;
import java.io.IOException;

public class FontKey
extends AssetKey {
    protected String aboveAscentBuffer;
    protected String belowDescentBuffer;
    protected Color color;
    protected int size;
    protected int style;
    protected int type;

    public FontKey(String fontName, int type, Color color, int size, int style) {
        super(fontName);
        this.type = type;
        this.color = color;
        this.size = size;
        this.style = style;
    }

    public FontKey(String fontName, int type, Color color, int size, int style, String aboveAscentBuffer, String belowDescentBuffer) {
        this(fontName, type, color, size, style);
        this.aboveAscentBuffer = aboveAscentBuffer;
        this.belowDescentBuffer = belowDescentBuffer;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FontKey other = (FontKey)((Object)obj);
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        return this.type == other.type;
    }

    public String getAboveAscentBuffer() {
        return this.aboveAscentBuffer;
    }

    public String getBelowDescentBuffer() {
        return this.belowDescentBuffer;
    }

    public Color getColor() {
        return this.color;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + this.size;
        result = 31 * result + this.style;
        result = 31 * result + this.type;
        return result;
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.type = ic.readInt("type", 0);
        this.size = ic.readInt("size", 18);
        this.style = ic.readInt("style", 0);
        float[] colorTable = ic.readFloatArray("color", new float[]{0.0f, 0.0f, 0.0f});
        this.color = new Color(colorTable[0], colorTable[1], colorTable[2]);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.type, "type", 0);
        oc.write(this.size, "size", 18);
        oc.write(this.style, "style", 0);
        oc.write(new float[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()}, "color", null);
    }
}

