/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorStucci
extends TextureGenerator {
    protected static final int TEX_NOISESOFT = 0;
    protected float noisesize;
    protected int noisebasis;
    protected NoiseGenerator.NoiseFunction noiseFunction;
    protected int noisetype;
    protected float turbul;
    protected boolean isHard;
    protected int stype;

    public TextureGeneratorStucci(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    @Override
    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        this.noiseFunction = NoiseGenerator.noiseFunctions.get(this.noisebasis);
        if (this.noiseFunction == null) {
            this.noiseFunction = NoiseGenerator.noiseFunctions.get(0);
            this.noisebasis = 0;
        }
        this.noisetype = ((Number)tex.getFieldValue("noisetype")).intValue();
        this.turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
        this.isHard = this.noisetype != 0;
        this.stype = ((Number)tex.getFieldValue("stype")).intValue();
        if (this.noisesize <= 0.001f) {
            this.noisesize = 0.001f;
        }
    }

    @Override
    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        if (this.noisebasis == 0) {
            x += 1.0f;
            y += 1.0f;
            z += 1.0f;
        }
        float noiseValue = NoiseGenerator.NoiseFunctions.noise(x, y, z, this.noisesize, 0, this.noiseFunction, this.isHard);
        float ofs = this.turbul / 200.0f;
        if (this.stype != 0) {
            ofs *= noiseValue * noiseValue;
        }
        pixel.intensity = NoiseGenerator.NoiseFunctions.noise(x, y, z + ofs, this.noisesize, 0, this.noiseFunction, this.isHard);
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            pixel.alpha = this.colorBand[colorbandIndex][3];
        }
        if (this.stype == 2) {
            pixel.intensity = 1.0f - pixel.intensity;
        }
        if (pixel.intensity < 0.0f) {
            pixel.intensity = 0.0f;
        }
    }
}

