/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.blending;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.blending.AbstractTextureBlender;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureBlenderLuminance
extends AbstractTextureBlender {
    private static final Logger LOGGER = Logger.getLogger(TextureBlenderLuminance.class.getName());

    public TextureBlenderLuminance(int flag, boolean negateTexture, int blendType, float[] materialColor, float[] color, float blendFactor) {
        super(flag, negateTexture, blendType, materialColor, color, blendFactor);
    }

    @Override
    public Image blend(Image image, Image baseImage, BlenderContext blenderContext) {
        Image result;
        this.prepareImagesForBlending(image, baseImage);
        Image.Format format = image.getFormat();
        PixelInputOutput basePixelIO = null;
        TexturePixel basePixel = null;
        float[] materialColor = this.materialColor;
        if (baseImage != null) {
            basePixelIO = PixelIOFactory.getPixelIO(baseImage.getFormat());
            materialColor = new float[this.materialColor.length];
            basePixel = new TexturePixel();
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = image.getDepth();
        if (depth == 0) {
            depth = 1;
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(depth);
        float[] resultPixel = new float[4];
        float[] tinAndAlpha = new float[2];
        for (int dataLayerIndex = 0; dataLayerIndex < depth; ++dataLayerIndex) {
            ByteBuffer data = image.getData(dataLayerIndex);
            data.rewind();
            ByteBuffer newData = BufferUtils.createByteBuffer((int)(data.limit() * 4));
            int dataIndex = 0;
            int x = 0;
            int y = 0;
            while (data.hasRemaining()) {
                if (basePixelIO != null) {
                    basePixelIO.read(baseImage, dataLayerIndex, basePixel, x, y);
                    basePixel.toRGBA(materialColor);
                    if (++x >= width) {
                        x = 0;
                        ++y;
                    }
                }
                this.getTinAndAlpha(data, format, this.negateTexture, tinAndAlpha);
                this.blendPixel(resultPixel, materialColor, this.color, tinAndAlpha[0], this.blendFactor, this.blendType, blenderContext);
                newData.put(dataIndex++, (byte)(resultPixel[0] * 255.0f));
                newData.put(dataIndex++, (byte)(resultPixel[1] * 255.0f));
                newData.put(dataIndex++, (byte)(resultPixel[2] * 255.0f));
                newData.put(dataIndex++, (byte)(tinAndAlpha[1] * 255.0f));
            }
            dataArray.add(newData);
        }
        Image image2 = result = depth > 1 ? new Image(Image.Format.RGBA8, width, height, depth, dataArray, ColorSpace.Linear) : new Image(Image.Format.RGBA8, width, height, (ByteBuffer)dataArray.get(0), ColorSpace.Linear);
        if (image.getMipMapSizes() != null) {
            result.setMipMapSizes((int[])image.getMipMapSizes().clone());
        }
        return result;
    }

    protected void getTinAndAlpha(ByteBuffer data, Image.Format imageFormat, boolean neg, float[] result) {
        byte pixelValue = data.get();
        float firstPixelValue = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
        switch (imageFormat) {
            case Luminance8: {
                result[0] = neg ? 1.0f - firstPixelValue : firstPixelValue;
                result[1] = 1.0f;
                break;
            }
            case Luminance8Alpha8: {
                result[0] = neg ? 1.0f - firstPixelValue : firstPixelValue;
                pixelValue = data.get();
                result[1] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                break;
            }
            case Luminance16F: 
            case Luminance16FAlpha16F: 
            case Luminance32F: {
                LOGGER.log(Level.WARNING, "Image type not yet supported for blending: {0}", imageFormat);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid image format type for Luminance texture blender: " + imageFormat);
            }
        }
    }

    protected void blendPixel(float[] result, float[] materialColor, float[] color, float textureIntensity, float textureFactor, int blendtype, BlenderContext blenderContext) {
        textureIntensity *= textureFactor;
        switch (blendtype) {
            case 0: {
                float oneMinusFactor = 1.0f - textureIntensity;
                result[0] = textureIntensity * color[0] + oneMinusFactor * materialColor[0];
                result[1] = textureIntensity * color[1] + oneMinusFactor * materialColor[1];
                result[2] = textureIntensity * color[2] + oneMinusFactor * materialColor[2];
                break;
            }
            case 1: {
                float oneMinusFactor = 1.0f - textureFactor;
                result[0] = (oneMinusFactor + textureIntensity * materialColor[0]) * color[0];
                result[1] = (oneMinusFactor + textureIntensity * materialColor[1]) * color[1];
                result[2] = (oneMinusFactor + textureIntensity * materialColor[2]) * color[2];
                break;
            }
            case 4: {
                float oneMinusFactor = 1.0f - textureIntensity;
                if ((double)color[0] != 0.0) {
                    result[0] = (oneMinusFactor * materialColor[0] + textureIntensity * materialColor[0] / color[0]) * 0.5f;
                }
                if ((double)color[1] != 0.0) {
                    result[1] = (oneMinusFactor * materialColor[1] + textureIntensity * materialColor[1] / color[1]) * 0.5f;
                }
                if ((double)color[2] == 0.0) break;
                result[2] = (oneMinusFactor * materialColor[2] + textureIntensity * materialColor[2] / color[2]) * 0.5f;
                break;
            }
            case 8: {
                float oneMinusFactor = 1.0f - textureFactor;
                result[0] = 1.0f - (oneMinusFactor + textureIntensity * (1.0f - materialColor[0])) * (1.0f - color[0]);
                result[1] = 1.0f - (oneMinusFactor + textureIntensity * (1.0f - materialColor[1])) * (1.0f - color[1]);
                result[2] = 1.0f - (oneMinusFactor + textureIntensity * (1.0f - materialColor[2])) * (1.0f - color[2]);
                break;
            }
            case 9: {
                float oneMinusFactor = 1.0f - textureFactor;
                result[0] = materialColor[0] < 0.5f ? color[0] * (oneMinusFactor + 2.0f * textureIntensity * materialColor[0]) : 1.0f - (oneMinusFactor + 2.0f * textureIntensity * (1.0f - materialColor[0])) * (1.0f - color[0]);
                result[1] = materialColor[1] < 0.5f ? color[1] * (oneMinusFactor + 2.0f * textureIntensity * materialColor[1]) : 1.0f - (oneMinusFactor + 2.0f * textureIntensity * (1.0f - materialColor[1])) * (1.0f - color[1]);
                if (materialColor[2] < 0.5f) {
                    result[2] = color[2] * (oneMinusFactor + 2.0f * textureIntensity * materialColor[2]);
                    break;
                }
                result[2] = 1.0f - (oneMinusFactor + 2.0f * textureIntensity * (1.0f - materialColor[2])) * (1.0f - color[2]);
                break;
            }
            case 3: {
                result[0] = materialColor[0] - textureIntensity * color[0];
                result[1] = materialColor[1] - textureIntensity * color[1];
                result[2] = materialColor[2] - textureIntensity * color[2];
                result[0] = FastMath.clamp((float)result[0], (float)0.0f, (float)1.0f);
                result[1] = FastMath.clamp((float)result[1], (float)0.0f, (float)1.0f);
                result[2] = FastMath.clamp((float)result[2], (float)0.0f, (float)1.0f);
                break;
            }
            case 2: {
                result[0] = (textureIntensity * color[0] + materialColor[0]) * 0.5f;
                result[1] = (textureIntensity * color[1] + materialColor[1]) * 0.5f;
                result[2] = (textureIntensity * color[2] + materialColor[2]) * 0.5f;
                break;
            }
            case 6: {
                float oneMinusFactor = 1.0f - textureIntensity;
                result[0] = oneMinusFactor * materialColor[0] + textureIntensity * Math.abs(materialColor[0] - color[0]);
                result[1] = oneMinusFactor * materialColor[1] + textureIntensity * Math.abs(materialColor[1] - color[1]);
                result[2] = oneMinusFactor * materialColor[2] + textureIntensity * Math.abs(materialColor[2] - color[2]);
                break;
            }
            case 5: {
                float col = textureIntensity * color[0];
                result[0] = col < materialColor[0] ? col : materialColor[0];
                col = textureIntensity * color[1];
                result[1] = col < materialColor[1] ? col : materialColor[1];
                col = textureIntensity * color[2];
                result[2] = col < materialColor[2] ? col : materialColor[2];
                break;
            }
            case 7: {
                float col = textureIntensity * color[0];
                result[0] = col > materialColor[0] ? col : materialColor[0];
                col = textureIntensity * color[1];
                result[1] = col > materialColor[1] ? col : materialColor[1];
                col = textureIntensity * color[2];
                result[2] = col > materialColor[2] ? col : materialColor[2];
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                System.arraycopy(materialColor, 0, result, 0, 3);
                this.blendHSV(blendtype, result, textureIntensity, color, blenderContext);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown blend type: " + blendtype);
            }
        }
    }
}

