/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.blending;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderAWT;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderDDS;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderLuminance;
import com.jme3.texture.Image;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureBlenderFactory {
    private static final Logger LOGGER = Logger.getLogger(TextureBlenderFactory.class.getName());
    private static final TextureBlender NON_CHANGING_BLENDER = new TextureBlender(){

        @Override
        public Image blend(Image image, Image baseImage, BlenderContext blenderContext) {
            return image;
        }

        @Override
        public void copyBlendingData(TextureBlender textureBlender) {
        }
    };

    public static TextureBlender createTextureBlender(Image.Format format, int flag, boolean negate, int blendType, float[] materialColor, float[] color, float colfac) {
        switch (format) {
            case Luminance8: 
            case Luminance8Alpha8: 
            case Luminance16F: 
            case Luminance16FAlpha16F: 
            case Luminance32F: {
                return new TextureBlenderLuminance(flag, negate, blendType, materialColor, color, colfac);
            }
            case RGBA8: 
            case ABGR8: 
            case BGR8: 
            case RGB8: 
            case RGB111110F: 
            case RGB16F: 
            case RGB16F_to_RGB111110F: 
            case RGB16F_to_RGB9E5: 
            case RGB32F: 
            case RGB565: 
            case RGB5A1: 
            case RGB9E5: 
            case RGBA16F: 
            case RGBA32F: {
                return new TextureBlenderAWT(flag, negate, blendType, materialColor, color, colfac);
            }
            case DXT1: 
            case DXT1A: 
            case DXT3: 
            case DXT5: {
                return new TextureBlenderDDS(flag, negate, blendType, materialColor, color, colfac);
            }
        }
        LOGGER.log(Level.WARNING, "Image type not yet supported for blending: {0}. Returning a blender that does not change the texture.", format);
        return NON_CHANGING_BLENDER;
    }

    public static TextureBlender alterTextureType(Image.Format format, TextureBlender textureBlender) {
        TextureBlender result = TextureBlenderFactory.createTextureBlender(format, 0, false, 0, null, null, 0.0f);
        result.copyBlendingData(textureBlender);
        return result;
    }
}

