/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;

public class TexturePixel
implements Cloneable {
    public float intensity;
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public void fromPixel(TexturePixel pixel) {
        this.intensity = pixel.intensity;
        this.red = pixel.red;
        this.green = pixel.green;
        this.blue = pixel.blue;
        this.alpha = pixel.alpha;
    }

    public void fromColor(ColorRGBA colorRGBA) {
        this.red = colorRGBA.r;
        this.green = colorRGBA.g;
        this.blue = colorRGBA.b;
        this.alpha = colorRGBA.a;
    }

    public void fromARGB(float a, float r, float g, float b) {
        this.alpha = a;
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public void fromARGB8(byte a, byte r, byte g, byte b) {
        this.alpha = a >= 0 ? (float)a / 255.0f : 1.0f - (float)(~a) / 255.0f;
        this.red = r >= 0 ? (float)r / 255.0f : 1.0f - (float)(~r) / 255.0f;
        this.green = g >= 0 ? (float)g / 255.0f : 1.0f - (float)(~g) / 255.0f;
        this.blue = b >= 0 ? (float)b / 255.0f : 1.0f - (float)(~b) / 255.0f;
    }

    public void fromARGB16(short a, short r, short g, short b) {
        this.alpha = a >= 0 ? (float)a / 65535.0f : 1.0f - (float)(~a) / 65535.0f;
        this.red = r >= 0 ? (float)r / 65535.0f : 1.0f - (float)(~r) / 65535.0f;
        this.green = g >= 0 ? (float)g / 65535.0f : 1.0f - (float)(~g) / 65535.0f;
        this.blue = b >= 0 ? (float)b / 65535.0f : 1.0f - (float)(~b) / 65535.0f;
    }

    public void fromIntensity(byte intensity) {
        this.intensity = intensity >= 0 ? (float)intensity / 255.0f : 1.0f - (float)(~intensity) / 255.0f;
    }

    public void fromIntensity(short intensity) {
        this.intensity = intensity >= 0 ? (float)intensity / 65535.0f : 1.0f - (float)(~intensity) / 65535.0f;
    }

    public void setAlpha(byte alpha) {
        this.alpha = alpha >= 0 ? (float)alpha / 255.0f : 1.0f - (float)(~alpha) / 255.0f;
    }

    public void setAlpha(short alpha) {
        this.alpha = alpha >= 0 ? (float)alpha / 65535.0f : 1.0f - (float)(~alpha) / 65535.0f;
    }

    public void fromARGB8(int argb8) {
        byte pixelValue = (byte)((argb8 & 0xFF000000) >> 24);
        this.alpha = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
        pixelValue = (byte)((argb8 & 0xFF0000) >> 16);
        this.red = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
        pixelValue = (byte)((argb8 & 0xFF00) >> 8);
        this.green = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
        pixelValue = (byte)(argb8 & 0xFF);
        this.blue = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
    }

    public void toRGBA(float[] result) {
        result[0] = this.red;
        result[1] = this.green;
        result[2] = this.blue;
        result[3] = this.alpha;
    }

    public void toRGBA8(byte[] result) {
        result[0] = (byte)(this.red * 255.0f);
        result[1] = (byte)(this.green * 255.0f);
        result[2] = (byte)(this.blue * 255.0f);
        result[3] = (byte)(this.alpha * 255.0f);
    }

    public int toARGB8() {
        int result = 0;
        int b = (int)(this.alpha * 255.0f);
        result |= b << 24;
        b = (int)(this.red * 255.0f);
        result |= b << 16;
        b = (int)(this.green * 255.0f);
        result |= b << 8;
        b = (int)(this.blue * 255.0f);
        return result |= b;
    }

    public byte getInt() {
        return (byte)(this.intensity * 255.0f);
    }

    public byte getA8() {
        return (byte)(this.alpha * 255.0f);
    }

    public byte getR8() {
        return (byte)(this.red * 255.0f);
    }

    public byte getG8() {
        return (byte)(this.green * 255.0f);
    }

    public byte getB8() {
        return (byte)(this.blue * 255.0f);
    }

    public short getA16() {
        return (byte)(this.alpha * 65535.0f);
    }

    public short getR16() {
        return (byte)(this.red * 65535.0f);
    }

    public short getG16() {
        return (byte)(this.green * 65535.0f);
    }

    public short getB16() {
        return (byte)(this.blue * 65535.0f);
    }

    public void merge(TexturePixel pixel) {
        float oneMinusAlpha = 1.0f - pixel.alpha;
        this.red = oneMinusAlpha * this.red + pixel.alpha * pixel.red;
        this.green = oneMinusAlpha * this.green + pixel.alpha * pixel.green;
        this.blue = oneMinusAlpha * this.blue + pixel.alpha * pixel.blue;
        this.alpha = (this.alpha + pixel.alpha) * 0.5f;
    }

    public void mix(TexturePixel pixel) {
        this.red = 0.5f * (this.red + pixel.red);
        this.green = 0.5f * (this.green + pixel.green);
        this.blue = 0.5f * (this.blue + pixel.blue);
        this.alpha = 0.5f * (this.alpha + pixel.alpha);
        this.intensity = 0.5f * (this.intensity + pixel.intensity);
    }

    public void negate() {
        this.red = 1.0f - this.red;
        this.green = 1.0f - this.green;
        this.blue = 1.0f - this.blue;
        this.alpha = 1.0f - this.alpha;
    }

    public void clear() {
        this.alpha = 0.0f;
        this.green = 0.0f;
        this.red = 0.0f;
        this.blue = 0.0f;
        this.intensity = 0.0f;
    }

    public void add(TexturePixel pixel) {
        this.red += pixel.red;
        this.green += pixel.green;
        this.blue += pixel.blue;
        this.alpha += pixel.alpha;
        this.intensity += pixel.intensity;
    }

    public void add(ColorRGBA pixel) {
        this.red += pixel.r;
        this.green += pixel.g;
        this.blue += pixel.b;
        this.alpha += pixel.a;
    }

    public void mult(float value) {
        this.red *= value;
        this.green *= value;
        this.blue *= value;
        this.alpha *= value;
        this.intensity *= value;
    }

    public void divide(float value) {
        this.red /= value;
        this.green /= value;
        this.blue /= value;
        this.alpha /= value;
        this.intensity /= value;
    }

    public void clamp(float min, float max) {
        this.red = FastMath.clamp((float)this.red, (float)min, (float)max);
        this.green = FastMath.clamp((float)this.green, (float)min, (float)max);
        this.blue = FastMath.clamp((float)this.blue, (float)min, (float)max);
        this.alpha = FastMath.clamp((float)this.alpha, (float)min, (float)max);
        this.intensity = FastMath.clamp((float)this.intensity, (float)min, (float)max);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "[" + this.red + ", " + this.green + ", " + this.blue + ", " + this.alpha + " {" + this.intensity + "}]";
    }
}

