/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.textures.ImageUtils;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.TriangulatedTexture;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.TempVars;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

class GeneratedTexture
extends Texture {
    private static final int POSITIVE_X = 0;
    private static final int NEGATIVE_X = 1;
    private static final int POSITIVE_Y = 2;
    private static final int NEGATIVE_Y = 3;
    private static final int POSITIVE_Z = 4;
    private static final int NEGATIVE_Z = 5;
    public static final int TEX_COLORBAND = 1;
    public static final int TEX_FLIPBLEND = 2;
    public static final int TEX_NEGALPHA = 4;
    public static final int TEX_CHECKER_ODD = 8;
    public static final int TEX_CHECKER_EVEN = 16;
    public static final int TEX_PRV_ALPHA = 32;
    public static final int TEX_PRV_NOR = 64;
    public static final int TEX_REPEAT_XMIR = 128;
    public static final int TEX_REPEAT_YMIR = 256;
    public static final int TEX_FLAG_MASK = 511;
    private final Structure mTex;
    private final TextureGenerator textureGenerator;
    private static final CastFunction[] CAST_FUNCTIONS = new CastFunction[]{new CastFunction(){

        @Override
        public void cast(Vector3f pointToCast, float radius) {
            float length = 2.0f * pointToCast.subtractLocal(0.5f, 0.5f, 0.5f).length() * radius;
            pointToCast.normalizeLocal().addLocal(0.5f, 0.5f, 0.5f).multLocal(length);
        }
    }, new CastFunction(){

        @Override
        public void cast(Vector3f pointToCast, float radius) {
            pointToCast.subtractLocal(0.5f, 0.5f, 0.5f).normalizeLocal().multLocal(radius).addLocal(0.5f, 0.5f, 0.5f);
        }
    }};

    public GeneratedTexture(Structure tex, Structure mTex, TextureGenerator textureGenerator, BlenderContext blenderContext) {
        this.mTex = mTex;
        this.textureGenerator = textureGenerator;
        this.textureGenerator.readData(tex, blenderContext);
        super.setImage((Image)new GeneratedTextureImage(textureGenerator.getImageFormat()));
    }

    public void getPixel(TexturePixel pixel, float u, float v, float s) {
        this.textureGenerator.getPixel(pixel, u, v, s);
    }

    public TriangulatedTexture triangulate(Mesh mesh, Long geometriesOMA, UVCoordinatesGenerator.UVCoordinatesType coordinatesType, BlenderContext blenderContext) {
        TemporalMesh geometries = (TemporalMesh)((Object)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedDataType.TEMPORAL_MESH));
        int[] coordinatesSwappingIndexes = new int[]{((Number)this.mTex.getFieldValue("projx")).intValue(), ((Number)this.mTex.getFieldValue("projy")).intValue(), ((Number)this.mTex.getFieldValue("projz")).intValue()};
        List<Vector3f> uvs = UVCoordinatesGenerator.generateUVCoordinatesFor3DTexture(mesh, coordinatesType, coordinatesSwappingIndexes, geometries);
        Vector3f[] uvsArray = uvs.toArray(new Vector3f[uvs.size()]);
        BoundingBox boundingBox = UVCoordinatesGenerator.getBoundingBox(geometries);
        TreeSet<TriangulatedTexture.TriangleTextureElement> triangleTextureElements = new TreeSet<TriangulatedTexture.TriangleTextureElement>(new Comparator<TriangulatedTexture.TriangleTextureElement>(){

            @Override
            public int compare(TriangulatedTexture.TriangleTextureElement o1, TriangulatedTexture.TriangleTextureElement o2) {
                return o1.faceIndex - o2.faceIndex;
            }
        });
        int[] indices = new int[3];
        for (int i = 0; i < mesh.getTriangleCount(); ++i) {
            mesh.getTriangle(i, indices);
            triangleTextureElements.add(new TriangulatedTexture.TriangleTextureElement(i, boundingBox, this, uvsArray, indices, blenderContext));
        }
        return new TriangulatedTexture(triangleTextureElements, blenderContext);
    }

    public TextureCubeMap generateSkyTexture(int size, ColorRGBA horizontalColor, ColorRGBA zenithColor, BlenderContext blenderContext) {
        Image image = ImageUtils.createEmptyImage(Image.Format.RGB8, size, size, 6);
        PixelInputOutput pixelIO = PixelIOFactory.getPixelIO(image.getFormat());
        TexturePixel pixel = new TexturePixel();
        float delta = 1.0f / (float)(size - 1);
        float sideS = 1.0f;
        float forwardU = 1.0f;
        TempVars tempVars = TempVars.get();
        CastFunction castFunction = CAST_FUNCTIONS[blenderContext.getBlenderKey().getSkyGeneratedTextureShape().ordinal()];
        float castRadius = blenderContext.getBlenderKey().getSkyGeneratedTextureRadius();
        for (int x = 0; x < size; ++x) {
            float sideV = 1.0f;
            float forwardV = 1.0f;
            float upS = 0.0f;
            for (int y = 0; y < size; ++y) {
                castFunction.cast(tempVars.vect1.set(1.0f, sideV, sideS), castRadius);
                this.textureGenerator.getPixel(pixel, tempVars.vect1.x, tempVars.vect1.y, tempVars.vect1.z);
                pixelIO.write(image, 1, ImageUtils.color(pixel, horizontalColor, zenithColor), x, y);
                castFunction.cast(tempVars.vect1.set(0.0f, sideV, 1.0f - sideS), castRadius);
                this.textureGenerator.getPixel(pixel, tempVars.vect1.x, tempVars.vect1.y, tempVars.vect1.z);
                pixelIO.write(image, 0, ImageUtils.color(pixel, horizontalColor, zenithColor), x, y);
                castFunction.cast(tempVars.vect1.set(forwardU, forwardV, 0.0f), castRadius);
                this.textureGenerator.getPixel(pixel, tempVars.vect1.x, tempVars.vect1.y, tempVars.vect1.z);
                pixelIO.write(image, 4, ImageUtils.color(pixel, horizontalColor, zenithColor), x, y);
                castFunction.cast(tempVars.vect1.set(1.0f - forwardU, forwardV, 1.0f), castRadius);
                this.textureGenerator.getPixel(pixel, tempVars.vect1.x, tempVars.vect1.y, tempVars.vect1.z);
                pixelIO.write(image, 5, ImageUtils.color(pixel, horizontalColor, zenithColor), x, y);
                castFunction.cast(tempVars.vect1.set(forwardU, 0.0f, upS), castRadius);
                this.textureGenerator.getPixel(pixel, tempVars.vect1.x, tempVars.vect1.y, tempVars.vect1.z);
                pixelIO.write(image, 3, ImageUtils.color(pixel, horizontalColor, zenithColor), x, y);
                castFunction.cast(tempVars.vect1.set(forwardU, 1.0f, 1.0f - upS), castRadius);
                this.textureGenerator.getPixel(pixel, tempVars.vect1.x, tempVars.vect1.y, tempVars.vect1.z);
                pixelIO.write(image, 2, ImageUtils.color(pixel, horizontalColor, zenithColor), x, y);
                sideV = FastMath.clamp((float)(sideV - delta), (float)0.0f, (float)1.0f);
                forwardV = FastMath.clamp((float)(forwardV - delta), (float)0.0f, (float)1.0f);
                upS = FastMath.clamp((float)(upS + delta), (float)0.0f, (float)1.0f);
            }
            sideS = FastMath.clamp((float)(sideS - delta), (float)0.0f, (float)1.0f);
            forwardU = FastMath.clamp((float)(forwardU - delta), (float)0.0f, (float)1.0f);
        }
        tempVars.release();
        return new TextureCubeMap(image);
    }

    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
    }

    public void setWrap(Texture.WrapMode mode) {
    }

    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        return null;
    }

    public Texture.Type getType() {
        return Texture.Type.ThreeDimensional;
    }

    public Texture createSimpleClone() {
        return null;
    }

    private static interface CastFunction {
        public void cast(Vector3f var1, float var2);
    }

    private static class GeneratedTextureImage
    extends Image {
        public GeneratedTextureImage(Image.Format imageFormat) {
            this.format = imageFormat;
        }
    }
}

