/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.objects;

import com.jme3.light.Light;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.LightNode;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.AnimationHelper;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.curves.CurvesTemporalMesh;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.modifiers.ModifierHelper;
import com.jme3.scene.plugins.blender.objects.Properties;
import com.jme3.util.TempVars;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ObjectHelper.class.getName());
    public static final String OMA_MARKER = "oma";
    public static final String ARMATURE_NODE_MARKER = "armature-node";

    public ObjectHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toObject(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        Object loadedResult = blenderContext.getLoadedFeature(objectStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE);
        if (loadedResult != null) {
            return loadedResult;
        }
        LOGGER.fine("Loading blender object.");
        if ("ID".equals(objectStructure.getType())) {
            Node object = (Node)this.loadLibrary(objectStructure);
            if (object.getParent() != null) {
                LOGGER.log(Level.FINEST, "Detaching object {0}, loaded from external file, from its parent.", object);
                object.getParent().detachChild((Spatial)object);
            }
            return object;
        }
        int type = ((Number)objectStructure.getFieldValue("type")).intValue();
        ObjectType objectType = ObjectType.valueOf(type);
        LOGGER.log(Level.FINE, "Type of the object: {0}.", (Object)objectType);
        int lay = ((Number)objectStructure.getFieldValue("lay")).intValue();
        if ((lay & blenderContext.getBlenderKey().getLayersToLoad()) == 0) {
            LOGGER.fine("The layer this object is located in is not included in loading.");
            return null;
        }
        blenderContext.pushParent(objectStructure);
        String name = objectStructure.getName();
        LOGGER.log(Level.FINE, "Loading obejct: {0}", name);
        int restrictflag = ((Number)objectStructure.getFieldValue("restrictflag")).intValue();
        boolean visible = (restrictflag & 1) != 0;
        Pointer pParent = (Pointer)objectStructure.getFieldValue("parent");
        Object parent = blenderContext.getLoadedFeature(pParent.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE);
        if (parent == null && pParent.isNotNull()) {
            Structure parentStructure = pParent.fetchData().get(0);
            parent = this.toObject(parentStructure, blenderContext);
        }
        Transform t = this.getTransformation(objectStructure, blenderContext);
        LOGGER.log(Level.FINE, "Importing object of type: {0}", (Object)objectType);
        Node result = null;
        try {
            switch (objectType) {
                case LATTICE: 
                case METABALL: 
                case TEXT: 
                case WAVE: {
                    LOGGER.log(Level.WARNING, "{0} type is not supported but the node will be returned in order to keep parent - child relationship.", (Object)objectType);
                }
                case EMPTY: 
                case ARMATURE: {
                    result = new Node(name);
                    break;
                }
                case MESH: {
                    result = new Node(name);
                    MeshHelper meshHelper = (MeshHelper)blenderContext.getHelper(MeshHelper.class);
                    Pointer pMesh = (Pointer)objectStructure.getFieldValue("data");
                    List<Structure> meshesArray = pMesh.fetchData();
                    TemporalMesh temporalMesh = meshHelper.toTemporalMesh(meshesArray.get(0), blenderContext);
                    if (temporalMesh == null) break;
                    result.attachChild((Spatial)temporalMesh);
                    break;
                }
                case SURF: 
                case CURVE: {
                    Structure curveData;
                    CurvesHelper curvesHelper;
                    CurvesTemporalMesh curvesTemporalMesh;
                    result = new Node(name);
                    Pointer pCurve = (Pointer)objectStructure.getFieldValue("data");
                    if (!pCurve.isNotNull() || (curvesTemporalMesh = (curvesHelper = (CurvesHelper)blenderContext.getHelper(CurvesHelper.class)).toCurve(curveData = pCurve.fetchData().get(0), blenderContext)) == null) break;
                    result.attachChild((Spatial)curvesTemporalMesh);
                    break;
                }
                case LAMP: {
                    List<Structure> lampsArray;
                    Pointer pLamp = (Pointer)objectStructure.getFieldValue("data");
                    if (!pLamp.isNotNull()) break;
                    LightHelper lightHelper = (LightHelper)blenderContext.getHelper(LightHelper.class);
                    Light light = lightHelper.toLight((lampsArray = pLamp.fetchData()).get(0), blenderContext);
                    if (light == null) {
                        result = new Node(name);
                        break;
                    }
                    result = new LightNode(name, light);
                    break;
                }
                case CAMERA: {
                    List<Structure> camerasArray;
                    Pointer pCamera = (Pointer)objectStructure.getFieldValue("data");
                    if (!pCamera.isNotNull()) break;
                    CameraHelper cameraHelper = (CameraHelper)blenderContext.getHelper(CameraHelper.class);
                    Camera camera = cameraHelper.toCamera((camerasArray = pCamera.fetchData()).get(0), blenderContext);
                    if (camera == null) {
                        result = new Node(name);
                        break;
                    }
                    result = new CameraNode(name, camera);
                    break;
                }
                default: {
                    LOGGER.log(Level.WARNING, "Unsupported object type: {0}", type);
                }
            }
            if (result != null) {
                Properties properties;
                LOGGER.fine("Storing loaded feature in blender context and applying markers (those will be removed before the final result is released).");
                Long oma = objectStructure.getOldMemoryAddress();
                blenderContext.addLoadedFeatures(oma, BlenderContext.LoadedDataType.STRUCTURE, objectStructure);
                blenderContext.addLoadedFeatures(oma, BlenderContext.LoadedDataType.FEATURE, result);
                blenderContext.addMarker(OMA_MARKER, result, objectStructure.getOldMemoryAddress());
                if (objectType == ObjectType.ARMATURE) {
                    blenderContext.addMarker(ARMATURE_NODE_MARKER, result, Boolean.TRUE);
                }
                result.setLocalTransform(t);
                result.setCullHint(visible ? Spatial.CullHint.Always : Spatial.CullHint.Inherit);
                if (parent instanceof Node) {
                    ((Node)parent).attachChild((Spatial)result);
                }
                LOGGER.fine("Reading and applying object's modifiers.");
                ModifierHelper modifierHelper = (ModifierHelper)blenderContext.getHelper(ModifierHelper.class);
                Collection<Modifier> modifiers = modifierHelper.readModifiers(objectStructure, blenderContext);
                for (Modifier modifier : modifiers) {
                    modifier.apply(result, blenderContext);
                }
                if (result.getChildren() != null && result.getChildren().size() > 0) {
                    if (result.getChildren().size() == 1 && result.getChild(0) instanceof TemporalMesh) {
                        LOGGER.fine("Converting temporal mesh into jme geometries.");
                        ((TemporalMesh)result.getChild(0)).toGeometries();
                    }
                    LOGGER.fine("Applying proper scale to the geometries.");
                    for (Spatial child : result.getChildren()) {
                        if (!(child instanceof Geometry)) continue;
                        this.flipMeshIfRequired((Geometry)child, child.getWorldScale());
                    }
                }
                result.updateModelBound();
                LOGGER.fine("Applying animations to the object if such are defined.");
                AnimationHelper animationHelper = (AnimationHelper)blenderContext.getHelper(AnimationHelper.class);
                animationHelper.applyAnimations(result, blenderContext.getBlenderKey().getAnimationMatchMethod());
                LOGGER.fine("Loading constraints connected with this object.");
                ConstraintHelper constraintHelper = (ConstraintHelper)blenderContext.getHelper(ConstraintHelper.class);
                constraintHelper.loadConstraints(objectStructure, blenderContext);
                LOGGER.fine("Loading custom properties.");
                if (blenderContext.getBlenderKey().isLoadObjectProperties() && (properties = this.loadProperties(objectStructure, blenderContext)) != null && properties.getValue() != null) {
                    this.applyProperties((Spatial)result, properties);
                }
            }
        }
        finally {
            blenderContext.popParent();
        }
        return result;
    }

    private void flipMeshIfRequired(Geometry geometry, Vector3f scale) {
        float s = scale.x * scale.y * scale.z;
        if (s < 0.0f && geometry.getMesh() != null) {
            FloatBuffer normals = geometry.getMesh().getFloatBuffer(VertexBuffer.Type.Normal);
            if (normals != null) {
                for (int i = 0; i < normals.limit(); i += 3) {
                    if (scale.x < 0.0f) {
                        normals.put(i, -normals.get(i));
                    }
                    if (scale.y < 0.0f) {
                        normals.put(i + 1, -normals.get(i + 1));
                    }
                    if (!(scale.z < 0.0f)) continue;
                    normals.put(i + 2, -normals.get(i + 2));
                }
            }
            if (geometry.getMesh().getMode() == Mesh.Mode.Triangles) {
                LOGGER.finer("Flipping index order in triangle mesh.");
                Buffer indexBuffer = geometry.getMesh().getBuffer(VertexBuffer.Type.Index).getData();
                for (int i = 0; i < indexBuffer.limit(); i += 3) {
                    short s2;
                    if (indexBuffer instanceof ShortBuffer) {
                        s2 = ((ShortBuffer)indexBuffer).get(i + 1);
                        ((ShortBuffer)indexBuffer).put(i + 1, ((ShortBuffer)indexBuffer).get(i + 2));
                        ((ShortBuffer)indexBuffer).put(i + 2, s2);
                        continue;
                    }
                    s2 = ((IntBuffer)indexBuffer).get(i + 1);
                    ((IntBuffer)indexBuffer).put(i + 1, ((IntBuffer)indexBuffer).get(i + 2));
                    ((IntBuffer)indexBuffer).put(i + 2, s2);
                }
            }
        }
    }

    public boolean isParent(Long supposedParentOMA, Long spatialOMA) {
        Spatial supposedParent = (Spatial)this.blenderContext.getLoadedFeature(supposedParentOMA, BlenderContext.LoadedDataType.FEATURE);
        Spatial spatial = (Spatial)this.blenderContext.getLoadedFeature(spatialOMA, BlenderContext.LoadedDataType.FEATURE);
        for (Node parent = spatial.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(supposedParent)) continue;
            return true;
        }
        return false;
    }

    public Transform getTransformation(Structure objectStructure, BlenderContext blenderContext) {
        TempVars tempVars = TempVars.get();
        Matrix4f parentInv = tempVars.tempMat4;
        Pointer pParent = (Pointer)objectStructure.getFieldValue("parent");
        if (pParent.isNotNull()) {
            Structure parentObjectStructure = (Structure)blenderContext.getLoadedFeature(pParent.getOldMemoryAddress(), BlenderContext.LoadedDataType.STRUCTURE);
            this.getMatrix(parentObjectStructure, "obmat", this.fixUpAxis, parentInv).invertLocal();
        } else {
            parentInv.loadIdentity();
        }
        Matrix4f globalMatrix = this.getMatrix(objectStructure, "obmat", this.fixUpAxis, tempVars.tempMat42);
        Matrix4f localMatrix = parentInv.multLocal(globalMatrix);
        this.getSizeSignums(objectStructure, tempVars.vect1);
        localMatrix.toTranslationVector(tempVars.vect2);
        localMatrix.toRotationQuat(tempVars.quat1);
        localMatrix.toScaleVector(tempVars.vect3);
        Transform t = new Transform(tempVars.vect2, tempVars.quat1.normalizeLocal(), tempVars.vect3.multLocal(tempVars.vect1));
        tempVars.release();
        return t;
    }

    private void getSizeSignums(Structure objectStructure, Vector3f store) {
        DynamicArray size = (DynamicArray)objectStructure.getFieldValue("size");
        if (this.fixUpAxis) {
            store.x = Math.signum(((Number)size.get(0)).floatValue());
            store.y = Math.signum(((Number)size.get(2)).floatValue());
            store.z = Math.signum(((Number)size.get(1)).floatValue());
        } else {
            store.x = Math.signum(((Number)size.get(0)).floatValue());
            store.y = Math.signum(((Number)size.get(1)).floatValue());
            store.z = Math.signum(((Number)size.get(2)).floatValue());
        }
    }

    private Matrix4f getMatrix(Structure structure, String matrixName, boolean fixUpAxis, Matrix4f store) {
        int i;
        DynamicArray obmat = (DynamicArray)structure.getFieldValue(matrixName);
        int rowAndColumnSize = Math.abs((int)Math.sqrt(obmat.getTotalSize()));
        for (i = 0; i < rowAndColumnSize; ++i) {
            for (int j = 0; j < rowAndColumnSize; ++j) {
                int[] nArray = new int[]{j, i};
                float value = ((Number)obmat.get(nArray)).floatValue();
                if (Math.abs(value) <= 1.1920929E-7f) {
                    value = 0.0f;
                }
                store.set(i, j, value);
            }
        }
        if (fixUpAxis) {
            for (i = 0; i < 4; ++i) {
                float temp = store.get(1, i);
                store.set(1, i, store.get(2, i));
                store.set(2, i, temp);
            }
            for (i = 0; i < 4; ++i) {
                float temp = store.get(i, 1);
                store.set(i, 1, store.get(i, 2));
                store.set(i, 2, temp);
            }
            store.m20 *= -1.0f;
            store.m21 *= -1.0f;
            store.m22 *= -1.0f;
            store.m23 *= -1.0f;
            store.m02 *= -1.0f;
            store.m12 *= -1.0f;
            store.m22 *= -1.0f;
            store.m32 *= -1.0f;
        }
        return store;
    }

    public Matrix4f getMatrix(Structure structure, String matrixName, boolean fixUpAxis) {
        return this.getMatrix(structure, matrixName, fixUpAxis, new Matrix4f());
    }

    private static enum ObjectType {
        EMPTY(0),
        MESH(1),
        CURVE(2),
        SURF(3),
        TEXT(4),
        METABALL(5),
        LAMP(10),
        CAMERA(11),
        WAVE(21),
        LATTICE(22),
        ARMATURE(25);

        private int blenderTypeValue;

        private ObjectType(int blenderTypeValue) {
            this.blenderTypeValue = blenderTypeValue;
        }

        public static ObjectType valueOf(int blenderTypeValue) throws BlenderFileException {
            for (ObjectType type : ObjectType.values()) {
                if (type.blenderTypeValue != blenderTypeValue) continue;
                return type;
            }
            throw new BlenderFileException("Unknown type value: " + blenderTypeValue);
        }
    }
}

