/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TriangulateModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(TriangulateModifier.class.getName());

    public TriangulateModifier(Structure objectStructure, Structure modifierStructure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.validate(modifierStructure, blenderContext)) {
            LOGGER.warning("Triangulation modifier does not take modifier options into account. If triangulation result is different than the model in blender please apply the modifier before importing!");
        }
    }

    @Override
    public void apply(Node node, BlenderContext blenderContext) {
        TemporalMesh temporalMesh;
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Triangulate modifier is invalid! Cannot be applied to: {0}", node.getName());
        }
        if ((temporalMesh = this.getTemporalMesh(node)) != null) {
            LOGGER.log(Level.FINE, "Applying triangulation modifier to: {0}", (Object)temporalMesh);
            temporalMesh.triangulate();
        } else {
            LOGGER.log(Level.WARNING, "Cannot find temporal mesh for node: {0}. The modifier will NOT be applied!", node);
        }
    }
}

