/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.Edge;
import com.jme3.scene.plugins.blender.meshes.Face;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SubdivisionSurfaceModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(SubdivisionSurfaceModifier.class.getName());
    private static final int TYPE_CATMULLCLARK = 0;
    private static final int TYPE_SIMPLE = 1;
    private static final int FLAG_SUBDIVIDE_UVS = 8;
    private int subdivType;
    private int levels;
    private boolean subdivideUVS;
    private Set<Integer> verticesOnOriginalEdges = new HashSet<Integer>();

    public SubdivisionSurfaceModifier(Structure modifierStructure, BlenderContext blenderContext) {
        if (this.validate(modifierStructure, blenderContext)) {
            this.subdivType = ((Number)modifierStructure.getFieldValue("subdivType")).intValue();
            this.levels = ((Number)modifierStructure.getFieldValue("levels")).intValue();
            int flag = ((Number)modifierStructure.getFieldValue("flags")).intValue();
            boolean bl = this.subdivideUVS = (flag & 8) != 0 && this.subdivType == 0;
            if (this.subdivType != 0 && this.subdivType != 1) {
                LOGGER.log(Level.SEVERE, "Unknown subdivision type: {0}.", this.subdivType);
                this.invalid = true;
            }
            if (this.levels < 0) {
                LOGGER.severe("The amount of subdivision levels cannot be negative.");
                this.invalid = true;
            }
        }
    }

    @Override
    public void apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Subdivision surface modifier is invalid! Cannot be applied to: {0}", node.getName());
        } else if (this.levels > 0) {
            TemporalMesh temporalMesh = this.getTemporalMesh(node);
            if (temporalMesh != null) {
                LOGGER.log(Level.FINE, "Applying subdivision surface modifier to: {0}", (Object)temporalMesh);
                this.verticesOnOriginalEdges.clear();
                for (Edge edge : temporalMesh.getEdges()) {
                    this.verticesOnOriginalEdges.add(edge.getFirstIndex());
                    this.verticesOnOriginalEdges.add(edge.getSecondIndex());
                }
                if (this.subdivType == 0) {
                    for (int i = 0; i < this.levels; ++i) {
                        this.subdivideSimple(temporalMesh);
                        this.subdivideCatmullClark(temporalMesh);
                        if (!this.subdivideUVS) continue;
                        this.subdivideUVs(temporalMesh);
                    }
                } else {
                    for (int i = 0; i < this.levels; ++i) {
                        this.subdivideSimple(temporalMesh);
                    }
                }
            } else {
                LOGGER.log(Level.WARNING, "Cannot find temporal mesh for node: {0}. The modifier will NOT be applied!", node);
            }
        }
    }

    private void subdivideCatmullClark(TemporalMesh temporalMesh) {
        Vector3f centroid;
        HashSet<Integer> boundaryVertices = new HashSet<Integer>();
        for (Edge edge : temporalMesh.getEdges()) {
            if (!edge.isInFace()) {
                boundaryVertices.add(edge.getFirstIndex());
                boundaryVertices.add(edge.getSecondIndex());
                continue;
            }
            if (temporalMesh.isBoundary(edge.getFirstIndex())) {
                boundaryVertices.add(edge.getFirstIndex());
            }
            if (!temporalMesh.isBoundary(edge.getSecondIndex())) continue;
            boundaryVertices.add(edge.getSecondIndex());
        }
        ArrayList<CreasePoint> creasePoints = new ArrayList<CreasePoint>(temporalMesh.getVertexCount());
        for (int i = 0; i < temporalMesh.getVertexCount(); ++i) {
            ArrayList<Edge> adjacentOriginalEdges = new ArrayList<Edge>();
            Collection<Edge> adjacentEdges = temporalMesh.getAdjacentEdges(i);
            if (adjacentEdges != null) {
                for (Edge edge : temporalMesh.getAdjacentEdges(i)) {
                    if (!this.verticesOnOriginalEdges.contains(edge.getFirstIndex()) && !this.verticesOnOriginalEdges.contains(edge.getSecondIndex())) continue;
                    adjacentOriginalEdges.add(edge);
                }
                creasePoints.add(new CreasePoint(i, boundaryVertices.contains(i), adjacentOriginalEdges, temporalMesh));
                continue;
            }
            creasePoints.add(null);
        }
        Vector3f[] averageVert = new Vector3f[temporalMesh.getVertexCount()];
        int[] averageCount = new int[temporalMesh.getVertexCount()];
        for (Face face : temporalMesh.getFaces()) {
            centroid = face.computeCentroid();
            for (Integer index : face.getIndexes()) {
                if (boundaryVertices.contains(index)) {
                    Edge edge = this.findEdge(temporalMesh, index, face.getIndexes().getNextIndex(index));
                    if (temporalMesh.isBoundary(edge)) {
                        averageVert[index.intValue()] = averageVert[index] == null ? edge.computeCentroid() : averageVert[index].addLocal(edge.computeCentroid());
                        int n = index;
                        averageCount[n] = averageCount[n] + 1;
                    }
                    if (!temporalMesh.isBoundary(edge = this.findEdge(temporalMesh, face.getIndexes().getPreviousIndex(index), index))) continue;
                    averageVert[index.intValue()] = averageVert[index] == null ? edge.computeCentroid() : averageVert[index].addLocal(edge.computeCentroid());
                    int n = index;
                    averageCount[n] = averageCount[n] + 1;
                    continue;
                }
                averageVert[index.intValue()] = averageVert[index] == null ? centroid.clone() : averageVert[index].addLocal(centroid);
                int n = index;
                averageCount[n] = averageCount[n] + 1;
            }
        }
        for (Edge edge : temporalMesh.getEdges()) {
            if (edge.isInFace()) continue;
            centroid = temporalMesh.getVertices().get(edge.getFirstIndex()).add(temporalMesh.getVertices().get(edge.getSecondIndex())).divideLocal(2.0f);
            averageVert[edge.getFirstIndex()] = averageVert[edge.getFirstIndex()] == null ? centroid.clone() : averageVert[edge.getFirstIndex()].addLocal(centroid);
            averageVert[edge.getSecondIndex()] = averageVert[edge.getSecondIndex()] == null ? centroid.clone() : averageVert[edge.getSecondIndex()].addLocal(centroid);
            int n = edge.getFirstIndex();
            averageCount[n] = averageCount[n] + 1;
            int n2 = edge.getSecondIndex();
            averageCount[n2] = averageCount[n2] + 1;
        }
        for (int i = 0; i < averageVert.length; ++i) {
            if (averageVert[i] == null || averageCount[i] <= 0) continue;
            Vector3f v = temporalMesh.getVertices().get(i);
            averageVert[i].divideLocal((float)averageCount[i]);
            Vector3f t = averageVert[i].subtract(v);
            if (!boundaryVertices.contains(i)) {
                t.multLocal(4.0f / (float)averageCount[i]);
            }
            v.addLocal(t);
            CreasePoint creasePoint = (CreasePoint)creasePoints.get(i);
            if (creasePoint.getTarget() == null || creasePoint.getWeight() == 0.0f) continue;
            t = creasePoint.getTarget().subtractLocal(v).multLocal(creasePoint.getWeight());
            v.addLocal(t);
        }
    }

    private void subdivideSimple(TemporalMesh temporalMesh) {
        HashMap<Edge, Integer> edgePoints = new HashMap<Edge, Integer>();
        HashMap<Face, Integer> facePoints = new HashMap<Face, Integer>();
        LinkedHashSet<Face> newFaces = new LinkedHashSet<Face>();
        LinkedHashSet<Edge> newEdges = new LinkedHashSet<Edge>(temporalMesh.getEdges().size() * 4);
        int originalFacesCount = temporalMesh.getFaces().size();
        List<Map<String, Float>> vertexGroups = temporalMesh.getVertexGroups();
        List<Vector3f> vertices = temporalMesh.getVertices();
        ArrayList<Vector3f> edgeVertices = new ArrayList<Vector3f>();
        ArrayList<Vector3f> faceVertices = new ArrayList<Vector3f>();
        List<Vector3f> normals = temporalMesh.getNormals();
        ArrayList<Vector3f> edgeNormals = new ArrayList<Vector3f>();
        ArrayList<Vector3f> faceNormals = new ArrayList<Vector3f>();
        List<Face> faces = temporalMesh.getFaces();
        for (Face face : faces) {
            Map<String, List<Vector2f>> uvSets = face.getUvSets();
            Vector3f facePoint = face.computeCentroid();
            Integer facePointIndex = vertices.size() + faceVertices.size();
            facePoints.put(face, facePointIndex);
            faceVertices.add(facePoint);
            faceNormals.add(this.computeFaceNormal(face));
            Map<String, Vector2f> faceUV = this.computeFaceUVs(face);
            byte[] faceVertexColor = this.computeFaceVertexColor(face);
            Map<String, Float> faceVertexGroups = this.computeFaceVertexGroups(face);
            if (vertexGroups.size() > 0) {
                vertexGroups.add(faceVertexGroups);
            }
            for (int i = 0; i < face.getIndexes().size(); ++i) {
                int vIndex = face.getIndexes().get(i);
                int vPrevIndex = i == 0 ? face.getIndexes().get(face.getIndexes().size() - 1) : face.getIndexes().get(i - 1);
                int vNextIndex = i == face.getIndexes().size() - 1 ? face.getIndexes().get(0) : face.getIndexes().get(i + 1);
                Edge prevEdge = this.findEdge(temporalMesh, vPrevIndex, vIndex);
                Edge nextEdge = this.findEdge(temporalMesh, vIndex, vNextIndex);
                int vPrevEdgeVertIndex = edgePoints.containsKey(prevEdge) ? (Integer)edgePoints.get(prevEdge) : -1;
                int vNextEdgeVertIndex = edgePoints.containsKey(nextEdge) ? (Integer)edgePoints.get(nextEdge) : -1;
                Vector3f v = temporalMesh.getVertices().get(vIndex);
                if (vPrevEdgeVertIndex < 0) {
                    vPrevEdgeVertIndex = vertices.size() + originalFacesCount + edgeVertices.size();
                    this.verticesOnOriginalEdges.add(vPrevEdgeVertIndex);
                    edgeVertices.add(vertices.get(vPrevIndex).add(v).divideLocal(2.0f));
                    edgeNormals.add(normals.get(vPrevIndex).add(normals.get(vIndex)).normalizeLocal());
                    edgePoints.put(prevEdge, vPrevEdgeVertIndex);
                    if (vertexGroups.size() > 0) {
                        vertexGroups.add(this.interpolateVertexGroups(Arrays.asList(vertexGroups.get(vPrevIndex), vertexGroups.get(vIndex))));
                    }
                }
                if (vNextEdgeVertIndex < 0) {
                    vNextEdgeVertIndex = vertices.size() + originalFacesCount + edgeVertices.size();
                    this.verticesOnOriginalEdges.add(vNextEdgeVertIndex);
                    edgeVertices.add(vertices.get(vNextIndex).add(v).divideLocal(2.0f));
                    edgeNormals.add(normals.get(vNextIndex).add(normals.get(vIndex)).normalizeLocal());
                    edgePoints.put(nextEdge, vNextEdgeVertIndex);
                    if (vertexGroups.size() > 0) {
                        vertexGroups.add(this.interpolateVertexGroups(Arrays.asList(vertexGroups.get(vNextIndex), vertexGroups.get(vIndex))));
                    }
                }
                Integer[] indexes = new Integer[]{vIndex, vNextEdgeVertIndex, facePointIndex, vPrevEdgeVertIndex};
                HashMap<String, List<Vector2f>> newUVSets = null;
                if (uvSets != null) {
                    newUVSets = new HashMap<String, List<Vector2f>>(uvSets.size());
                    for (Map.Entry<String, List<Vector2f>> uvset : uvSets.entrySet()) {
                        int indexOfvIndex = i;
                        int indexOfvPrevIndex = face.getIndexes().indexOf(vPrevIndex);
                        int indexOfvNextIndex = face.getIndexes().indexOf(vNextIndex);
                        Vector2f uv1 = uvset.getValue().get(indexOfvIndex);
                        Vector2f uv2 = uvset.getValue().get(indexOfvNextIndex).add(uv1).divideLocal(2.0f);
                        Vector2f uv3 = faceUV.get(uvset.getKey());
                        Vector2f uv4 = uvset.getValue().get(indexOfvPrevIndex).add(uv1).divideLocal(2.0f);
                        List<Vector2f> uvList = Arrays.asList(uv1, uv2, uv3, uv4);
                        newUVSets.put(uvset.getKey(), new ArrayList<Vector2f>(uvList));
                    }
                }
                ArrayList vertexColors = null;
                if (face.getVertexColors() != null) {
                    int indexOfvIndex = i;
                    int indexOfvPrevIndex = face.getIndexes().indexOf(vPrevIndex);
                    int indexOfvNextIndex = face.getIndexes().indexOf(vNextIndex);
                    byte[] vCol1 = face.getVertexColors().get(indexOfvIndex);
                    byte[] vCol2 = this.interpolateVertexColors(face.getVertexColors().get(indexOfvNextIndex), vCol1);
                    byte[] vCol3 = faceVertexColor;
                    byte[] vCol4 = this.interpolateVertexColors(face.getVertexColors().get(indexOfvPrevIndex), vCol1);
                    vertexColors = new ArrayList(Arrays.asList(vCol1, vCol2, vCol3, vCol4));
                }
                newFaces.add(new Face(indexes, face.isSmooth(), face.getMaterialNumber(), newUVSets, vertexColors, temporalMesh));
                newEdges.add(new Edge(vIndex, vNextEdgeVertIndex, nextEdge.getCrease(), true, temporalMesh));
                newEdges.add(new Edge(vNextEdgeVertIndex, facePointIndex, 0.0f, true, temporalMesh));
                newEdges.add(new Edge(facePointIndex, vPrevEdgeVertIndex, 0.0f, true, temporalMesh));
                newEdges.add(new Edge(vPrevEdgeVertIndex, vIndex, prevEdge.getCrease(), true, temporalMesh));
            }
        }
        vertices.addAll(faceVertices);
        vertices.addAll(edgeVertices);
        normals.addAll(faceNormals);
        normals.addAll(edgeNormals);
        for (Edge edge : temporalMesh.getEdges()) {
            if (edge.isInFace()) continue;
            int newVertexIndex = vertices.size();
            vertices.add(vertices.get(edge.getFirstIndex()).add(vertices.get(edge.getSecondIndex())).divideLocal(2.0f));
            normals.add(normals.get(edge.getFirstIndex()).add(normals.get(edge.getSecondIndex())).normalizeLocal());
            newEdges.add(new Edge(edge.getFirstIndex(), newVertexIndex, edge.getCrease(), false, temporalMesh));
            newEdges.add(new Edge(newVertexIndex, edge.getSecondIndex(), edge.getCrease(), false, temporalMesh));
            this.verticesOnOriginalEdges.add(newVertexIndex);
        }
        temporalMesh.getFaces().clear();
        temporalMesh.getFaces().addAll(newFaces);
        temporalMesh.getEdges().clear();
        temporalMesh.getEdges().addAll(newEdges);
        temporalMesh.rebuildIndexesMappings();
    }

    private void subdivideUVs(TemporalMesh temporalMesh) {
        List<Face> faces = temporalMesh.getFaces();
        HashMap<String, UvCoordsSubdivideTemporalMesh> subdividedUVS = new HashMap<String, UvCoordsSubdivideTemporalMesh>();
        for (Face face : faces) {
            if (face.getUvSets() == null) continue;
            for (Map.Entry<String, List<Vector2f>> uvset : face.getUvSets().entrySet()) {
                UvCoordsSubdivideTemporalMesh uvCoordsSubdivideTemporalMesh = (UvCoordsSubdivideTemporalMesh)((Object)subdividedUVS.get(uvset.getKey()));
                if (uvCoordsSubdivideTemporalMesh == null) {
                    block7: {
                        try {
                            uvCoordsSubdivideTemporalMesh = new UvCoordsSubdivideTemporalMesh(temporalMesh.getBlenderContext());
                        }
                        catch (BlenderFileException e) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError((Object)"Something went really wrong! The UvCoordsSubdivideTemporalMesh class should NOT throw exceptions here!");
                        }
                    }
                    subdividedUVS.put(uvset.getKey(), uvCoordsSubdivideTemporalMesh);
                }
                uvCoordsSubdivideTemporalMesh.addFace(uvset.getValue());
            }
        }
        for (Map.Entry entry : subdividedUVS.entrySet()) {
            ((UvCoordsSubdivideTemporalMesh)((Object)entry.getValue())).rebuildIndexesMappings();
            this.subdivideCatmullClark((TemporalMesh)((Object)entry.getValue()));
            for (int i = 0; i < faces.size(); ++i) {
                List<Vector2f> uvs = faces.get(i).getUvSets().get(entry.getKey());
                if (uvs == null) continue;
                uvs.clear();
                uvs.addAll(((UvCoordsSubdivideTemporalMesh)((Object)entry.getValue())).faceToUVs(i));
            }
        }
    }

    private Vector3f computeFaceNormal(Face face) {
        Vector3f result = new Vector3f();
        for (Integer index : face.getIndexes()) {
            result.addLocal(face.getTemporalMesh().getNormals().get(index));
        }
        result.divideLocal((float)face.getIndexes().size());
        return result;
    }

    private Map<String, Vector2f> computeFaceUVs(Face face) {
        HashMap<String, Vector2f> result = null;
        Map<String, List<Vector2f>> uvSets = face.getUvSets();
        if (uvSets != null && uvSets.size() > 0) {
            result = new HashMap<String, Vector2f>(uvSets.size());
            for (Map.Entry<String, List<Vector2f>> entry : uvSets.entrySet()) {
                Vector2f faceUV = new Vector2f();
                for (Vector2f uv : entry.getValue()) {
                    faceUV.addLocal(uv);
                }
                faceUV.divideLocal((float)entry.getValue().size());
                result.put(entry.getKey(), faceUV);
            }
        }
        return result;
    }

    private Map<String, Float> interpolateVertexGroups(List<Map<String, Float>> vertexGroups) {
        HashMap<String, Float> weightSums = new HashMap<String, Float>();
        if (vertexGroups.size() > 0) {
            for (Map<String, Float> vGroup : vertexGroups) {
                for (Map.Entry<String, Float> entry : vGroup.entrySet()) {
                    if (weightSums.containsKey(entry.getKey())) {
                        weightSums.put(entry.getKey(), Float.valueOf(((Float)weightSums.get(entry.getKey())).floatValue() + entry.getValue().floatValue()));
                        continue;
                    }
                    weightSums.put(entry.getKey(), entry.getValue());
                }
            }
        }
        HashMap<String, Float> result = new HashMap<String, Float>(weightSums.size());
        for (Map.Entry entry : weightSums.entrySet()) {
            result.put((String)entry.getKey(), Float.valueOf(((Float)entry.getValue()).floatValue() / (float)vertexGroups.size()));
        }
        return result;
    }

    private Map<String, Float> computeFaceVertexGroups(Face face) {
        if (face.getTemporalMesh().getVertexGroups().size() > 0) {
            ArrayList<Map<String, Float>> vertexGroups = new ArrayList<Map<String, Float>>(face.getIndexes().size());
            for (Integer index : face.getIndexes()) {
                vertexGroups.add(face.getTemporalMesh().getVertexGroups().get(index));
            }
            return this.interpolateVertexGroups(vertexGroups);
        }
        return new HashMap<String, Float>();
    }

    private byte[] computeFaceVertexColor(Face face) {
        if (face.getVertexColors() != null) {
            return this.interpolateVertexColors((byte[][])face.getVertexColors().toArray((T[])new byte[face.getVertexColors().size()][]));
        }
        return null;
    }

    private byte[] interpolateVertexColors(byte[] ... colors) {
        TexturePixel pixel = new TexturePixel();
        TexturePixel temp = new TexturePixel();
        for (int i = 0; i < colors.length; ++i) {
            temp.fromARGB8(colors[i][3], colors[i][0], colors[i][1], colors[i][2]);
            pixel.add(temp);
        }
        pixel.divide(colors.length);
        byte[] result = new byte[4];
        pixel.toRGBA8(result);
        return result;
    }

    private Edge findEdge(TemporalMesh temporalMesh, int index1, int index2) {
        for (Edge edge : temporalMesh.getEdges()) {
            if ((edge.getFirstIndex() != index1 || edge.getSecondIndex() != index2) && (edge.getFirstIndex() != index2 || edge.getSecondIndex() != index1)) continue;
            return edge;
        }
        return null;
    }

    private static class CreasePoint {
        private Vector3f target = new Vector3f();
        private float weight;
        private int index;

        public CreasePoint(int index, boolean borderIndex, List<Edge> creaseEdges, TemporalMesh temporalMesh) {
            this.index = index;
            if (creaseEdges == null || creaseEdges.size() <= 1) {
                this.target = null;
            } else {
                int creasedEdgesCount = 0;
                for (Edge edge : creaseEdges) {
                    if (!(edge.getCrease() > 0.0f)) continue;
                    ++creasedEdgesCount;
                    this.weight += edge.getCrease();
                    this.target.addLocal(temporalMesh.getVertices().get(edge.getOtherIndex(index)));
                }
                if (creasedEdgesCount <= 1) {
                    this.target = null;
                } else if (creasedEdgesCount == 2) {
                    if (borderIndex) {
                        this.target.set(temporalMesh.getVertices().get(index));
                    } else {
                        this.target.addLocal(temporalMesh.getVertices().get(index)).divideLocal((float)(creasedEdgesCount + 1));
                    }
                } else {
                    this.target.set(temporalMesh.getVertices().get(index));
                }
                if (creasedEdgesCount > 0) {
                    this.weight /= (float)creasedEdgesCount;
                }
            }
        }

        public Vector3f getTarget() {
            return this.target;
        }

        public float getWeight() {
            return this.weight;
        }

        public String toString() {
            return "CreasePoint [index = " + this.index + ", target=" + this.target + ", weight=" + this.weight + "]";
        }
    }

    private static class UvCoordsSubdivideTemporalMesh
    extends TemporalMesh {
        private static final Vector3f NORMAL = new Vector3f(0.0f, 0.0f, 1.0f);

        public UvCoordsSubdivideTemporalMesh(BlenderContext blenderContext) throws BlenderFileException {
            super(null, blenderContext, false);
        }

        public void addFace(List<Vector2f> uvs) {
            Integer[] indexes = new Integer[uvs.size()];
            int i = 0;
            for (Vector2f uv : uvs) {
                Vector3f v = new Vector3f(uv.x, uv.y, 0.0f);
                int index = this.vertices.indexOf(v);
                if (index >= 0) {
                    indexes[i++] = index;
                    continue;
                }
                indexes[i++] = this.vertices.size();
                this.vertices.add(v);
                this.normals.add(NORMAL);
            }
            this.faces.add(new Face(indexes, false, 0, null, null, this));
            for (i = 1; i < indexes.length; ++i) {
                this.edges.add(new Edge(indexes[i - 1], indexes[i], 0.0f, true, this));
            }
            this.edges.add(new Edge(indexes[indexes.length - 1], indexes[0], 0.0f, true, this));
        }

        public List<Vector2f> faceToUVs(int faceIndex) {
            Face face = (Face)this.faces.get(faceIndex);
            ArrayList<Vector2f> result = new ArrayList<Vector2f>(face.getIndexes().size());
            for (Integer index : face.getIndexes()) {
                Vector3f v = (Vector3f)this.vertices.get(index);
                result.add(new Vector2f(v.x, v.y));
            }
            return result;
        }
    }
}

