/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.scene.plugins.blender.math.Matrix;
import com.jme3.scene.plugins.blender.math.Vector3d;
import java.io.IOException;
import java.io.Serializable;

public final class DQuaternion
implements Savable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5009180713885017539L;
    public static final DQuaternion IDENTITY = new DQuaternion();
    public static final DQuaternion DIRECTION_Z = new DQuaternion();
    public static final DQuaternion ZERO = new DQuaternion(0.0, 0.0, 0.0, 0.0);
    protected double x;
    protected double y;
    protected double z;
    protected double w = 1.0;

    public DQuaternion() {
    }

    public DQuaternion(double x, double y, double z, double w) {
        this.set(x, y, z, w);
    }

    public DQuaternion(Quaternion q) {
        this(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    public Quaternion toQuaternion() {
        return new Quaternion((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public DQuaternion set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public DQuaternion set(DQuaternion q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
        return this;
    }

    public void loadIdentity() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.w = 1.0;
    }

    public double norm() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public DQuaternion fromRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double t;
        double lengthSquared = m00 * m00 + m10 * m10 + m20 * m20;
        if (lengthSquared != 1.0 && lengthSquared != 0.0) {
            lengthSquared = 1.0 / Math.sqrt(lengthSquared);
            m00 *= lengthSquared;
            m10 *= lengthSquared;
            m20 *= lengthSquared;
        }
        if ((lengthSquared = m01 * m01 + m11 * m11 + m21 * m21) != 1.0 && lengthSquared != 0.0) {
            lengthSquared = 1.0 / Math.sqrt(lengthSquared);
            m01 *= lengthSquared;
            m11 *= lengthSquared;
            m21 *= lengthSquared;
        }
        if ((lengthSquared = m02 * m02 + m12 * m12 + m22 * m22) != 1.0 && lengthSquared != 0.0) {
            lengthSquared = 1.0 / Math.sqrt(lengthSquared);
            m02 *= lengthSquared;
            m12 *= lengthSquared;
            m22 *= lengthSquared;
        }
        if ((t = m00 + m11 + m22) >= 0.0) {
            double s = Math.sqrt(t + 1.0);
            this.w = 0.5 * s;
            s = 0.5 / s;
            this.x = (m21 - m12) * s;
            this.y = (m02 - m20) * s;
            this.z = (m10 - m01) * s;
        } else if (m00 > m11 && m00 > m22) {
            double s = Math.sqrt(1.0 + m00 - m11 - m22);
            this.x = s * 0.5;
            s = 0.5 / s;
            this.y = (m10 + m01) * s;
            this.z = (m02 + m20) * s;
            this.w = (m21 - m12) * s;
        } else if (m11 > m22) {
            double s = Math.sqrt(1.0 + m11 - m00 - m22);
            this.y = s * 0.5;
            s = 0.5 / s;
            this.x = (m10 + m01) * s;
            this.z = (m21 + m12) * s;
            this.w = (m02 - m20) * s;
        } else {
            double s = Math.sqrt(1.0 + m22 - m00 - m11);
            this.z = s * 0.5;
            s = 0.5 / s;
            this.x = (m02 + m20) * s;
            this.y = (m21 + m12) * s;
            this.w = (m10 - m01) * s;
        }
        return this;
    }

    public Matrix toRotationMatrix(Matrix result) {
        Vector3d originalScale = new Vector3d();
        result.toScaleVector(originalScale);
        result.setScale(1.0, 1.0, 1.0);
        double norm = this.norm();
        double s = norm == 1.0 ? 2.0 : (norm > 0.0 ? 2.0 / norm : 0.0);
        double xs = this.x * s;
        double ys = this.y * s;
        double zs = this.z * s;
        double xx = this.x * xs;
        double xy = this.x * ys;
        double xz = this.x * zs;
        double xw = this.w * xs;
        double yy = this.y * ys;
        double yz = this.y * zs;
        double yw = this.w * ys;
        double zz = this.z * zs;
        double zw = this.w * zs;
        result.set(0, 0, 1.0 - (yy + zz));
        result.set(0, 1, xy - zw);
        result.set(0, 2, xz + yw);
        result.set(1, 0, xy + zw);
        result.set(1, 1, 1.0 - (xx + zz));
        result.set(1, 2, yz - xw);
        result.set(2, 0, xz - yw);
        result.set(2, 1, yz + xw);
        result.set(2, 2, 1.0 - (xx + yy));
        result.setScale(originalScale);
        return result;
    }

    public DQuaternion fromAngleAxis(double angle, Vector3d axis) {
        Vector3d normAxis = axis.normalize();
        this.fromAngleNormalAxis(angle, normAxis);
        return this;
    }

    public DQuaternion fromAngleNormalAxis(double angle, Vector3d axis) {
        if (axis.x == 0.0 && axis.y == 0.0 && axis.z == 0.0) {
            this.loadIdentity();
        } else {
            double halfAngle = 0.5 * angle;
            double sin = Math.sin(halfAngle);
            this.w = Math.cos(halfAngle);
            this.x = sin * axis.x;
            this.y = sin * axis.y;
            this.z = sin * axis.z;
        }
        return this;
    }

    public DQuaternion add(DQuaternion q) {
        return new DQuaternion(this.x + q.x, this.y + q.y, this.z + q.z, this.w + q.w);
    }

    public DQuaternion addLocal(DQuaternion q) {
        this.x += q.x;
        this.y += q.y;
        this.z += q.z;
        this.w += q.w;
        return this;
    }

    public DQuaternion subtract(DQuaternion q) {
        return new DQuaternion(this.x - q.x, this.y - q.y, this.z - q.z, this.w - q.w);
    }

    public DQuaternion subtractLocal(DQuaternion q) {
        this.x -= q.x;
        this.y -= q.y;
        this.z -= q.z;
        this.w -= q.w;
        return this;
    }

    public DQuaternion mult(DQuaternion q) {
        return this.mult(q, null);
    }

    public DQuaternion mult(DQuaternion q, DQuaternion res) {
        if (res == null) {
            res = new DQuaternion();
        }
        double qw = q.w;
        double qx = q.x;
        double qy = q.y;
        double qz = q.z;
        res.x = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        res.y = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        res.z = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        res.w = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        return res;
    }

    public Vector3d mult(Vector3d v) {
        return this.mult(v, null);
    }

    public DQuaternion multLocal(DQuaternion q) {
        double x1 = this.x * q.w + this.y * q.z - this.z * q.y + this.w * q.x;
        double y1 = -this.x * q.z + this.y * q.w + this.z * q.x + this.w * q.y;
        double z1 = this.x * q.y - this.y * q.x + this.z * q.w + this.w * q.z;
        this.w = -this.x * q.x - this.y * q.y - this.z * q.z + this.w * q.w;
        this.x = x1;
        this.y = y1;
        this.z = z1;
        return this;
    }

    public Vector3d mult(Vector3d v, Vector3d store) {
        if (store == null) {
            store = new Vector3d();
        }
        if (v.x == 0.0 && v.y == 0.0 && v.z == 0.0) {
            store.set(0.0, 0.0, 0.0);
        } else {
            double vx = v.x;
            double vy = v.y;
            double vz = v.z;
            store.x = this.w * this.w * vx + 2.0 * this.y * this.w * vz - 2.0 * this.z * this.w * vy + this.x * this.x * vx + 2.0 * this.y * this.x * vy + 2.0 * this.z * this.x * vz - this.z * this.z * vx - this.y * this.y * vx;
            store.y = 2.0 * this.x * this.y * vx + this.y * this.y * vy + 2.0 * this.z * this.y * vz + 2.0 * this.w * this.z * vx - this.z * this.z * vy + this.w * this.w * vy - 2.0 * this.x * this.w * vz - this.x * this.x * vy;
            store.z = 2.0 * this.x * this.z * vx + 2.0 * this.y * this.z * vy + this.z * this.z * vz - 2.0 * this.w * this.y * vx - this.y * this.y * vz + 2.0 * this.w * this.x * vy - this.x * this.x * vz + this.w * this.w * vz;
        }
        return store;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof DQuaternion)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        DQuaternion comp = (DQuaternion)o;
        if (Double.compare(this.x, comp.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, comp.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, comp.z) != 0) {
            return false;
        }
        return Double.compare(this.w, comp.w) == 0;
    }

    public int hashCode() {
        long hash = 37L;
        hash = 37L * hash + Double.doubleToLongBits(this.x);
        hash = 37L * hash + Double.doubleToLongBits(this.y);
        hash = 37L * hash + Double.doubleToLongBits(this.z);
        hash = 37L * hash + Double.doubleToLongBits(this.w);
        return (int)hash;
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule cap = e.getCapsule((Savable)this);
        cap.write(this.x, "x", 0.0);
        cap.write(this.y, "y", 0.0);
        cap.write(this.z, "z", 0.0);
        cap.write(this.w, "w", 1.0);
    }

    public void read(JmeImporter e) throws IOException {
        InputCapsule cap = e.getCapsule((Savable)this);
        this.x = cap.readFloat("x", 0.0f);
        this.y = cap.readFloat("y", 0.0f);
        this.z = cap.readFloat("z", 0.0f);
        this.w = cap.readFloat("w", 1.0f);
    }

    public DQuaternion clone() {
        try {
            return (DQuaternion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

