/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.HashMap;
import java.util.Map;

public class DnaBlockData {
    private static final int SDNA_ID = 1396985409;
    private static final int NAME_ID = 1312902469;
    private static final int TYPE_ID = 1415139397;
    private static final int TLEN_ID = 1414284622;
    private static final int STRC_ID = 1398035011;
    private final Structure[] structures;
    private final Map<String, Structure> structuresMap;

    public DnaBlockData(BlenderInputStream inputStream, BlenderContext blenderContext) throws BlenderFileException {
        int i;
        int identifier = inputStream.readByte() << 24 | inputStream.readByte() << 16 | inputStream.readByte() << 8 | inputStream.readByte();
        if (identifier != 1396985409) {
            throw new BlenderFileException("Invalid identifier! '" + this.toString(1396985409) + "' expected and found: " + this.toString(identifier));
        }
        identifier = inputStream.readByte() << 24 | inputStream.readByte() << 16 | inputStream.readByte() << 8 | inputStream.readByte();
        if (identifier != 1312902469) {
            throw new BlenderFileException("Invalid identifier! '" + this.toString(1312902469) + "' expected and found: " + this.toString(identifier));
        }
        int amount = inputStream.readInt();
        if (amount <= 0) {
            throw new BlenderFileException("The names amount number should be positive!");
        }
        String[] names = new String[amount];
        for (int i2 = 0; i2 < amount; ++i2) {
            names[i2] = inputStream.readString();
        }
        inputStream.alignPosition(4);
        identifier = inputStream.readByte() << 24 | inputStream.readByte() << 16 | inputStream.readByte() << 8 | inputStream.readByte();
        if (identifier != 1415139397) {
            throw new BlenderFileException("Invalid identifier! '" + this.toString(1415139397) + "' expected and found: " + this.toString(identifier));
        }
        amount = inputStream.readInt();
        if (amount <= 0) {
            throw new BlenderFileException("The types amount number should be positive!");
        }
        String[] types = new String[amount];
        for (int i3 = 0; i3 < amount; ++i3) {
            types[i3] = inputStream.readString();
        }
        inputStream.alignPosition(4);
        identifier = inputStream.readByte() << 24 | inputStream.readByte() << 16 | inputStream.readByte() << 8 | inputStream.readByte();
        if (identifier != 1414284622) {
            throw new BlenderFileException("Invalid identifier! '" + this.toString(1414284622) + "' expected and found: " + this.toString(identifier));
        }
        int[] lengths = new int[amount];
        for (i = 0; i < amount; ++i) {
            lengths[i] = inputStream.readShort();
        }
        inputStream.alignPosition(4);
        identifier = inputStream.readByte() << 24 | inputStream.readByte() << 16 | inputStream.readByte() << 8 | inputStream.readByte();
        if (identifier != 1398035011) {
            throw new BlenderFileException("Invalid identifier! '" + this.toString(1398035011) + "' expected and found: " + this.toString(identifier));
        }
        amount = inputStream.readInt();
        if (amount <= 0) {
            throw new BlenderFileException("The structures amount number should be positive!");
        }
        this.structures = new Structure[amount];
        this.structuresMap = new HashMap<String, Structure>(amount);
        for (i = 0; i < amount; ++i) {
            this.structures[i] = new Structure(inputStream, names, types, blenderContext);
            if (this.structuresMap.containsKey(this.structures[i].getType())) {
                throw new BlenderFileException("Blend file seems to be corrupted! The type " + this.structures[i].getType() + " is defined twice!");
            }
            this.structuresMap.put(this.structures[i].getType(), this.structures[i]);
        }
    }

    public int getStructuresCount() {
        return this.structures.length;
    }

    public Structure getStructure(int index) {
        try {
            return (Structure)this.structures[index].clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Structure should be clonable!!!", e);
        }
    }

    public Structure getStructure(String name) {
        try {
            return (Structure)this.structuresMap.get(name).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean hasStructure(String name) {
        return this.structuresMap.containsKey(name);
    }

    private String toString(int code) {
        char c1 = (char)((code & 0xFF000000) >> 24);
        char c2 = (char)((code & 0xFF0000) >> 16);
        char c3 = (char)((code & 0xFF00) >> 8);
        char c4 = (char)(code & 0xFF);
        return String.valueOf(c1) + c2 + c3 + c4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("=============== ").append(1396985409).append('\n');
        for (Structure structure : this.structures) {
            stringBuilder.append(structure.toString()).append('\n');
        }
        return stringBuilder.append("===============").toString();
    }
}

