/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.curves;

import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.curves.CurvesTemporalMesh;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Logger;

public class CurvesHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(CurvesHelper.class.getName());
    protected int minimumBasisUFunctionDegree = 4;
    protected int minimumBasisVFunctionDegree = 4;

    public CurvesHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public CurvesTemporalMesh toCurve(Structure curveStructure, BlenderContext blenderContext) throws BlenderFileException {
        CurvesTemporalMesh result = new CurvesTemporalMesh(curveStructure, blenderContext);
        if (blenderContext.getBlenderKey().isLoadObjectProperties()) {
            LOGGER.fine("Reading custom properties.");
            result.setProperties(this.loadProperties(curveStructure, blenderContext));
        }
        return result;
    }

    protected Vector3f[] transformBevel(Vector3f[] bevel, Vector3f prevPos, Vector3f currPos, Vector3f nextPos) {
        bevel = (Vector3f[])bevel.clone();
        Vector3f directionVector = prevPos != null ? currPos.subtract(prevPos) : nextPos.subtract(currPos);
        directionVector.normalizeLocal();
        Vector3f planeNormal = null;
        if (prevPos != null) {
            planeNormal = currPos.subtract(prevPos).normalizeLocal();
            if (nextPos != null) {
                planeNormal.addLocal(nextPos.subtract(currPos).normalizeLocal()).normalizeLocal();
            }
        } else {
            planeNormal = nextPos.subtract(currPos).normalizeLocal();
        }
        float D = -planeNormal.dot(currPos);
        float temp = planeNormal.dot(directionVector);
        for (int i = 0; i < bevel.length; ++i) {
            float t = -(planeNormal.dot(bevel[i]) + D) / temp;
            bevel[i] = this.fixUpAxis ? new Vector3f(bevel[i].x + directionVector.x * t, bevel[i].y + directionVector.y * t, bevel[i].z + directionVector.z * t) : new Vector3f(bevel[i].x + directionVector.x * t, -bevel[i].z + directionVector.z * t, bevel[i].y + directionVector.y * t);
        }
        return bevel;
    }

    protected Vector3f[] transformToFirstLineOfBevelPoints(Vector3f[] startingLinePoints, Vector3f firstCurvePoint, Vector3f secondCurvePoint) {
        Vector3f planeNormal = secondCurvePoint.subtract(firstCurvePoint).normalizeLocal();
        float angle = FastMath.acos((float)planeNormal.dot(Vector3f.UNIT_X));
        Vector3f rotationVector = Vector3f.UNIT_X.cross(planeNormal).normalizeLocal();
        Matrix4f m = new Matrix4f();
        m.setRotationQuaternion(new Quaternion().fromAngleAxis(angle, rotationVector));
        m.setTranslation(firstCurvePoint);
        Vector3f temp = new Vector3f();
        Vector3f[] verts = new Vector3f[startingLinePoints.length];
        for (int i = 0; i < verts.length; ++i) {
            verts[i] = m.mult(startingLinePoints[i], temp).clone();
        }
        return verts;
    }
}

