/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.curves;

import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.List;

public class BezierCurve {
    private static final int IPO_CONSTANT = 0;
    private static final int IPO_LINEAR = 1;
    private static final int IPO_BEZIER = 2;
    public static final int X_VALUE = 0;
    public static final int Y_VALUE = 1;
    public static final int Z_VALUE = 2;
    private int type;
    private int dimension;
    private double[][][] bezierPoints;
    private double[] radiuses;
    private int[] interpolations;

    public BezierCurve(int type, List<Structure> bezTriples, int dimension) {
        this(type, bezTriples, dimension, false);
    }

    public BezierCurve(int type, List<Structure> bezTriples, int dimension, boolean fixUpAxis) {
        if (dimension != 2 && dimension != 3) {
            throw new IllegalArgumentException("The dimension of the curve should be 2 or 3!");
        }
        this.type = type;
        this.dimension = dimension;
        this.bezierPoints = new double[bezTriples.size()][3][dimension];
        this.radiuses = new double[bezTriples.size()];
        this.interpolations = new int[bezTriples.size()];
        int i = 0;
        for (Structure bezTriple : bezTriples) {
            DynamicArray vec = (DynamicArray)bezTriple.getFieldValue("vec");
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < dimension; ++k) {
                    this.bezierPoints[i][j][k] = ((Number)vec.get(j, k)).doubleValue();
                }
                if (!fixUpAxis || dimension != 3) continue;
                double temp = this.bezierPoints[i][j][2];
                this.bezierPoints[i][j][2] = -this.bezierPoints[i][j][1];
                this.bezierPoints[i][j][1] = temp;
            }
            this.radiuses[i] = ((Number)bezTriple.getFieldValue("radius")).floatValue();
            this.interpolations[i++] = ((Number)bezTriple.getFieldValue("ipo", 2)).intValue();
        }
    }

    public double evaluate(int frame, int valuePart) {
        for (int i = 0; i < this.bezierPoints.length - 1; ++i) {
            if (!((double)frame >= this.bezierPoints[i][1][0]) || !((double)frame <= this.bezierPoints[i + 1][1][0])) continue;
            double t = ((double)frame - this.bezierPoints[i][1][0]) / (this.bezierPoints[i + 1][1][0] - this.bezierPoints[i][1][0]);
            switch (this.interpolations[i]) {
                case 2: {
                    double oneMinusT = 1.0 - t;
                    double oneMinusT2 = oneMinusT * oneMinusT;
                    double t2 = t * t;
                    return this.bezierPoints[i][1][valuePart] * oneMinusT2 * oneMinusT + 3.0 * this.bezierPoints[i][2][valuePart] * t * oneMinusT2 + 3.0 * this.bezierPoints[i + 1][0][valuePart] * t2 * oneMinusT + this.bezierPoints[i + 1][1][valuePart] * t2 * t;
                }
                case 1: {
                    return (1.0 - t) * this.bezierPoints[i][1][valuePart] + t * this.bezierPoints[i + 1][1][valuePart];
                }
                case 0: {
                    return this.bezierPoints[i][1][valuePart];
                }
            }
            throw new IllegalStateException("Unknown interpolation type for curve: " + this.interpolations[i]);
        }
        if ((double)frame < this.bezierPoints[0][1][0]) {
            return this.bezierPoints[0][1][1];
        }
        return this.bezierPoints[this.bezierPoints.length - 1][1][1];
    }

    public int getLastFrame() {
        return (int)this.bezierPoints[this.bezierPoints.length - 1][1][0];
    }

    public int getType() {
        return this.type;
    }

    public double getRadius(int bezierTripleIndex) {
        return this.radiuses[bezierTripleIndex];
    }

    public List<Vector3f> getControlPoints() {
        ArrayList<Vector3f> controlPoints = new ArrayList<Vector3f>(this.bezierPoints.length * 3);
        for (int i = 0; i < this.bezierPoints.length; ++i) {
            controlPoints.add(new Vector3f((float)this.bezierPoints[i][0][0], (float)this.bezierPoints[i][0][1], (float)this.bezierPoints[i][0][2]));
            controlPoints.add(new Vector3f((float)this.bezierPoints[i][1][0], (float)this.bezierPoints[i][1][1], (float)this.bezierPoints[i][1][2]));
            controlPoints.add(new Vector3f((float)this.bezierPoints[i][2][0], (float)this.bezierPoints[i][2][1], (float)this.bezierPoints[i][2][2]));
        }
        return controlPoints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Bezier curve: ").append(this.type).append('\n');
        for (int i = 0; i < this.bezierPoints.length; ++i) {
            sb.append(this.toStringBezTriple(i)).append('\n');
        }
        return sb.toString();
    }

    private String toStringBezTriple(int tripleIndex) {
        if (this.dimension == 2) {
            return "[(" + this.bezierPoints[tripleIndex][0][0] + ", " + this.bezierPoints[tripleIndex][0][1] + ") (" + this.bezierPoints[tripleIndex][1][0] + ", " + this.bezierPoints[tripleIndex][1][1] + ") (" + this.bezierPoints[tripleIndex][2][0] + ", " + this.bezierPoints[tripleIndex][2][1] + ")]";
        }
        return "[(" + this.bezierPoints[tripleIndex][0][0] + ", " + this.bezierPoints[tripleIndex][0][1] + ", " + this.bezierPoints[tripleIndex][0][2] + ") (" + this.bezierPoints[tripleIndex][1][0] + ", " + this.bezierPoints[tripleIndex][1][1] + ", " + this.bezierPoints[tripleIndex][1][2] + ") (" + this.bezierPoints[tripleIndex][2][0] + ", " + this.bezierPoints[tripleIndex][2][1] + ", " + this.bezierPoints[tripleIndex][2][2] + ")]";
    }
}

