/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintDefinitionSizeLike
extends ConstraintDefinition {
    private static final int SIZELIKE_X = 1;
    private static final int SIZELIKE_Y = 2;
    private static final int SIZELIKE_Z = 4;
    private static final int LOCLIKE_OFFSET = 128;

    public ConstraintDefinitionSizeLike(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            int y = this.flag & 2;
            int z = this.flag & 4;
            this.flag &= 0x81;
            this.flag |= y << 1;
            this.flag |= z >> 1;
            this.trackToBeChanged = (this.flag & 7) != 0;
        }
    }

    @Override
    public void bake(ConstraintHelper.Space ownerSpace, ConstraintHelper.Space targetSpace, Transform targetTransform, float influence) {
        if (influence == 0.0f || targetTransform == null || !this.trackToBeChanged) {
            return;
        }
        Transform ownerTransform = this.getOwnerTransform(ownerSpace);
        Vector3f ownerScale = ownerTransform.getScale();
        Vector3f targetScale = targetTransform.getScale();
        Vector3f offset = Vector3f.ZERO;
        if ((this.flag & 0x80) != 0) {
            offset = ownerScale.clone();
        }
        if ((this.flag & 1) != 0) {
            ownerScale.x = targetScale.x * influence + (1.0f - influence) * ownerScale.x;
        }
        if ((this.flag & 2) != 0) {
            ownerScale.y = targetScale.y * influence + (1.0f - influence) * ownerScale.y;
        }
        if ((this.flag & 4) != 0) {
            ownerScale.z = targetScale.z * influence + (1.0f - influence) * ownerScale.z;
        }
        ownerScale.addLocal(offset);
        this.applyOwnerTransform(ownerTransform, ownerSpace);
    }

    @Override
    public String getConstraintTypeName() {
        return "Copy scale";
    }

    @Override
    public boolean isTargetRequired() {
        return true;
    }
}

