/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintDefinitionRotLike
extends ConstraintDefinition {
    private static final int ROTLIKE_X = 1;
    private static final int ROTLIKE_Y = 2;
    private static final int ROTLIKE_Z = 4;
    private static final int ROTLIKE_X_INVERT = 16;
    private static final int ROTLIKE_Y_INVERT = 32;
    private static final int ROTLIKE_Z_INVERT = 64;
    private static final int ROTLIKE_OFFSET = 128;
    private transient float[] ownerAngles = new float[3];
    private transient float[] targetAngles = new float[3];

    public ConstraintDefinitionRotLike(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        this.trackToBeChanged = (this.flag & 7) != 0;
    }

    @Override
    public void bake(ConstraintHelper.Space ownerSpace, ConstraintHelper.Space targetSpace, Transform targetTransform, float influence) {
        if (influence == 0.0f || targetTransform == null || !this.trackToBeChanged) {
            return;
        }
        Transform ownerTransform = this.getOwnerTransform(ownerSpace);
        Quaternion ownerRotation = ownerTransform.getRotation();
        this.ownerAngles = ownerRotation.toAngles(this.ownerAngles);
        this.targetAngles = targetTransform.getRotation().toAngles(this.targetAngles);
        Quaternion startRotation = ownerRotation.clone();
        Quaternion offset = Quaternion.IDENTITY;
        if ((this.flag & 0x80) != 0) {
            offset = startRotation;
        }
        if ((this.flag & 1) != 0) {
            this.ownerAngles[0] = this.targetAngles[0];
            if ((this.flag & 0x10) != 0) {
                this.ownerAngles[0] = -this.ownerAngles[0];
            }
        }
        if ((this.flag & 2) != 0) {
            this.ownerAngles[1] = this.targetAngles[1];
            if ((this.flag & 0x20) != 0) {
                this.ownerAngles[1] = -this.ownerAngles[1];
            }
        }
        if ((this.flag & 4) != 0) {
            this.ownerAngles[2] = this.targetAngles[2];
            if ((this.flag & 0x40) != 0) {
                this.ownerAngles[2] = -this.ownerAngles[2];
            }
        }
        ownerRotation.fromAngles(this.ownerAngles).multLocal(offset);
        if (influence < 1.0f) {
            // empty if block
        }
        this.applyOwnerTransform(ownerTransform, ownerSpace);
    }

    @Override
    public String getConstraintTypeName() {
        return "Copy rotation";
    }

    @Override
    public boolean isTargetRequired() {
        return true;
    }
}

