/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinitionFactory;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Constraint {
    private static final Logger LOGGER = Logger.getLogger(Constraint.class.getName());
    protected final String name;
    protected boolean baked;
    protected ConstraintHelper.Space ownerSpace;
    protected final ConstraintDefinition constraintDefinition;
    protected Long ownerOMA;
    protected Long targetOMA;
    protected ConstraintHelper.Space targetSpace;
    protected String subtargetName;
    protected final Ipo ipo;
    protected final BlenderContext blenderContext;
    protected final ConstraintHelper constraintHelper;

    public Constraint(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        this.blenderContext = blenderContext;
        this.name = constraintStructure.getFieldValue("name").toString();
        Pointer pData = (Pointer)constraintStructure.getFieldValue("data");
        if (pData.isNotNull()) {
            Structure data = pData.fetchData().get(0);
            this.constraintDefinition = ConstraintDefinitionFactory.createConstraintDefinition(data, this.name, ownerOMA, blenderContext);
            Pointer pTar = (Pointer)data.getFieldValue("tar");
            if (pTar != null && pTar.isNotNull()) {
                this.targetOMA = pTar.getOldMemoryAddress();
                this.targetSpace = ConstraintHelper.Space.valueOf(((Number)constraintStructure.getFieldValue("tarspace")).byteValue());
                Object subtargetValue = data.getFieldValue("subtarget");
                if (subtargetValue != null) {
                    this.subtargetName = subtargetValue.toString();
                }
            }
        } else {
            this.constraintDefinition = ConstraintDefinitionFactory.createConstraintDefinition(null, this.name, null, blenderContext);
        }
        this.ownerSpace = ConstraintHelper.Space.valueOf(((Number)constraintStructure.getFieldValue("ownspace")).byteValue());
        this.ipo = influenceIpo;
        this.ownerOMA = ownerOMA;
        this.constraintHelper = (ConstraintHelper)blenderContext.getHelper(ConstraintHelper.class);
        LOGGER.log(Level.INFO, "Created constraint: {0} with definition: {1}", new Object[]{this.name, this.constraintDefinition});
    }

    public boolean isImplemented() {
        return this.constraintDefinition == null ? true : this.constraintDefinition.isImplemented();
    }

    public String getConstraintTypeName() {
        return this.constraintDefinition.getConstraintTypeName();
    }

    public Set<Long> getAlteredOmas() {
        return this.constraintDefinition.getAlteredOmas();
    }

    public abstract boolean validate();

    public abstract Long getTargetOMA();

    public void apply(int frame) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Applying constraint: {0} for frame {1}", new Object[]{this.name, frame});
        }
        Transform targetTransform = this.targetOMA != null ? this.constraintHelper.getTransform(this.targetOMA, this.subtargetName, this.targetSpace) : null;
        this.constraintDefinition.bake(this.ownerSpace, this.targetSpace, targetTransform, (float)this.ipo.calculateValue(frame));
    }

    public boolean isTrackToBeChanged() {
        return this.constraintDefinition == null ? false : this.constraintDefinition.isTrackToBeChanged();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ownerOMA == null ? 0 : this.ownerOMA.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constraint other = (Constraint)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.ownerOMA == null ? other.ownerOMA != null : !this.ownerOMA.equals(other.ownerOMA));
    }

    public String toString() {
        return "Constraint(name = " + this.name + ", def = " + this.constraintDefinition + ")";
    }
}

