/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

class BoneConstraint
extends Constraint {
    private static final Logger LOGGER = Logger.getLogger(BoneConstraint.class.getName());

    public BoneConstraint(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
    }

    @Override
    public boolean validate() {
        if (this.targetOMA != null) {
            Spatial nodeTarget = (Spatial)this.blenderContext.getLoadedFeature(this.targetOMA, BlenderContext.LoadedDataType.FEATURE);
            if (nodeTarget == null) {
                LOGGER.log(Level.WARNING, "Cannot find target for constraint: {0}.", this.name);
                return false;
            }
            if (this.blenderContext.getMarkerValue("armature-node", nodeTarget) != null) {
                if (this.subtargetName.trim().isEmpty()) {
                    LOGGER.log(Level.WARNING, "No bone target specified for constraint: {0}.", this.name);
                    return false;
                }
                BoneContext boneContext = this.blenderContext.getBoneContext(this.ownerOMA);
                if (this.targetOMA.longValue() != boneContext.getArmatureObjectOMA().longValue()) {
                    LOGGER.log(Level.WARNING, "Bone constraint {0} must target bone in the its own skeleton! Targeting bone in another skeleton is not supported!", this.name);
                    return false;
                }
            }
        }
        return this.constraintDefinition == null ? true : this.constraintDefinition.isTargetRequired();
    }

    @Override
    public void apply(int frame) {
        super.apply(frame);
        this.blenderContext.getBoneContext(this.ownerOMA).getBone().updateModelTransforms();
    }

    @Override
    public Long getTargetOMA() {
        Spatial nodeTarget;
        if (this.targetOMA != null && this.subtargetName != null && !this.subtargetName.trim().isEmpty() && (nodeTarget = (Spatial)this.blenderContext.getLoadedFeature(this.targetOMA, BlenderContext.LoadedDataType.FEATURE)) != null) {
            if (this.blenderContext.getMarkerValue("armature-node", nodeTarget) != null) {
                BoneContext boneContext = this.blenderContext.getBoneByName(this.targetOMA, this.subtargetName);
                return boneContext != null ? boneContext.getBoneOma() : 0L;
            }
            return this.targetOMA;
        }
        return 0L;
    }
}

