/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.asset.BlenderKey;
import com.jme3.scene.Node;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BlenderAction;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnimationHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(AnimationHelper.class.getName());

    public AnimationHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public void loadAnimations() throws BlenderFileException {
        LOGGER.info("Loading animations that will be later applied to scene features.");
        List<FileBlockHeader> actionHeaders = this.blenderContext.getFileBlocks(FileBlockHeader.BlockCode.BLOCK_AC00);
        if (actionHeaders != null) {
            for (FileBlockHeader header : actionHeaders) {
                Structure actionStructure = header.getStructure(this.blenderContext);
                LOGGER.log(Level.INFO, "Found animation: {0}.", actionStructure.getName());
                this.blenderContext.addAction(this.getTracks(actionStructure, this.blenderContext));
            }
        }
    }

    public void applyAnimations(Node node, BlenderKey.AnimationMatchMethod animationMatchMethod) {
        List<BlenderAction> actions = this.getActions(node, animationMatchMethod);
        if (actions.size() > 0) {
            ArrayList<Animation> animations = new ArrayList<Animation>();
            for (BlenderAction action : actions) {
                SpatialTrack[] tracks = action.toTracks(node, this.blenderContext);
                if (tracks == null || tracks.length <= 0) continue;
                Animation spatialAnimation = new Animation(action.getName(), action.getAnimationTime());
                spatialAnimation.setTracks((Track[])tracks);
                animations.add(spatialAnimation);
                this.blenderContext.addAnimation((Long)node.getUserData("oma"), spatialAnimation);
            }
            if (animations.size() > 0) {
                AnimControl control = new AnimControl();
                HashMap<String, Animation> anims = new HashMap<String, Animation>(animations.size());
                for (int i = 0; i < animations.size(); ++i) {
                    Animation animation = (Animation)animations.get(i);
                    anims.put(animation.getName(), animation);
                }
                control.setAnimations(anims);
                node.addControl((Control)control);
            }
        }
    }

    public void applyAnimations(Node node, Skeleton skeleton, BlenderKey.AnimationMatchMethod animationMatchMethod) {
        node.addControl((Control)new SkeletonControl(skeleton));
        this.blenderContext.setNodeForSkeleton(skeleton, node);
        List<BlenderAction> actions = this.getActions(skeleton, animationMatchMethod);
        if (actions.size() > 0) {
            ArrayList<Animation> animations = new ArrayList<Animation>();
            for (BlenderAction action : actions) {
                BoneTrack[] tracks = action.toTracks(skeleton, this.blenderContext);
                if (tracks == null || tracks.length <= 0) continue;
                Animation boneAnimation = new Animation(action.getName(), action.getAnimationTime());
                boneAnimation.setTracks((Track[])tracks);
                animations.add(boneAnimation);
                Long animatedNodeOMA = ((Number)this.blenderContext.getMarkerValue("oma", node)).longValue();
                this.blenderContext.addAnimation(animatedNodeOMA, boneAnimation);
            }
            if (animations.size() > 0) {
                AnimControl control = new AnimControl(skeleton);
                HashMap<String, Animation> anims = new HashMap<String, Animation>(animations.size());
                for (int i = 0; i < animations.size(); ++i) {
                    Animation animation = (Animation)animations.get(i);
                    anims.put(animation.getName(), animation);
                }
                control.setAnimations(anims);
                node.addControl((Control)control);
                SkeletonControl skeletonControl = (SkeletonControl)node.getControl(SkeletonControl.class);
                if (skeletonControl != null) {
                    node.removeControl(SkeletonControl.class);
                    node.addControl((Control)skeletonControl);
                }
            }
        }
    }

    public Ipo fromIpoStructure(Structure ipoStructure, BlenderContext blenderContext) throws BlenderFileException {
        Structure curvebase = (Structure)ipoStructure.getFieldValue("curve");
        Ipo result = null;
        List<Structure> curves = curvebase.evaluateListBase();
        if (curves.size() > 0) {
            BezierCurve[] bezierCurves = new BezierCurve[curves.size()];
            int frame = 0;
            for (Structure curve : curves) {
                Pointer pBezTriple = (Pointer)curve.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData();
                int type = ((Number)curve.getFieldValue("adrcode")).intValue();
                bezierCurves[frame++] = new BezierCurve(type, bezTriples, 2);
            }
            curves.clear();
            result = new Ipo(bezierCurves, this.fixUpAxis, blenderContext.getBlenderVersion());
            Long ipoOma = ipoStructure.getOldMemoryAddress();
            blenderContext.addLoadedFeatures(ipoOma, BlenderContext.LoadedDataType.STRUCTURE, ipoStructure);
            blenderContext.addLoadedFeatures(ipoOma, BlenderContext.LoadedDataType.FEATURE, result);
        }
        return result;
    }

    public Ipo fromValue(float constValue) {
        return new Ipo.ConstIpo(constValue);
    }

    private BlenderAction getTracks(Structure actionStructure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.blenderVersion < 250) {
            return this.getTracks249(actionStructure, blenderContext);
        }
        return this.getTracks250(actionStructure, blenderContext);
    }

    private BlenderAction getTracks250(Structure actionStructure, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Getting tracks!");
        Structure groups = (Structure)actionStructure.getFieldValue("groups");
        List<Structure> actionGroups = groups.evaluateListBase();
        BlenderAction blenderAction = new BlenderAction(actionStructure.getName(), blenderContext.getBlenderKey().getFps());
        int lastFrame = 1;
        for (Structure actionGroup : actionGroups) {
            String name = actionGroup.getFieldValue("name").toString();
            List<Structure> channels = ((Structure)actionGroup.getFieldValue("channels")).evaluateListBase();
            BezierCurve[] bezierCurves = new BezierCurve[channels.size()];
            int channelCounter = 0;
            for (Structure c : channels) {
                int type = this.getCurveType(c, blenderContext);
                Pointer pBezTriple = (Pointer)c.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData();
                bezierCurves[channelCounter++] = new BezierCurve(type, bezTriples, 2);
            }
            Ipo ipo = new Ipo(bezierCurves, this.fixUpAxis, blenderContext.getBlenderVersion());
            lastFrame = Math.max(lastFrame, ipo.getLastFrame());
            blenderAction.featuresTracks.put(name, ipo);
        }
        blenderAction.stopFrame = lastFrame;
        return blenderAction;
    }

    private BlenderAction getTracks249(Structure actionStructure, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Getting tracks!");
        Structure chanbase = (Structure)actionStructure.getFieldValue("chanbase");
        List<Structure> actionChannels = chanbase.evaluateListBase();
        BlenderAction blenderAction = new BlenderAction(actionStructure.getName(), blenderContext.getBlenderKey().getFps());
        int lastFrame = 1;
        for (Structure bActionChannel : actionChannels) {
            Structure ipoStructure;
            Ipo ipo;
            String animatedFeatureName = bActionChannel.getFieldValue("name").toString();
            Pointer p = (Pointer)bActionChannel.getFieldValue("ipo");
            if (p.isNull() || (ipo = this.fromIpoStructure(ipoStructure = p.fetchData().get(0), blenderContext)) == null) continue;
            lastFrame = Math.max(lastFrame, ipo.getLastFrame());
            blenderAction.featuresTracks.put(animatedFeatureName, ipo);
        }
        blenderAction.stopFrame = lastFrame;
        return blenderAction;
    }

    public int getCurveType(Structure structure, BlenderContext blenderContext) {
        BlenderInputStream bis = blenderContext.getInputStream();
        int currentPosition = bis.getPosition();
        Pointer pRnaPath = (Pointer)structure.getFieldValue("rna_path");
        FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pRnaPath.getOldMemoryAddress());
        bis.setPosition(dataFileBlock.getBlockPosition());
        String rnaPath = bis.readString();
        bis.setPosition(currentPosition);
        int arrayIndex = ((Number)structure.getFieldValue("array_index")).intValue();
        if (rnaPath.endsWith("location")) {
            return 1 + arrayIndex;
        }
        if (rnaPath.endsWith("rotation_quaternion")) {
            return 25 + arrayIndex;
        }
        if (rnaPath.endsWith("scale")) {
            return 13 + arrayIndex;
        }
        if (rnaPath.endsWith("rotation") || rnaPath.endsWith("rotation_euler")) {
            return 7 + arrayIndex;
        }
        LOGGER.log(Level.WARNING, "Unknown curve rna path: {0}", rnaPath);
        return -1;
    }

    private List<BlenderAction> getActions(Skeleton skeleton, BlenderKey.AnimationMatchMethod animationMatchMethod) {
        ArrayList<BlenderAction> result = new ArrayList<BlenderAction>();
        HashSet<String> boneNames = new HashSet<String>();
        for (int i = 0; i < skeleton.getBoneCount(); ++i) {
            String boneName = skeleton.getBone(i).getName();
            if (boneName == null || boneName.length() <= 0) continue;
            boneNames.add(skeleton.getBone(i).getName());
        }
        HashSet<String> matchingNames = new HashSet<String>();
        for (Map.Entry<String, BlenderAction> actionEntry : this.blenderContext.getActions().entrySet()) {
            for (String boneName : boneNames) {
                if (!actionEntry.getValue().hasTrackName(boneName)) continue;
                matchingNames.add(boneName);
            }
            BlenderAction action = null;
            if (animationMatchMethod == BlenderKey.AnimationMatchMethod.AT_LEAST_ONE_NAME_MATCH && matchingNames.size() > 0) {
                action = actionEntry.getValue();
            } else if (matchingNames.size() == actionEntry.getValue().getTracksCount()) {
                action = actionEntry.getValue();
            }
            if (action != null) {
                if (animationMatchMethod != BlenderKey.AnimationMatchMethod.ALL_NAMES_MATCH) {
                    action = action.clone();
                    action.removeTracksThatAreNotInTheCollection(matchingNames);
                }
                result.add(action);
            }
            matchingNames.clear();
        }
        return result;
    }

    private List<BlenderAction> getActions(Node node, BlenderKey.AnimationMatchMethod animationMatchMethod) {
        ArrayList<BlenderAction> result = new ArrayList<BlenderAction>();
        for (Map.Entry<String, BlenderAction> actionEntry : this.blenderContext.getActions().entrySet()) {
            if (!actionEntry.getValue().hasTrackName(node.getName())) continue;
            result.add(actionEntry.getValue());
        }
        return result;
    }
}

