/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.asset.BlenderKey;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.animations.BlenderAction;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DnaBlockData;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class BlenderContext {
    private int blenderVersion;
    private BlenderKey blenderKey;
    private DnaBlockData dnaBlockData;
    private Structure sceneStructure;
    private BlenderInputStream inputStream;
    private AssetManager assetManager;
    protected List<FileBlockHeader> blocks = new ArrayList<FileBlockHeader>();
    private Map<Long, FileBlockHeader> fileBlockHeadersByOma = new HashMap<Long, FileBlockHeader>();
    private Map<FileBlockHeader.BlockCode, List<FileBlockHeader>> fileBlockHeadersByCode = new HashMap<FileBlockHeader.BlockCode, List<FileBlockHeader>>();
    private Map<Long, Map<LoadedDataType, Object>> loadedFeatures = new HashMap<Long, Map<LoadedDataType, Object>>();
    private Map<String, Map<String, Object>> linkedFeatures = new HashMap<String, Map<String, Object>>();
    private Stack<Structure> parentStack = new Stack();
    protected Map<Long, List<Constraint>> constraints = new HashMap<Long, List<Constraint>>();
    private Map<Long, List<Animation>> animations = new HashMap<Long, List<Animation>>();
    private Map<Long, Skeleton> skeletons = new HashMap<Long, Skeleton>();
    private Map<Skeleton, Node> nodesWithSkeletons = new HashMap<Skeleton, Node>();
    protected Map<Long, BoneContext> boneContexts = new HashMap<Long, BoneContext>();
    private Map<String, AbstractBlenderHelper> helpers = new HashMap<String, AbstractBlenderHelper>();
    private Map<String, Map<Object, Object>> markers = new HashMap<String, Map<Object, Object>>();
    private Map<String, BlenderAction> actions = new HashMap<String, BlenderAction>();

    public void setBlenderVersion(String blenderVersion) {
        this.blenderVersion = Integer.parseInt(blenderVersion);
    }

    public int getBlenderVersion() {
        return this.blenderVersion;
    }

    public void setBlenderKey(BlenderKey blenderKey) {
        this.blenderKey = blenderKey;
    }

    public BlenderKey getBlenderKey() {
        return this.blenderKey;
    }

    public void setBlockData(DnaBlockData dnaBlockData) {
        this.dnaBlockData = dnaBlockData;
    }

    public DnaBlockData getDnaBlockData() {
        return this.dnaBlockData;
    }

    public void setSceneStructure(Structure sceneStructure) {
        this.sceneStructure = sceneStructure;
    }

    public Structure getSceneStructure() {
        return this.sceneStructure;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public BlenderInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(BlenderInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void addFileBlockHeader(Long oldMemoryAddress, FileBlockHeader fileBlockHeader) {
        this.blocks.add(fileBlockHeader);
        this.fileBlockHeadersByOma.put(oldMemoryAddress, fileBlockHeader);
        List<FileBlockHeader> headers = this.fileBlockHeadersByCode.get((Object)fileBlockHeader.getCode());
        if (headers == null) {
            headers = new ArrayList<FileBlockHeader>();
            this.fileBlockHeadersByCode.put(fileBlockHeader.getCode(), headers);
        }
        headers.add(fileBlockHeader);
    }

    public List<FileBlockHeader> getBlocks() {
        return this.blocks;
    }

    public FileBlockHeader getFileBlock(Long oldMemoryAddress) {
        return this.fileBlockHeadersByOma.get(oldMemoryAddress);
    }

    public List<FileBlockHeader> getFileBlocks(FileBlockHeader.BlockCode code) {
        return this.fileBlockHeadersByCode.get((Object)code);
    }

    public <T> void putHelper(Class<T> clazz, AbstractBlenderHelper helper) {
        this.helpers.put(clazz.getSimpleName(), helper);
    }

    public <T> T getHelper(Class<?> clazz) {
        return (T)this.helpers.get(clazz.getSimpleName());
    }

    public void addLoadedFeatures(Long oldMemoryAddress, LoadedDataType featureDataType, Object feature) {
        if (oldMemoryAddress == null || featureDataType == null || feature == null) {
            throw new IllegalArgumentException("One of the given arguments is null!");
        }
        Map<LoadedDataType, Object> map = this.loadedFeatures.get(oldMemoryAddress);
        if (map == null) {
            map = new HashMap<LoadedDataType, Object>();
            this.loadedFeatures.put(oldMemoryAddress, map);
        }
        map.put(featureDataType, feature);
    }

    public Object getLoadedFeature(Long oldMemoryAddress, LoadedDataType loadedFeatureDataType) {
        Map<LoadedDataType, Object> result = this.loadedFeatures.get(oldMemoryAddress);
        if (result != null) {
            return result.get((Object)loadedFeatureDataType);
        }
        return null;
    }

    @Deprecated
    public void addLinkedFeature(String blenderFilePath, String featureGroup, Object feature) {
    }

    public Object getLinkedFeature(String blenderFilePath, String featureName) {
        block11: {
            List features;
            Map<String, Object> linkedFeatures;
            block20: {
                String namePrefix;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                linkedFeatures = this.linkedFeatures.get(blenderFilePath);
                                                if (linkedFeatures == null) break block11;
                                                namePrefix = (featureName.charAt(0) + "" + featureName.charAt(1)).toUpperCase();
                                                featureName = featureName.substring(2);
                                                if (!"SC".equals(namePrefix)) break block12;
                                                List scenes = (List)linkedFeatures.get("scenes");
                                                if (scenes == null) break block11;
                                                for (Node scene : scenes) {
                                                    if (!featureName.equals(scene.getName())) continue;
                                                    return scene;
                                                }
                                                break block11;
                                            }
                                            if (!"OB".equals(namePrefix)) break block13;
                                            List features2 = (List)linkedFeatures.get("objects");
                                            if (features2 == null) break block11;
                                            for (Node feature : features2) {
                                                if (!featureName.equals(feature.getName())) continue;
                                                return feature;
                                            }
                                            break block11;
                                        }
                                        if (!"ME".equals(namePrefix)) break block14;
                                        List temporalMeshes = (List)linkedFeatures.get("meshes");
                                        if (temporalMeshes == null) break block11;
                                        for (TemporalMesh temporalMesh : temporalMeshes) {
                                            if (!featureName.equals(temporalMesh.getName())) continue;
                                            return temporalMesh;
                                        }
                                        break block11;
                                    }
                                    if (!"MA".equals(namePrefix)) break block15;
                                    List features3 = (List)linkedFeatures.get("materials");
                                    if (features3 == null) break block11;
                                    for (MaterialContext feature : features3) {
                                        if (!featureName.equals(feature.getName())) continue;
                                        return feature;
                                    }
                                    break block11;
                                }
                                if (!"TX".equals(namePrefix)) break block16;
                                List features4 = (List)linkedFeatures.get("textures");
                                if (features4 == null) break block11;
                                for (Texture feature : features4) {
                                    if (!featureName.equals(feature.getName())) continue;
                                    return feature;
                                }
                                break block11;
                            }
                            if (!"IM".equals(namePrefix)) break block17;
                            List features5 = (List)linkedFeatures.get("images");
                            if (features5 == null) break block11;
                            for (Texture feature : features5) {
                                if (!featureName.equals(feature.getName())) continue;
                                return feature;
                            }
                            break block11;
                        }
                        if (!"AC".equals(namePrefix)) break block18;
                        List features6 = (List)linkedFeatures.get("animations");
                        if (features6 == null) break block11;
                        for (Animation feature : features6) {
                            if (!featureName.equals(feature.getName())) continue;
                            return feature;
                        }
                        break block11;
                    }
                    if (!"CA".equals(namePrefix)) break block19;
                    List features7 = (List)linkedFeatures.get("cameras");
                    if (features7 == null) break block11;
                    for (Camera feature : features7) {
                        if (!featureName.equals(feature.getName())) continue;
                        return feature;
                    }
                    break block11;
                }
                if (!"LA".equals(namePrefix)) break block20;
                List features8 = (List)linkedFeatures.get("lights");
                if (features8 == null) break block11;
                for (Light feature : features8) {
                    if (!featureName.equals(feature.getName())) continue;
                    return feature;
                }
                break block11;
            }
            if ("FI".equals(featureName) && (features = (List)linkedFeatures.get("lights")) != null) {
                for (Filter feature : features) {
                    if (!featureName.equals(feature.getName())) continue;
                    return feature;
                }
            }
        }
        return null;
    }

    public Map<String, Map<String, Object>> getLinkedFeatures() {
        return this.linkedFeatures;
    }

    public void pushParent(Structure parent) {
        this.parentStack.push(parent);
    }

    public Structure popParent() {
        try {
            return this.parentStack.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Structure peekParent() {
        try {
            return this.parentStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void addConstraints(Long ownerOMA, List<Constraint> constraints) {
        List<Constraint> objectConstraints = this.constraints.get(ownerOMA);
        if (objectConstraints == null) {
            objectConstraints = new ArrayList<Constraint>();
            this.constraints.put(ownerOMA, objectConstraints);
        }
        objectConstraints.addAll(constraints);
    }

    public List<Constraint> getConstraints(Long ownerOMA) {
        return this.constraints.get(ownerOMA);
    }

    public List<Constraint> getAllConstraints() {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Map.Entry<Long, List<Constraint>> entry : this.constraints.entrySet()) {
            result.addAll((Collection<Constraint>)entry.getValue());
        }
        return result;
    }

    public void addAnimation(Long ownerOMA, Animation animation) {
        List<Animation> animList = this.animations.get(ownerOMA);
        if (animList == null) {
            animList = new ArrayList<Animation>();
            this.animations.put(ownerOMA, animList);
        }
        animList.add(animation);
    }

    public List<Animation> getAnimations(Long ownerOMA) {
        return this.animations.get(ownerOMA);
    }

    public void setSkeleton(Long skeletonOMA, Skeleton skeleton) {
        this.skeletons.put(skeletonOMA, skeleton);
    }

    public void setNodeForSkeleton(Skeleton skeleton, Node node) {
        this.nodesWithSkeletons.put(skeleton, node);
    }

    public Node getControlledNode(Skeleton skeleton) {
        return this.nodesWithSkeletons.get(skeleton);
    }

    public Skeleton getSkeleton(Long skeletonOMA) {
        return this.skeletons.get(skeletonOMA);
    }

    public void setBoneContext(Long boneOMA, BoneContext boneContext) {
        this.boneContexts.put(boneOMA, boneContext);
    }

    public BoneContext getBoneContext(Long boneOMA) {
        return this.boneContexts.get(boneOMA);
    }

    public BoneContext getBoneByName(Long skeletonOMA, String name) {
        for (Map.Entry<Long, BoneContext> entry : this.boneContexts.entrySet()) {
            Bone bone;
            if (!entry.getValue().getArmatureObjectOMA().equals(skeletonOMA) || (bone = entry.getValue().getBone()) == null || !name.equals(bone.getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    public BoneContext getBoneContext(Bone bone) {
        for (Map.Entry<Long, BoneContext> entry : this.boneContexts.entrySet()) {
            if (!entry.getValue().getBone().getName().equals(bone.getName())) continue;
            return entry.getValue();
        }
        throw new IllegalStateException("Cannot find context for bone: " + bone);
    }

    public synchronized Material getDefaultMaterial() {
        if (this.blenderKey.getDefaultMaterial() == null) {
            Material defaultMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            defaultMaterial.setColor("Color", ColorRGBA.DarkGray);
            this.blenderKey.setDefaultMaterial(defaultMaterial);
        }
        return this.blenderKey.getDefaultMaterial();
    }

    public void addMarker(String marker, Object feature, Object markerValue) {
        if (markerValue == null) {
            throw new IllegalArgumentException("The marker's value cannot be null.");
        }
        Map<Object, Object> markersMap = this.markers.get(marker);
        if (markersMap == null) {
            markersMap = new HashMap<Object, Object>();
            this.markers.put(marker, markersMap);
        }
        markersMap.put(feature, markerValue);
    }

    public Object getMarkerValue(String marker, Object feature) {
        Map<Object, Object> markersMap = this.markers.get(marker);
        return markersMap == null ? null : markersMap.get(feature);
    }

    public void addAction(BlenderAction action) {
        this.actions.put(action.getName(), action);
    }

    public Map<String, BlenderAction> getActions() {
        return this.actions;
    }

    public String toString() {
        return this.blenderKey == null ? "BlenderContext [key = null]" : "BlenderContext [ key = " + this.blenderKey.toString() + " ]";
    }

    public static enum LoadedDataType {
        STRUCTURE,
        FEATURE,
        TEMPORAL_MESH;

    }
}

