/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.ModelKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import java.io.IOException;

public class BlenderKey
extends ModelKey {
    protected static final int DEFAULT_FPS = 25;
    protected int fps = 25;
    protected int featuresToLoad = -1;
    protected boolean loadUnlinkedAssets;
    protected String assetRootPath;
    protected boolean fixUpAxis = true;
    protected int generatedTexturePPU = 128;
    protected String usedWorld;
    protected Material defaultMaterial;
    protected RenderState.FaceCullMode faceCullMode = RenderState.FaceCullMode.Back;
    protected int layersToLoad = -1;
    protected boolean loadObjectProperties = true;
    protected int maxTextureSize = 8192;
    protected boolean loadGeneratedTextures;
    protected MipmapGenerationMethod mipmapGenerationMethod = MipmapGenerationMethod.GENERATE_WHEN_NEEDED;
    protected int skyGeneratedTextureSize = 1000;
    protected float skyGeneratedTextureRadius = 1.0f;
    protected SkyGeneratedTextureShape skyGeneratedTextureShape = SkyGeneratedTextureShape.SPHERE;
    protected boolean optimiseTextures;
    protected AnimationMatchMethod animationMatchMethod = AnimationMatchMethod.AT_LEAST_ONE_NAME_MATCH;
    protected float pointsSize = 1.0f;
    protected float linesWidth = 1.0f;

    public BlenderKey() {
    }

    public BlenderKey(String name) {
        super(name);
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public RenderState.FaceCullMode getFaceCullMode() {
        return this.faceCullMode;
    }

    public void setFaceCullMode(RenderState.FaceCullMode faceCullMode) {
        this.faceCullMode = faceCullMode;
    }

    public void setLayersToLoad(int layersToLoad) {
        this.layersToLoad = layersToLoad;
    }

    public int getLayersToLoad() {
        return this.layersToLoad;
    }

    public void setLoadObjectProperties(boolean loadObjectProperties) {
        this.loadObjectProperties = loadObjectProperties;
    }

    public boolean isLoadObjectProperties() {
        return this.loadObjectProperties;
    }

    public int getMaxTextureSize() {
        return this.maxTextureSize;
    }

    public void setMaxTextureSize(int maxTextureSize) {
        this.maxTextureSize = maxTextureSize;
    }

    public void setLoadGeneratedTextures(boolean loadGeneratedTextures) {
        this.loadGeneratedTextures = loadGeneratedTextures;
    }

    public boolean isLoadGeneratedTextures() {
        return this.loadGeneratedTextures;
    }

    @Deprecated
    public void setAssetRootPath(String assetRootPath) {
        this.assetRootPath = assetRootPath;
    }

    @Deprecated
    public String getAssetRootPath() {
        return this.assetRootPath;
    }

    @Deprecated
    public void includeInLoading(int featuresToLoad) {
        this.featuresToLoad |= featuresToLoad;
    }

    @Deprecated
    public void excludeFromLoading(int featuresNotToLoad) {
        this.featuresToLoad &= ~featuresNotToLoad;
    }

    @Deprecated
    public boolean shouldLoad(int featureToLoad) {
        return (this.featuresToLoad & featureToLoad) != 0;
    }

    @Deprecated
    public int getFeaturesToLoad() {
        return this.featuresToLoad;
    }

    public boolean isLoadUnlinkedAssets() {
        return this.loadUnlinkedAssets;
    }

    public void setLoadUnlinkedAssets(boolean loadUnlinkedAssets) {
        this.loadUnlinkedAssets = loadUnlinkedAssets;
    }

    public void setFixUpAxis(boolean fixUpAxis) {
        this.fixUpAxis = fixUpAxis;
    }

    public boolean isFixUpAxis() {
        return this.fixUpAxis;
    }

    public void setGeneratedTexturePPU(int generatedTexturePPU) {
        this.generatedTexturePPU = generatedTexturePPU;
    }

    public int getGeneratedTexturePPU() {
        return this.generatedTexturePPU;
    }

    public MipmapGenerationMethod getMipmapGenerationMethod() {
        return this.mipmapGenerationMethod;
    }

    public void setMipmapGenerationMethod(MipmapGenerationMethod mipmapGenerationMethod) {
        this.mipmapGenerationMethod = mipmapGenerationMethod;
    }

    public int getSkyGeneratedTextureSize() {
        return this.skyGeneratedTextureSize;
    }

    public void setSkyGeneratedTextureSize(int skyGeneratedTextureSize) {
        if (skyGeneratedTextureSize <= 0) {
            throw new IllegalArgumentException("The texture size must be a positive value (the value given as a parameter: " + skyGeneratedTextureSize + ")!");
        }
        this.skyGeneratedTextureSize = skyGeneratedTextureSize;
    }

    public float getSkyGeneratedTextureRadius() {
        return this.skyGeneratedTextureRadius;
    }

    public void setSkyGeneratedTextureRadius(float skyGeneratedTextureRadius) {
        this.skyGeneratedTextureRadius = skyGeneratedTextureRadius;
    }

    public SkyGeneratedTextureShape getSkyGeneratedTextureShape() {
        return this.skyGeneratedTextureShape;
    }

    public void setSkyGeneratedTextureShape(SkyGeneratedTextureShape skyGeneratedTextureShape) {
        if (skyGeneratedTextureShape == null) {
            throw new IllegalArgumentException("The sky generated shape type cannot be null!");
        }
        this.skyGeneratedTextureShape = skyGeneratedTextureShape;
    }

    public void setOptimiseTextures(boolean optimiseTextures) {
        this.optimiseTextures = optimiseTextures;
    }

    public boolean isOptimiseTextures() {
        return this.optimiseTextures;
    }

    public void setAnimationMatchMethod(AnimationMatchMethod animationMatchMethod) {
        this.animationMatchMethod = animationMatchMethod;
    }

    public AnimationMatchMethod getAnimationMatchMethod() {
        return this.animationMatchMethod;
    }

    public float getPointsSize() {
        return this.pointsSize;
    }

    public void setPointsSize(float pointsSize) {
        this.pointsSize = pointsSize;
    }

    public float getLinesWidth() {
        return this.linesWidth;
    }

    public void setLinesWidth(float linesWidth) {
        this.linesWidth = linesWidth;
    }

    public void setUsedWorld(String usedWorld) {
        this.usedWorld = usedWorld;
    }

    public String getUsedWorld() {
        return this.usedWorld;
    }

    public void setDefaultMaterial(Material defaultMaterial) {
        this.defaultMaterial = defaultMaterial;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule oc = e.getCapsule((Savable)this);
        oc.write(this.fps, "fps", 25);
        oc.write(this.featuresToLoad, "features-to-load", -1);
        oc.write(this.loadUnlinkedAssets, "load-unlinked-assets", false);
        oc.write(this.assetRootPath, "asset-root-path", null);
        oc.write(this.fixUpAxis, "fix-up-axis", true);
        oc.write(this.generatedTexturePPU, "generated-texture-ppu", 128);
        oc.write(this.usedWorld, "used-world", null);
        oc.write((Savable)this.defaultMaterial, "default-material", null);
        oc.write((Enum)this.faceCullMode, "face-cull-mode", (Enum)RenderState.FaceCullMode.Off);
        oc.write(this.layersToLoad, "layers-to-load", -1);
        oc.write((Enum)this.mipmapGenerationMethod, "mipmap-generation-method", (Enum)MipmapGenerationMethod.GENERATE_WHEN_NEEDED);
        oc.write(this.skyGeneratedTextureSize, "sky-generated-texture-size", 1000);
        oc.write(this.skyGeneratedTextureRadius, "sky-generated-texture-radius", 1.0f);
        oc.write((Enum)this.skyGeneratedTextureShape, "sky-generated-texture-shape", (Enum)SkyGeneratedTextureShape.SPHERE);
        oc.write(this.optimiseTextures, "optimise-textures", false);
        oc.write((Enum)this.animationMatchMethod, "animation-match-method", (Enum)AnimationMatchMethod.AT_LEAST_ONE_NAME_MATCH);
        oc.write(this.pointsSize, "points-size", 1.0f);
        oc.write(this.linesWidth, "lines-width", 1.0f);
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule ic = e.getCapsule((Savable)this);
        this.fps = ic.readInt("fps", 25);
        this.featuresToLoad = ic.readInt("features-to-load", -1);
        this.loadUnlinkedAssets = ic.readBoolean("load-unlinked-assets", false);
        this.assetRootPath = ic.readString("asset-root-path", null);
        this.fixUpAxis = ic.readBoolean("fix-up-axis", true);
        this.generatedTexturePPU = ic.readInt("generated-texture-ppu", 128);
        this.usedWorld = ic.readString("used-world", null);
        this.defaultMaterial = (Material)ic.readSavable("default-material", null);
        this.faceCullMode = (RenderState.FaceCullMode)ic.readEnum("face-cull-mode", RenderState.FaceCullMode.class, (Enum)RenderState.FaceCullMode.Off);
        this.layersToLoad = ic.readInt("layers-to=load", -1);
        this.mipmapGenerationMethod = (MipmapGenerationMethod)ic.readEnum("mipmap-generation-method", MipmapGenerationMethod.class, (Enum)MipmapGenerationMethod.GENERATE_WHEN_NEEDED);
        this.skyGeneratedTextureSize = ic.readInt("sky-generated-texture-size", 1000);
        this.skyGeneratedTextureRadius = ic.readFloat("sky-generated-texture-radius", 1.0f);
        this.skyGeneratedTextureShape = (SkyGeneratedTextureShape)ic.readEnum("sky-generated-texture-shape", SkyGeneratedTextureShape.class, (Enum)SkyGeneratedTextureShape.SPHERE);
        this.optimiseTextures = ic.readBoolean("optimise-textures", false);
        this.animationMatchMethod = (AnimationMatchMethod)ic.readEnum("animation-match-method", AnimationMatchMethod.class, (Enum)AnimationMatchMethod.AT_LEAST_ONE_NAME_MATCH);
        this.pointsSize = ic.readFloat("points-size", 1.0f);
        this.linesWidth = ic.readFloat("lines-width", 1.0f);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.animationMatchMethod == null ? 0 : this.animationMatchMethod.hashCode());
        result = 31 * result + (this.assetRootPath == null ? 0 : this.assetRootPath.hashCode());
        result = 31 * result + (this.defaultMaterial == null ? 0 : this.defaultMaterial.hashCode());
        result = 31 * result + (this.faceCullMode == null ? 0 : this.faceCullMode.hashCode());
        result = 31 * result + this.featuresToLoad;
        result = 31 * result + (this.fixUpAxis ? 1231 : 1237);
        result = 31 * result + this.fps;
        result = 31 * result + this.generatedTexturePPU;
        result = 31 * result + this.layersToLoad;
        result = 31 * result + (this.loadGeneratedTextures ? 1231 : 1237);
        result = 31 * result + (this.loadObjectProperties ? 1231 : 1237);
        result = 31 * result + (this.loadUnlinkedAssets ? 1231 : 1237);
        result = 31 * result + this.maxTextureSize;
        result = 31 * result + (this.mipmapGenerationMethod == null ? 0 : this.mipmapGenerationMethod.hashCode());
        result = 31 * result + (this.optimiseTextures ? 1231 : 1237);
        result = 31 * result + Float.floatToIntBits(this.skyGeneratedTextureRadius);
        result = 31 * result + (this.skyGeneratedTextureShape == null ? 0 : this.skyGeneratedTextureShape.hashCode());
        result = 31 * result + this.skyGeneratedTextureSize;
        result = 31 * result + (this.usedWorld == null ? 0 : this.usedWorld.hashCode());
        result = 31 * result + (int)this.pointsSize;
        result = 31 * result + (int)this.linesWidth;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlenderKey) {
            return false;
        }
        BlenderKey other = (BlenderKey)((Object)obj);
        if (this.animationMatchMethod != other.animationMatchMethod) {
            return false;
        }
        if (this.assetRootPath == null ? other.assetRootPath != null : !this.assetRootPath.equals(other.assetRootPath)) {
            return false;
        }
        if (this.defaultMaterial == null ? other.defaultMaterial != null : !this.defaultMaterial.equals(other.defaultMaterial)) {
            return false;
        }
        if (this.faceCullMode != other.faceCullMode) {
            return false;
        }
        if (this.featuresToLoad != other.featuresToLoad) {
            return false;
        }
        if (this.fixUpAxis != other.fixUpAxis) {
            return false;
        }
        if (this.fps != other.fps) {
            return false;
        }
        if (this.generatedTexturePPU != other.generatedTexturePPU) {
            return false;
        }
        if (this.layersToLoad != other.layersToLoad) {
            return false;
        }
        if (this.loadGeneratedTextures != other.loadGeneratedTextures) {
            return false;
        }
        if (this.loadObjectProperties != other.loadObjectProperties) {
            return false;
        }
        if (this.loadUnlinkedAssets != other.loadUnlinkedAssets) {
            return false;
        }
        if (this.maxTextureSize != other.maxTextureSize) {
            return false;
        }
        if (this.mipmapGenerationMethod != other.mipmapGenerationMethod) {
            return false;
        }
        if (this.optimiseTextures != other.optimiseTextures) {
            return false;
        }
        if (Float.floatToIntBits(this.skyGeneratedTextureRadius) != Float.floatToIntBits(other.skyGeneratedTextureRadius)) {
            return false;
        }
        if (this.skyGeneratedTextureShape != other.skyGeneratedTextureShape) {
            return false;
        }
        if (this.skyGeneratedTextureSize != other.skyGeneratedTextureSize) {
            return false;
        }
        if (this.usedWorld == null ? other.usedWorld != null : !this.usedWorld.equals(other.usedWorld)) {
            return false;
        }
        if (this.pointsSize != other.pointsSize) {
            return false;
        }
        return this.linesWidth == other.linesWidth;
    }

    public static enum AnimationMatchMethod {
        AT_LEAST_ONE_NAME_MATCH,
        ALL_NAMES_MATCH;

    }

    public static enum SkyGeneratedTextureShape {
        CUBE,
        SPHERE;

    }

    @Deprecated
    public static interface FeaturesToLoad {
        public static final int SCENES = 65535;
        public static final int OBJECTS = 11;
        public static final int ANIMATIONS = 4;
        public static final int MATERIALS = 3;
        public static final int TEXTURES = 1;
        public static final int CAMERAS = 32;
        public static final int LIGHTS = 16;
        public static final int WORLD = 64;
        public static final int ALL = -1;
    }

    public static enum MipmapGenerationMethod {
        NEVER_GENERATE,
        ALWAYS_GENERATE,
        GENERATE_WHEN_NEEDED;

    }
}

