/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptType;

public class VisualizationSettings {
    public static final long ONE_HOUR = 3600000L;
    public static final long HOURS_12 = 43200000L;
    public static final long HOURS_24 = 86400000L;
    public static final long HOURS_48 = 172800000L;
    public static final String PROP_EVENTS_PER_STEP = "property_events_per_step";
    public static final String PROP_FINISH_DATE = "property_finishDate";
    public static final String PROP_MODE = "property_mode";
    public static final String PROP_PAUSE = "property_pause";
    public static final String PROP_PLAY = "property_play";
    public static final String PROP_QUERY_ADDITION = "property_queryAddition";
    public static final String PROP_SETTINGS_CHANGED = "property_settings_changed";
    public static final String PROP_START_DATE = "property_startDate";
    public static final String PROP_STEP_DELAY = "property_step_delay";
    public static final String PROP_TEXT_HIGHLIGHT = "property_textHighlight";
    public static final String PROP_VISUALIZATION_SCRIPT_NAME = "property_script_name";
    public static final String PROP_VISUALIZATION_REALTIME = "property_realtime";
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private Map<String, Script> configScripts = new HashMap<String, Script>();
    private int eventsPerStep;
    private long finishDate;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String queryAddition;
    private String scriptName;
    private long startDate;
    private long stepDelay;
    private String textHighlight;

    public VisualizationSettings() {
        long now = System.currentTimeMillis();
        this.startDate = now - 3600000L;
        this.finishDate = now;
        this.refreshConfigScriptList();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String prop, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(prop, oldValue, newValue);
    }

    public int getEventsPerStep() {
        return this.eventsPerStep;
    }

    public void setEventsPerStep(int eventsPerStep) {
        int oldEventsPerStep = this.eventsPerStep;
        this.eventsPerStep = eventsPerStep;
        this.pcs.firePropertyChange(PROP_EVENTS_PER_STEP, oldEventsPerStep, eventsPerStep);
    }

    public long getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(long finishDate) {
        long oldFinishDate = this.finishDate;
        this.finishDate = finishDate;
        this.pcs.firePropertyChange(PROP_FINISH_DATE, oldFinishDate, finishDate);
    }

    public String getQueryAddition() {
        return this.queryAddition;
    }

    public void setQueryAddition(String queryAddition) {
        this.queryAddition = queryAddition;
    }

    public Script getScriptByName(String name) {
        return this.configScripts.get(name);
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        String oldScriptName = this.scriptName;
        this.scriptName = scriptName;
        this.firePropertyChange(PROP_VISUALIZATION_SCRIPT_NAME, oldScriptName, scriptName);
    }

    public Set<String> getScriptNames() {
        return new TreeSet<String>(this.configScripts.keySet());
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long startDate) {
        long oldStartDate = this.startDate;
        this.startDate = startDate;
        this.pcs.firePropertyChange(PROP_START_DATE, oldStartDate, startDate);
    }

    public long getStepDelay() {
        return this.stepDelay;
    }

    public void setStepDelay(long stepDelay) {
        long oldStepDelay = this.stepDelay;
        this.stepDelay = stepDelay;
        this.pcs.firePropertyChange(PROP_STEP_DELAY, oldStepDelay, stepDelay);
    }

    public String getTextHighlight() {
        return this.textHighlight;
    }

    public void setTextHighlight(String textHighlight) {
        this.textHighlight = textHighlight;
    }

    public void load() {
        Preferences p = NbPreferences.forModule(VisualizationSettings.class);
    }

    public final void refreshConfigScriptList() {
        try {
            List list = this.apiService.getScriptsByType(ScriptType.VISUALISATION_CONFIGURATION);
            if (list != null) {
                for (Script s : list) {
                    this.configScripts.put(s.getName(), s);
                }
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void reset() {
        this.eventsPerStep = 1;
        this.pcs.firePropertyChange(PROP_EVENTS_PER_STEP, 0, 1);
        this.stepDelay = 100L;
        this.pcs.firePropertyChange(PROP_STEP_DELAY, (Object)0, 100L);
        this.queryAddition = "";
        this.pcs.firePropertyChange(PROP_QUERY_ADDITION, ".", this.queryAddition);
        this.startDate = System.currentTimeMillis() - 3600000L;
        this.pcs.firePropertyChange(PROP_START_DATE, 0L, this.startDate);
    }

    public void save() {
        Preferences p = NbPreferences.forModule(VisualizationSettings.class);
    }
}

