/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.joda.time.DateTime;
import org.openide.util.Lookup;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;

public class ProducerSupplier
extends Thread {
    private List<SecurityEvent> events = new ArrayList<SecurityEvent>();
    private final String query;
    private long from;
    private long to;
    private final int page;
    private SearchState searchState;
    protected static final Logger LOGGER = Logger.getLogger(ProducerSupplier.class.getName());
    protected ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private static final int MAX_RETRIES = 300;
    private static final long DELAY = 2L;
    private static final long MAX_DELAY = 86400L;
    private final RetryPolicy<Object> retryPolicy = ((RetryPolicy)new RetryPolicy().handle(new Class[]{ApiServiceException_Exception.class, ConnectException.class, WebServiceException.class, SocketTimeoutException.class})).withBackoff(2L, 86400L, ChronoUnit.SECONDS).withMaxRetries(300).onRetry(t -> LOGGER.info(String.format("RETRY %d: %s", t.getAttemptCount(), t.getLastFailure().getMessage()))).onFailedAttempt(t -> LOGGER.info(String.format("FAILED RETRY %d: %s", t.getAttemptCount(), t.getLastFailure().getMessage())));

    public ProducerSupplier(String query, long from, long to, int page, SearchState searchState) {
        super("ProducerSupplier");
        this.query = query;
        this.from = from;
        this.to = to;
        this.page = page;
        this.searchState = searchState;
    }

    public List<SecurityEvent> getEvents() {
        ArrayList<SecurityEvent> ret = new ArrayList<SecurityEvent>();
        ret.addAll(this.events);
        this.events.clear();
        return ret;
    }

    protected List<SecurityEvent> search(String query, long from, long to) throws ApiServiceException_Exception, ConnectException {
        SecurityEventsSearchResults results = this.apiService.searchSecurityEventsAsc(query, this.searchState, this.page, from, to);
        this.searchState = results.getSearchState();
        LOGGER.info(String.format("Searching security events by QUERY: %s, PAGE: %d [%d - %d], FROM: %s, TO: %s", query, this.page, this.searchState.getOffset(), this.searchState.getTotalHits(), new DateTime(from), new DateTime(to)));
        return results.getContainer().getSecurityEvents();
    }

    @Override
    public void run() {
        try {
            this.events = (List)Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).onFailure(t -> LOGGER.info(String.format("Execution error %d: %s", t.getAttemptCount(), t.getFailure().getMessage()))).get(() -> this.search(this.query, this.from, this.to));
            if (!this.events.isEmpty()) {
                this.from = this.events.get(this.events.size() - 1).getTimestamp() + 1L;
            }
            while (!this.isInterrupted()) {
                while (this.events.size() < this.page) {
                    this.events.addAll((Collection)Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).onFailure(t -> LOGGER.info(String.format("Execution error %d: %s", t.getAttemptCount(), t.getFailure().getMessage()))).get(() -> this.search(this.query, this.from, this.to)));
                    if (!this.events.isEmpty()) {
                        this.from = this.events.get(this.events.size() - 1).getTimestamp() + 1L;
                    } else {
                        this.from = this.to + 1L;
                        this.to = System.currentTimeMillis();
                    }
                    if (this.events.size() >= this.page) continue;
                    Thread.sleep(60000L);
                }
            }
        }
        catch (InterruptedException ex) {
            this.interrupt();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error", ex);
        }
    }
}

