/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import com.jme3.math.ColorRGBA;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.visualization.VisualizationTopComponent;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationManager;

public class NodeHighlightEvaluator {
    private final Logger logger = Logger.getLogger(NodeHighlightEvaluator.class.getName());
    private VisualizationManager visManager = (VisualizationManager)Lookup.getDefault().lookup(VisualizationManager.class);
    private ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");

    public void evalWithJavaScript(List<Node> allNodesList, String query) {
        if (!query.isEmpty()) {
            for (Node n : allNodesList) {
                try {
                    Set attributes = n.attributes();
                    for (String attr : attributes) {
                        this.engine.put(attr.replace("%", ""), n.get(attr));
                    }
                    boolean highlight = (Boolean)this.engine.eval(query);
                    if (!highlight) continue;
                    ColorRGBA[] colors = new ColorRGBA[]{ColorRGBA.White, ColorRGBA.White};
                    this.visManager.getApp().objectGlow(n.id, 0.0f, 5.0f, colors);
                }
                catch (ScriptException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void evalWithRegexp(List<Node> allNodesList, String regexp, String newAttrValuePair) {
        if (!regexp.isEmpty()) {
            try {
                if (!regexp.contains(": ")) {
                    regexp = regexp.replaceAll(":", ": ");
                }
                Pattern pattern = Pattern.compile(".*" + regexp + ".*");
                for (Node n : allNodesList) {
                    Set attributes = n.attributes();
                    StringBuilder sb = new StringBuilder();
                    for (String attr : attributes) {
                        sb.append(attr);
                        sb.append(": ");
                        sb.append(n.get(attr));
                        sb.append(" ");
                    }
                    Matcher matcher = pattern.matcher(sb);
                    if (!matcher.matches()) continue;
                    ColorRGBA[] colors = new ColorRGBA[]{ColorRGBA.White, ColorRGBA.White};
                    this.visManager.getApp().objectGlow(n.id, 0.0f, 5.0f, colors);
                    String[] keyValuePair = newAttrValuePair.split(":");
                    if (keyValuePair.length != 2) continue;
                    String key = keyValuePair[0];
                    String value = keyValuePair[1];
                    n.remove(key.trim());
                    n.set(key.trim(), value.trim());
                }
            }
            catch (PatternSyntaxException ex) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        TopComponent visTC = WindowManager.getDefault().findTopComponent("VisualizationPropertiesTopComponent");
                        JOptionPane.showMessageDialog((Component)visTC, ex.getLocalizedMessage(), NbBundle.getMessage(VisualizationTopComponent.class, (String)"NodeHighlightEvaluator.regexp.error.title"), 2);
                    }
                });
            }
        }
    }
}

