/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.core.module.visengine.VisualizationException;
import rs.co.ast.aspen.gui.module.visualization.Config;
import rs.co.ast.aspen.gui.module.visualization.properties.Producer;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationManager;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationPropertiesTopComponent;

@TopComponent.Description(preferredID="VisualizationTopComponent", iconBase="eye.png", persistenceType=2)
public final class VisualizationTopComponent
extends TopComponent
implements PropertyChangeListener {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private SearchState searchState = new SearchState();
    private static final Logger logger = Logger.getLogger(VisualizationTopComponent.class.getName());
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private String tag = UUID.randomUUID().toString();
    private VisualizationManager visManager = (VisualizationManager)Lookup.getDefault().lookup(VisualizationManager.class);
    private VisualizationPropertiesTopComponent visPropTC = (VisualizationPropertiesTopComponent)WindowManager.getDefault().findTopComponent("VisualizationPropertiesTopComponent");
    private String scriptName;
    private JPanel panel;

    public VisualizationTopComponent() {
        logger.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.VISUALIZATION), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.VISUALIZATION)));
        this.initComponents();
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        this.setName(NbBundle.getMessage(VisualizationTopComponent.class, (String)"CTL_VisualizationTopComponent"));
        this.setToolTipText(NbBundle.getMessage(VisualizationTopComponent.class, (String)"HINT_VisualizationTopComponent"));
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.setLayout(new BorderLayout());
        this.panel.setLayout(new BorderLayout());
        this.add(this.panel, "Center");
    }

    public void componentOpened() {
        super.componentOpened();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizationTopComponent.this.init(false);
            }
        });
    }

    protected void componentActivated() {
        super.componentActivated();
    }

    public void componentClosed() {
        this.resetApp();
        this.visManager.appStop();
        if (this.visPropTC.isOpened()) {
            this.visPropTC.close();
        }
        System.gc();
    }

    private void resetApp() {
        if (this.visManager.getApp() != null) {
            this.visManager.reset();
            this.visManager.stopNodeWorker();
        }
        this.visManager.removePropertyChangeListener(this);
        this.visManager.removePropertyChangeListener(this.visPropTC);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public String getTag() {
        return this.tag;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.visManager.getSettings().setScriptName(scriptName);
        this.scriptName = scriptName;
    }

    public void init(boolean applySettings) {
        try {
            if (this.visPropTC != null) {
                this.visPropTC.removeComboBoxRuleSetActionListener();
                this.visManager.getSettings().refreshConfigScriptList();
                this.visPropTC.setScriptName(this.scriptName);
                this.visManager.removePropertyChangeListener(this);
                this.visManager.removePropertyChangeListener(this.visPropTC);
                this.visManager.addPropertyChangeListener(this);
                this.visManager.addPropertyChangeListener(this.visPropTC);
                Config config = this.visManager.initConfig(this.scriptName, false);
                if (config != null) {
                    this.visManager.initOrResetApp(this.panel, config, applySettings, this.visPropTC.isRealtime());
                    if (!this.visPropTC.isOpened()) {
                        this.visPropTC.open();
                        this.visPropTC.requestActive();
                    } else {
                        this.visPropTC.requestActive();
                    }
                } else {
                    this.close();
                }
                this.visPropTC.addComboBoxRuleSetActionListener();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "property_settings_changed": {
                logger.info("PROP_SETTINGS_CHANGED");
                this.resetApp();
                this.init(true);
                break;
            }
            case "property_step_delay": {
                logger.info("PROP_STEP_DELAY");
                this.visManager.getNodeManager().updateStepDelay((Long)evt.getNewValue());
                break;
            }
            case "property_events_per_step": {
                logger.info("PROP_EVENTS_PER_STEP");
                this.visManager.getNodeManager().updateEventsPerStep((Integer)evt.getNewValue());
                break;
            }
            case "property_textHighlight": {
                break;
            }
            case "property_pause": {
                logger.info("PAUSE clicked");
                this.visManager.pauseNodeWorker();
                break;
            }
            case "property_play": {
                logger.info("PLAY clicked");
                this.visManager.unpauseNodeWorker();
                break;
            }
            case "property_mode": {
                logger.info("PROP_MODE");
                this.visManager.getNodeManager().unpauseConsumer();
                this.visManager.changeMode(Producer.Mode.STEPPING);
                try {
                    this.visManager.nextStep();
                }
                catch (InterruptedException | VisualizationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case "property_realtime": {
                this.init(true);
            }
        }
    }
}

