/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.compiling.Lexer;
import com.github.zafarkhaja.semver.compiling.LexerException;
import com.github.zafarkhaja.semver.compiling.Token;
import com.github.zafarkhaja.semver.util.Stream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MvnLexer
extends Lexer<MvnToken> {
    MvnLexer() {
    }

    @Override
    protected Stream<MvnToken> tokenize(String input) {
        ArrayList<MvnToken> tokens = new ArrayList<MvnToken>();
        int tokenPos = 0;
        while (!input.isEmpty()) {
            boolean matched = false;
            for (MvnToken.Type tokenType : MvnToken.Type.values()) {
                Matcher matcher = tokenType.pattern.matcher(input);
                if (!matcher.find()) continue;
                matched = true;
                input = matcher.replaceFirst("");
                tokens.add(new MvnToken(tokenType, matcher.group(), tokenPos));
                tokenPos += matcher.end();
                break;
            }
            if (matched) continue;
            throw new LexerException(input);
        }
        tokens.add(new MvnToken(MvnToken.Type.EOI, null, tokenPos));
        return new Stream<MvnToken>(tokens.toArray(new MvnToken[tokens.size()]));
    }

    static class MvnToken
    extends Token<MvnToken> {
        MvnToken(Type type, String lexeme, int position) {
            super(type, lexeme == null ? "" : lexeme, position);
        }

        static enum Type implements Token.Type<MvnToken>
        {
            ALPHA_NUMERIC("(\\d*\\p{L}(\\p{L}|\\d)*)|0\\d+"),
            NUMERIC("0|[1-9][0-9]*"),
            DOT("\\."),
            HYPHEN("-"),
            PLUS("\\+"),
            LEFT_SQBR("\\["),
            RIGHT_SQBR("\\]"),
            LEFT_PAREN("\\("),
            RIGHT_PAREN("\\)"),
            COMMA(","),
            EOI("?!");

            final Pattern pattern;

            private Type(String regexp) {
                this.pattern = Pattern.compile("^(" + regexp + ")");
            }

            public String toString() {
                return this.name() + "(" + this.pattern + ")";
            }

            @Override
            public boolean isMatchedBy(MvnToken token) {
                return token != null && this == token.type;
            }
        }
    }
}

