/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.Equal;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.Greater;
import com.github.zafarkhaja.semver.expr.GreaterOrEqual;
import com.github.zafarkhaja.semver.expr.Less;
import com.github.zafarkhaja.semver.expr.LessOrEqual;
import com.github.zafarkhaja.semver.expr.NotEqual;
import java.util.function.Predicate;

public class CompositeExpression
implements Expression {
    private Predicate<Version> exprTree;

    public CompositeExpression(Predicate<Version> expr) {
        this.exprTree = expr;
    }

    public boolean interpret(String version) {
        return this.test(Version.valueOf(version));
    }

    @Override
    public boolean test(Version version) {
        return this.exprTree.test(version);
    }

    public CompositeExpression and(Predicate<? super Version> other) {
        return new CompositeExpression(this.exprTree.and(other));
    }

    public CompositeExpression or(Predicate<? super Version> other) {
        return new CompositeExpression(this.exprTree.or(other));
    }

    public static class Helper {
        public static CompositeExpression not(Predicate<Version> expr) {
            return new CompositeExpression(expr.negate());
        }

        public static CompositeExpression eq(Version version) {
            return new CompositeExpression(new Equal(version));
        }

        public static CompositeExpression eq(String version) {
            return Helper.eq(Version.valueOf(version));
        }

        public static CompositeExpression neq(Version version) {
            return new CompositeExpression(new NotEqual(version));
        }

        public static CompositeExpression neq(String version) {
            return Helper.neq(Version.valueOf(version));
        }

        public static CompositeExpression gt(Version version) {
            return new CompositeExpression(new Greater(version));
        }

        public static CompositeExpression gt(String version) {
            return Helper.gt(Version.valueOf(version));
        }

        public static CompositeExpression gte(Version version) {
            return new CompositeExpression(new GreaterOrEqual(version));
        }

        public static CompositeExpression gte(String version) {
            return Helper.gte(Version.valueOf(version));
        }

        public static CompositeExpression lt(Version version) {
            return new CompositeExpression(new Less(version));
        }

        public static CompositeExpression lt(String version) {
            return Helper.lt(Version.valueOf(version));
        }

        public static CompositeExpression lte(Version version) {
            return new CompositeExpression(new LessOrEqual(version));
        }

        public static CompositeExpression lte(String version) {
            return Helper.lte(Version.valueOf(version));
        }
    }
}

