/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

import java.io.Serializable;
import java.util.Locale;

class NormalVersion
implements Comparable<NormalVersion>,
Serializable {
    private static final long serialVersionUID = -5646200921684070847L;
    private final int major;
    private final int minor;
    private final int patch;

    NormalVersion(int major, int minor, int patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Major, minor and patch versions MUST be non-negative integers.");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    NormalVersion(int major, int minor) {
        if (major < 0 || minor < 0) {
            throw new IllegalArgumentException("Major and minor versions MUST be non-negative integers.");
        }
        this.major = major;
        this.minor = minor;
        this.patch = 0;
    }

    NormalVersion(int major) {
        if (major < 0) {
            throw new IllegalArgumentException("Major version MUST be a non-negative integer.");
        }
        this.major = major;
        this.minor = 0;
        this.patch = 0;
    }

    NormalVersion withPatch(int patch) {
        return new NormalVersion(this.major, this.minor, patch);
    }

    NormalVersion withMinor(int minor) {
        return new NormalVersion(this.major, minor, this.patch);
    }

    NormalVersion withMajor(int major) {
        return new NormalVersion(major, this.minor, this.patch);
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    int getPatch() {
        return this.patch;
    }

    NormalVersion incrementMajor() {
        return new NormalVersion(this.major + 1, 0, 0);
    }

    NormalVersion incrementMinor() {
        return new NormalVersion(this.major, this.minor + 1, 0);
    }

    NormalVersion incrementPatch() {
        return new NormalVersion(this.major, this.minor, this.patch + 1);
    }

    @Override
    public int compareTo(NormalVersion other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0) {
            result = this.patch - other.patch;
        }
        return result;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NormalVersion && this.compareTo((NormalVersion)other) == 0;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.major;
        hash = 31 * hash + this.minor;
        hash = 31 * hash + this.patch;
        return hash;
    }

    public String toString() {
        return String.format(Locale.US, "%d.%d.%d", this.major, this.minor, this.patch);
    }
}

