/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public class LabelWidget
extends Widget {
    private String label;
    private Alignment alignment = Alignment.LEFT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.BASELINE;
    private Orientation orientation = Orientation.NORMAL;
    private boolean paintAsDisabled;
    private boolean useGlyphVector = false;
    private GlyphVector cacheGlyphVector;
    private String cacheLabel;
    private Font cacheFont;

    public LabelWidget(Scene scene) {
        this(scene, null);
    }

    public LabelWidget(Scene scene, String label) {
        super(scene);
        this.setOpaque(false);
        this.setLabel(label);
        this.setCheckClipping(true);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (GeomUtil.equals(this.label, label)) {
            return;
        }
        this.label = label;
        this.revalidate();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.repaint();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.repaint();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.revalidate();
    }

    public boolean isPaintAsDisabled() {
        return this.paintAsDisabled;
    }

    public void setPaintAsDisabled(boolean paintAsDisabled) {
        boolean repaint = this.paintAsDisabled != paintAsDisabled;
        this.paintAsDisabled = paintAsDisabled;
        if (repaint) {
            this.repaint();
        }
    }

    public boolean isUseGlyphVector() {
        return this.useGlyphVector;
    }

    public void setUseGlyphVector(boolean useGlyphVector) {
        if (this.useGlyphVector == useGlyphVector) {
            return;
        }
        this.useGlyphVector = useGlyphVector;
        this.cacheGlyphVector = null;
        this.cacheLabel = null;
        this.cacheFont = null;
        this.revalidate();
    }

    private void assureGlyphVector() {
        Font font = this.getFont();
        FontRenderContext fontRenderContext = this.getGraphics().getFontRenderContext();
        if (this.cacheGlyphVector != null && this.cacheFont == font && this.cacheLabel == this.label) {
            return;
        }
        this.cacheFont = font;
        this.cacheLabel = this.label;
        this.cacheGlyphVector = font.createGlyphVector(new FontRenderContext(new AffineTransform(), fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics()), this.cacheLabel);
    }

    @Override
    protected Rectangle calculateClientArea() {
        Rectangle rectangle;
        if (this.label == null) {
            return super.calculateClientArea();
        }
        if (this.useGlyphVector) {
            this.assureGlyphVector();
            rectangle = GeomUtil.roundRectangle(this.cacheGlyphVector.getVisualBounds());
            rectangle.grow(1, 1);
        } else {
            Graphics2D gr = this.getGraphics();
            if (gr == null) {
                return super.calculateClientArea();
            }
            FontMetrics fontMetrics = gr.getFontMetrics(this.getFont());
            Rectangle2D stringBounds = fontMetrics.getStringBounds(this.label, gr);
            rectangle = GeomUtil.roundRectangle(stringBounds);
        }
        switch (this.orientation) {
            case NORMAL: {
                return rectangle;
            }
            case ROTATE_90: {
                return new Rectangle(rectangle.y, -rectangle.x - rectangle.width, rectangle.height, rectangle.width);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void paintWidget() {
        int y;
        int x;
        if (this.label == null) {
            return;
        }
        Graphics2D gr = this.getGraphics();
        if (this.useGlyphVector) {
            this.assureGlyphVector();
        } else {
            gr.setFont(this.getFont());
        }
        FontMetrics fontMetrics = gr.getFontMetrics();
        Rectangle clientArea = this.getClientArea();
        block0 : switch (this.orientation) {
            case NORMAL: {
                switch (this.alignment) {
                    case BASELINE: {
                        x = 0;
                        break;
                    }
                    case LEFT: {
                        x = clientArea.x;
                        break;
                    }
                    case CENTER: {
                        if (this.useGlyphVector) {
                            x = clientArea.x + (clientArea.width - this.getCacheGlyphVectorWidth()) / 2;
                            break;
                        }
                        x = clientArea.x + (clientArea.width - fontMetrics.stringWidth(this.label)) / 2;
                        break;
                    }
                    case RIGHT: {
                        if (this.useGlyphVector) {
                            x = clientArea.x + clientArea.width - this.getCacheGlyphVectorWidth();
                            break;
                        }
                        x = clientArea.x + clientArea.width - fontMetrics.stringWidth(this.label);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                switch (this.verticalAlignment) {
                    case BASELINE: {
                        y = 0;
                        break block0;
                    }
                    case TOP: {
                        y = clientArea.y + fontMetrics.getAscent();
                        break block0;
                    }
                    case CENTER: {
                        y = clientArea.y + (clientArea.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                        break block0;
                    }
                    case BOTTOM: {
                        y = clientArea.y + clientArea.height - fontMetrics.getDescent();
                        break block0;
                    }
                }
                return;
            }
            case ROTATE_90: {
                switch (this.alignment) {
                    case BASELINE: {
                        x = 0;
                        break;
                    }
                    case LEFT: {
                        x = clientArea.x + fontMetrics.getAscent();
                        break;
                    }
                    case CENTER: {
                        x = clientArea.x + (clientArea.width + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                        break;
                    }
                    case RIGHT: {
                        x = clientArea.x + clientArea.width - fontMetrics.getDescent();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                switch (this.verticalAlignment) {
                    case BASELINE: {
                        y = 0;
                        break block0;
                    }
                    case TOP: {
                        if (this.useGlyphVector) {
                            y = clientArea.y + this.getCacheGlyphVectorWidth();
                            break block0;
                        }
                        y = clientArea.y + fontMetrics.stringWidth(this.label);
                        break block0;
                    }
                    case CENTER: {
                        if (this.useGlyphVector) {
                            y = clientArea.y + (clientArea.height + this.getCacheGlyphVectorWidth()) / 2;
                            break block0;
                        }
                        y = clientArea.y + (clientArea.height + fontMetrics.stringWidth(this.label)) / 2;
                        break block0;
                    }
                    case BOTTOM: {
                        y = clientArea.y + clientArea.height;
                        break block0;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
        AffineTransform previousTransform = gr.getTransform();
        gr.translate(x, y);
        switch (this.orientation) {
            case NORMAL: {
                break;
            }
            case ROTATE_90: {
                gr.rotate(-1.5707963267948966);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Paint background = this.getBackground();
        if (this.paintAsDisabled && background instanceof Color) {
            Color color = (Color)background;
            gr.setColor(color.brighter());
            if (this.useGlyphVector) {
                gr.fill(this.cacheGlyphVector.getOutline(1.0f, 1.0f));
            } else {
                gr.drawString(this.label, 1, 1);
            }
            gr.setColor(color.darker());
            if (this.useGlyphVector) {
                gr.fill(this.cacheGlyphVector.getOutline());
            } else {
                gr.drawString(this.label, 0, 0);
            }
        } else {
            gr.setColor(this.getForeground());
            if (this.useGlyphVector) {
                gr.fill(this.cacheGlyphVector.getOutline());
            } else {
                gr.drawString(this.label, 0, 0);
            }
        }
        gr.setTransform(previousTransform);
    }

    private int getCacheGlyphVectorWidth() {
        return GeomUtil.roundRectangle((Rectangle2D)this.cacheGlyphVector.getVisualBounds()).width;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        BASELINE;

    }

    public static enum Orientation {
        NORMAL,
        ROTATE_90;

    }

    public static enum VerticalAlignment {
        TOP,
        BOTTOM,
        CENTER,
        BASELINE;

    }
}

