/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.search;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.gui.module.securityevents.search.SearchContext;
import rs.co.ast.aspen.gui.module.securityevents.search.SearchTask;
import rs.co.ast.aspen.gui.module.securityevents.search.TaskMonitor;

public final class FetchTask
implements SearchTask<SwingWorker<SecurityEventsSearchResults, Void>, SecurityEventsSearchResults> {
    private static final Logger logger = Logger.getLogger(FetchTask.class.getName());
    private SearchState searchState;
    private SearchContext searchContext;
    private String query;
    private int pageLength;
    private DateRange dateRange;
    private boolean sortAsc;
    private long timeout;
    private SecurityEventsSearchResults results;

    public FetchTask(SearchContext searchContext, String query, int pageLength, DateRange dateRange, boolean sortAsc) {
        this.searchContext = searchContext;
        this.query = query;
        this.pageLength = pageLength;
        this.dateRange = dateRange;
        this.sortAsc = sortAsc;
        this.timeout = 60000L;
        this.searchState = searchContext.getSearchStateForDateRange().get(dateRange);
    }

    public FetchTask(SearchContext searchContext, String query, int pageLength, DateRange dateRange, boolean sortAsc, long offset) {
        this(searchContext, query, pageLength, dateRange, sortAsc);
        this.searchState.setOffset(offset);
    }

    @Override
    public SwingWorker<SecurityEventsSearchResults, Void> getTask() {
        return new SwingWorker<SecurityEventsSearchResults, Void>(){

            @Override
            protected SecurityEventsSearchResults doInBackground() throws Exception {
                if (FetchTask.this.sortAsc) {
                    return SearchTask.apiService.fetchSecurityEventsAscWithOffset(FetchTask.this.query, FetchTask.this.searchState, FetchTask.this.pageLength, FetchTask.this.dateRange.getStartTimeStamp(), FetchTask.this.dateRange.getFinishTimeStamp());
                }
                return SearchTask.apiService.fetchSecurityEventsWithOffset(FetchTask.this.query, FetchTask.this.searchState, FetchTask.this.pageLength, FetchTask.this.dateRange.getStartTimeStamp(), FetchTask.this.dateRange.getFinishTimeStamp());
            }

            @Override
            protected void done() {
                try {
                    FetchTask.this.results = (SecurityEventsSearchResults)this.get(FetchTask.this.timeout, TimeUnit.MILLISECONDS);
                    FetchTask.this.searchContext.getSearchStateForDateRange().put(FetchTask.this.dateRange, FetchTask.this.results.getSearchState());
                    if (!FetchTask.this.results.getContainer().getErrors().isEmpty()) {
                        FetchTask.this.searchContext.getSearchResults().addErrors(FetchTask.this.results.getContainer().getErrors());
                        logger.log(Level.SEVERE, FetchTask.this.results.getContainer().getErrors().toString());
                        this.firePropertyChange("PROP_FETCH_TASK_FAILED", null, FetchTask.this.results.getContainer().getErrors());
                        return;
                    }
                    logger.info(String.format("EVENTS: %d", FetchTask.this.results.getContainer().getSecurityEvents().size()));
                    if (FetchTask.this.results.getSearchState().getTotalHits() != -1L) {
                        FetchTask.this.searchContext.getSearchResults().addEvents(FetchTask.this.results.getContainer().getSecurityEvents());
                        FetchTask.this.searchContext.getSearchResults().addToTotalDuration(FetchTask.this.results.getSearchState().getLastSearchDuration());
                        this.firePropertyChange("PROP_FETCH_TASK_FINISHED_SUCCESS", null, FetchTask.this.dateRange);
                    }
                    FetchTask.this.searchContext.getTaskMonitor().completeTask(TaskMonitor.BaseTaskName.FETCH, FetchTask.this.dateRange.getStartTimeStamp(), FetchTask.this.dateRange.getFinishTimeStamp());
                    this.firePropertyChange("PROP_GOT_FETCH_RESULTS", null, FetchTask.this.results);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    this.firePropertyChange("PROP_FETCH_TASK_FINISHED", null, FetchTask.this.dateRange);
                }
            }
        };
    }

    @Override
    public SecurityEventsSearchResults getResult() {
        return this.results;
    }
}

