/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.export.strategies;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.IndexDateRange;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEventsCountContainer;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptionsPanel;
import rs.co.ast.aspen.gui.module.securityevents.export.SkippedTaskDelays;
import rs.co.ast.aspen.gui.module.securityevents.export.TaskMonitor;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.CountSkippedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.CountSkippedSupport;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.CountTasksCompletedSupport;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.FileCreatedSupport;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.FileSkippedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.FileSkippedSupport;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.ProgressValueChangedEvent;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.ProgressValueChangedListener;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.ProgressValueChangedSupport;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.WorkFinishedSupport;
import rs.co.ast.aspen.gui.module.securityevents.search.CountPage;

public abstract class ExportStrategy {
    private static final String DEFAULT_SEARCH = "*";
    public static final int MAX_PAGE_SIZE = 10000;
    protected ExecutorService executor = Executors.newSingleThreadExecutor();
    private ScheduledExecutorService skippedTasksScheduler = Executors.newSingleThreadScheduledExecutor();
    protected static final Logger logger = Logger.getLogger(ExportStrategy.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    protected WorkFinishedSupport workFinishedSupport = new WorkFinishedSupport();
    private CountSkippedSupport countSkippedSupport = new CountSkippedSupport();
    protected FileCreatedSupport fileCreatedSupport = new FileCreatedSupport();
    protected ProgressValueChangedSupport progressValueChangedSupport = new ProgressValueChangedSupport();
    protected FileSkippedSupport fileSkippedSupport = new FileSkippedSupport();
    private CountTasksCompletedSupport countTasksCompletedSupport = new CountTasksCompletedSupport();
    protected ProgressValueChangedListener progressValueChangedListener;
    protected String query;
    protected String exportPath;
    protected long startTime;
    protected long finishTime;
    protected String fileExtension;
    private long totalHits = 0L;
    private List<DateRange> dateRanges;
    private CountPage page;
    private Map<String, SearchState> searchStateForDateRange = new HashMap<String, SearchState>();
    private SkippedTaskDelays skippedFileDelays = new SkippedTaskDelays();
    protected TaskMonitor taskMonitor = new TaskMonitor(this.workFinishedSupport, this.countTasksCompletedSupport);
    private int totalFilesCount = 0;
    protected AtomicInteger fileCount = new AtomicInteger(0);

    public ExportStrategy(String query, String exportPath, long startTime, long finishTime, long indexSplit, String fileExtension) throws ApiServiceException_Exception {
        this.query = this.ifQueryIsEmptySetToDefault(query);
        this.exportPath = exportPath;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.fileExtension = fileExtension;
        this.progressValueChangedListener = new ProgressValueChangedListener(){

            @Override
            public void progressChanged(ProgressValueChangedEvent event) {
                ExportStrategy.this.progressValueChangedSupport.fireProgressValueChangedEvent(event.getProgress(), event.getPosition(), event.getTotalHits(), event.getElapsed());
            }
        };
        this.getDateRanges(startTime, finishTime, indexSplit);
        this.initPageWithDateRanges();
        try {
            this.allCounts();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public abstract SwingWorker<byte[], Void> search(String var1, SearchState var2, DateRange var3);

    private void allCounts() throws Exception {
        DateRange dateRange;
        while (this.page.hasNext() && (dateRange = this.page.next()) != null) {
            SwingWorker<SecurityEventsCountContainer, Void> worker = this.countTask(dateRange);
            this.executor.submit(worker);
        }
    }

    private SwingWorker<SecurityEventsCountContainer, Void> countTask(final DateRange dateRange) {
        return new SwingWorker<SecurityEventsCountContainer, Void>(){

            @Override
            protected SecurityEventsCountContainer doInBackground() throws Exception {
                ExportStrategy.this.taskMonitor.addCount(dateRange);
                return ExportStrategy.this.count(dateRange);
            }

            @Override
            protected void done() {
                try {
                    SecurityEventsCountContainer result = (SecurityEventsCountContainer)this.get();
                    if (result.getSearchState().getTotalHits() <= -1L) {
                        ExportStrategy.this.countSkippedSupport.fireCountSkippedEvent(dateRange);
                    } else {
                        String dateRangeToString = ExportStrategy.this.dateRangeToString(dateRange);
                        ExportStrategy.this.searchStateForDateRange.put(dateRangeToString, result.getSearchState());
                        ExportStrategy.this.totalHits = ExportStrategy.this.totalHits + result.getSearchState().getTotalHits();
                        ExportStrategy.this.taskMonitor.completeCount(dateRange);
                        logger.info(String.format("COUNT - s: %s - f: %s, %d/%d", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()), result.getSearchState().getTotalHits(), ExportStrategy.this.totalHits));
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
    }

    public void calcTotalFilesCount() {
        Long nTotalHits = this.totalHits;
        this.totalFilesCount = ((Number)nTotalHits).intValue() / 10000;
        if ((float)this.totalFilesCount < ((Number)nTotalHits).floatValue() / 10000.0f) {
            ++this.totalFilesCount;
        }
    }

    public int getTotalFilesCount() {
        return this.totalFilesCount;
    }

    public int countFilesDone() {
        return this.taskMonitor.countFilesDone();
    }

    public final void export() {
        if (this.totalHits > 0L) {
            this.calcTotalFilesCount();
            for (DateRange dateRange : this.dateRanges) {
                String dateRangeToString = this.dateRangeToString(dateRange);
                SearchState searchState = this.searchStateForDateRange.get(dateRangeToString);
                if (searchState == null) continue;
                long totalHitsForDateRange = searchState.getTotalHits();
                for (long offset = 0L; offset <= totalHitsForDateRange; offset += 10000L) {
                    String fileName = this.genFileName(dateRange);
                    this.taskMonitor.addFetch(fileName);
                    offset = offset > totalHitsForDateRange ? totalHitsForDateRange - (offset - 10000L) : offset;
                    SearchState ss = new SearchState();
                    ss.setOffset(offset);
                    ss.setTotalHits(Long.valueOf(totalHitsForDateRange));
                    ss.setLastSearchDuration(searchState.getLastSearchDuration());
                    this.executor.submit(this.search(fileName, ss, dateRange));
                }
            }
        } else {
            this.workFinishedSupport.fireWorkFinishedEvent(false, NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.error.zero_totalhits.message"));
        }
    }

    public void submitSkippedCount(final CountSkippedEvent event) {
        String dateRangeToString = this.taskMonitor.dateRangeToString(event.getDateRange());
        if (!this.skippedFileDelays.isSkipCountLimitExceeded(dateRangeToString)) {
            this.taskMonitor.addSkippedCount(event.getDateRange());
            long delay = this.skippedFileDelays.getDelayForSkippedTask(dateRangeToString);
            this.skippedTasksScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    ExportStrategy.this.executor.submit(ExportStrategy.this.countTask(event.getDateRange()));
                }
            }, delay, TimeUnit.MILLISECONDS);
            this.skippedFileDelays.putDelayForSkippedTask(dateRangeToString, delay *= 2L);
        } else {
            this.countTasksCompletedSupport.fireCountTasksCompletedEvent(false);
        }
    }

    public void submitSkippedFetch(final FileSkippedEvent event) {
        if (!this.skippedFileDelays.isSkipCountLimitExceeded(event.getFileName())) {
            this.taskMonitor.addSkippedFetch(event.getFileName());
            long delay = this.skippedFileDelays.getDelayForSkippedTask(event.getFileName());
            this.skippedTasksScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    SearchState ss = new SearchState();
                    ss.setOffset(event.getSearchState().getOffset());
                    ss.setTotalHits(event.getSearchState().getTotalHits());
                    ss.setLastSearchDuration(event.getSearchState().getLastSearchDuration());
                    event.setSearchState(ss);
                    ExportStrategy.this.executor.submit(ExportStrategy.this.search(event.getFileName(), event.getSearchState(), event.getDateRange()));
                }
            }, delay, TimeUnit.MILLISECONDS);
            this.skippedFileDelays.putDelayForSkippedTask(event.getFileName(), delay *= 2L);
        }
    }

    private String genFileName(DateRange dateRange) {
        DateTime startDate = new DateTime(dateRange.getStartTimeStamp());
        DateTime finishDate = new DateTime(dateRange.getFinishTimeStamp());
        DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
        String fileName = String.format(NbBundle.getMessage(DisplayOptions.class, (String)"ExportGenerator.export.filename"), startDate.toString(dtf), finishDate.toString(dtf), this.fileExtension);
        return this.generateFileNameWithNumbering(fileName);
    }

    private SecurityEventsCountContainer count(DateRange dateRange) throws Exception {
        return this.apiService.securityEventsCountSearch(this.query, new SearchState(), dateRange.getStartTimeStamp(), dateRange.getFinishTimeStamp());
    }

    protected SecurityEventsSearchResults fetch(SearchState searchState, DateRange dateRange) throws Exception {
        return this.apiService.fetchSecurityEventsAscWithOffset(this.query, searchState, 10000, dateRange.getStartTimeStamp(), dateRange.getFinishTimeStamp());
    }

    private void getDateRanges(long startTime, long finishTime, long indexSplit) throws ApiServiceException_Exception {
        List<IndexDateRange> indexDateIntervals = this.getDateIntervals(startTime, finishTime, indexSplit, true);
        if (this.dateRanges == null) {
            this.dateRanges = new ArrayList<DateRange>();
        }
        for (IndexDateRange idr : indexDateIntervals) {
            for (DateRange dr : idr.getDateRanges()) {
                this.dateRanges.add(dr);
            }
        }
    }

    private List<IndexDateRange> getDateIntervals(long startTime, long finishTime, long indexSplit, boolean sortAsc) throws ApiServiceException_Exception {
        return this.apiService.getCustomSecurityEventDateRangeByIndex(startTime, finishTime, indexSplit, sortAsc);
    }

    private void initPageWithDateRanges() {
        this.page = new CountPage(this.dateRanges);
    }

    private String ifQueryIsEmptySetToDefault(String query) {
        return query == null || query.isEmpty() ? DEFAULT_SEARCH : query;
    }

    private String dateRangeToString(DateRange dateRange) {
        return String.format("%s_%s", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()));
    }

    private String generateFileNameWithNumbering(String fileName) {
        File f = new File(this.exportPath, fileName);
        String[] split = f.getName().split("\\.");
        int numberOfDigits = this.numberOfDigits(this.getTotalFilesCount());
        String pattern = "%0" + numberOfDigits + "d";
        String filesDoneAsString = String.format(pattern, this.fileCount.incrementAndGet());
        fileName = split[0] + "_" + filesDoneAsString + "." + split[1];
        return fileName;
    }

    private int numberOfDigits(int number) {
        if (number == 0) {
            return 1;
        }
        return (int)Math.log10(Math.abs(number)) + 1;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public ExecutorService getTaskExecutor() {
        return this.executor;
    }

    public SkippedTaskDelays getSkippedFileDelays() {
        return this.skippedFileDelays;
    }

    public ScheduledExecutorService getSkippedTasksScheduler() {
        return this.skippedTasksScheduler;
    }

    public WorkFinishedSupport getWorkFinishedSupport() {
        return this.workFinishedSupport;
    }

    public FileCreatedSupport getFileCreatedSupport() {
        return this.fileCreatedSupport;
    }

    public ProgressValueChangedSupport getProgressValueChangedSupport() {
        return this.progressValueChangedSupport;
    }

    public FileSkippedSupport getFileSkippedSupport() {
        return this.fileSkippedSupport;
    }

    public CountSkippedSupport getCountSkippedSupport() {
        return this.countSkippedSupport;
    }

    public CountTasksCompletedSupport getCountTasksCompletedSupport() {
        return this.countTasksCompletedSupport;
    }
}

