/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.StatefulResolver;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.WovenClassImpl;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.ResourceNotFoundException;
import org.apache.felix.framework.util.CompoundEnumeration;
import org.apache.felix.framework.util.ImmutableList;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWiringImpl
implements BundleWiring {
    public static final int LISTRESOURCES_DEBUG = 0x100000;
    public static final int EAGER_ACTIVATION = 0;
    public static final int LAZY_ACTIVATION = 1;
    private final Logger m_logger;
    private final Map m_configMap;
    private final StatefulResolver m_resolver;
    private final BundleRevisionImpl m_revision;
    private final List<BundleRevision> m_fragments;
    private volatile List<BundleWire> m_wires;
    private volatile Map<String, BundleRevision> m_importedPkgs;
    private final Map<String, List<BundleRevision>> m_requiredPkgs;
    private final List<BundleCapability> m_resolvedCaps;
    private final Map<String, List<List<String>>> m_includedPkgFilters;
    private final Map<String, List<List<String>>> m_excludedPkgFilters;
    private final List<BundleRequirement> m_resolvedReqs;
    private final List<R4Library> m_resolvedNativeLibs;
    private final List<Content> m_fragmentContents;
    private volatile List<BundleRequirement> m_wovenReqs = null;
    private BundleClassLoader m_classLoader;
    private final ClassLoader m_bootClassLoader;
    private static final ClassLoader m_defBootClassLoader;
    private final boolean m_implicitBootDelegation;
    private final boolean m_useLocalURLs;
    private static SecurityManagerEx m_sm;
    private final ThreadLocal m_cycleCheck = new ThreadLocal();
    private static final ThreadLocal m_deferredActivation;
    private static volatile boolean m_isPreJava5;
    private volatile boolean m_isDisposed = false;
    private final ThreadLocal m_listResourcesCycleCheck = new ThreadLocal();
    private static final Constructor m_dexFileClassConstructor;
    private static final Method m_dexFileClassLoadDex;
    private static final Method m_dexFileClassLoadClass;

    BundleWiringImpl(Logger logger, Map configMap, StatefulResolver resolver, BundleRevisionImpl revision, List<BundleRevision> fragments, List<BundleWire> wires, Map<String, BundleRevision> importedPkgs, Map<String, List<BundleRevision>> requiredPkgs) throws Exception {
        Object l;
        Object map;
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_resolver = resolver;
        this.m_revision = revision;
        this.m_importedPkgs = importedPkgs;
        this.m_requiredPkgs = requiredPkgs;
        this.m_wires = ImmutableList.newInstance(wires);
        ArrayList<Content> fragmentContents = null;
        if (fragments != null) {
            if (fragments.size() > 1) {
                TreeMap<String, BundleRevision> sorted = new TreeMap<String, BundleRevision>();
                for (BundleRevision f : fragments) {
                    sorted.put(((BundleRevisionImpl)f).getId(), f);
                }
                fragments = new ArrayList(sorted.values());
            }
            fragmentContents = new ArrayList<Content>(fragments.size());
            for (int i = 0; fragments != null && i < fragments.size(); ++i) {
                fragmentContents.add(((BundleRevisionImpl)fragments.get(i)).getContent().getEntryAsContent("."));
            }
        }
        this.m_fragments = fragments;
        this.m_fragmentContents = fragmentContents;
        HashSet<String> imports = new HashSet<String>();
        ArrayList<BundleRequirement> reqList = new ArrayList<BundleRequirement>();
        for (BundleWire bw : wires) {
            if (bw.getRequirement().getNamespace().equals("osgi.wiring.host") && reqList.contains(bw.getRequirement())) continue;
            reqList.add(bw.getRequirement());
            if (!bw.getRequirement().getNamespace().equals("osgi.wiring.package")) continue;
            imports.add((String)bw.getCapability().getAttributes().get("osgi.wiring.package"));
        }
        for (BundleRequirement req : this.m_revision.getDeclaredRequirements(null)) {
            String resolution;
            if (!req.getNamespace().equals("osgi.wiring.package") || (resolution = req.getDirectives().get("resolution")) == null || !resolution.equals("dynamic")) continue;
            reqList.add(req);
        }
        if (this.m_fragments != null) {
            for (BundleRevision fragment : this.m_fragments) {
                for (BundleRequirement req : fragment.getDeclaredRequirements(null)) {
                    String resolution;
                    if (!req.getNamespace().equals("osgi.wiring.package") || (resolution = req.getDirectives().get("resolution")) == null || !resolution.equals("dynamic")) continue;
                    reqList.add(req);
                }
            }
        }
        this.m_resolvedReqs = ImmutableList.newInstance(reqList);
        boolean isFragment = Util.isFragment(revision);
        List capList = isFragment ? Collections.EMPTY_LIST : new ArrayList();
        HashMap<String, List<List<String>>> includedPkgFilters = new HashMap<String, List<List<String>>>();
        HashMap<String, List<List<String>>> excludedPkgFilters = new HashMap<String, List<List<String>>>();
        if (!isFragment) {
            for (BundleCapability cap : this.m_revision.getDeclaredCapabilities(null)) {
                String effective;
                if (cap.getNamespace().equals("osgi.wiring.package") && (!cap.getNamespace().equals("osgi.wiring.package") || imports.contains(cap.getAttributes().get("osgi.wiring.package").toString())) || (effective = cap.getDirectives().get("effective")) != null && !effective.equals("resolve")) continue;
                capList.add(cap);
                if (!cap.getNamespace().equals("osgi.wiring.package")) continue;
                List<List<String>> filters = BundleWiringImpl.parsePkgFilters(cap, "include");
                if (filters != null) {
                    includedPkgFilters.put((String)cap.getAttributes().get("osgi.wiring.package"), filters);
                }
                if ((filters = BundleWiringImpl.parsePkgFilters(cap, "exclude")) == null) continue;
                excludedPkgFilters.put((String)cap.getAttributes().get("osgi.wiring.package"), filters);
            }
            if (this.m_fragments != null) {
                for (BundleRevision fragment : this.m_fragments) {
                    for (BundleCapability cap : fragment.getDeclaredCapabilities(null)) {
                        String effective;
                        if (cap.getNamespace().equals("osgi.wiring.package") && (!cap.getNamespace().equals("osgi.wiring.package") || imports.contains(cap.getAttributes().get("osgi.wiring.package").toString())) || (effective = cap.getDirectives().get("effective")) != null && !effective.equals("resolve")) continue;
                        capList.add(cap);
                        if (!cap.getNamespace().equals("osgi.wiring.package")) continue;
                        List<List<String>> filters = BundleWiringImpl.parsePkgFilters(cap, "include");
                        if (filters != null) {
                            includedPkgFilters.put((String)cap.getAttributes().get("osgi.wiring.package"), filters);
                        }
                        if ((filters = BundleWiringImpl.parsePkgFilters(cap, "exclude")) == null) continue;
                        excludedPkgFilters.put((String)cap.getAttributes().get("osgi.wiring.package"), filters);
                    }
                }
            }
        }
        if (System.getSecurityManager() != null) {
            Iterator iter = capList.iterator();
            while (iter.hasNext()) {
                BundleCapability cap;
                cap = (BundleCapability)iter.next();
                if (cap.getNamespace().equals("osgi.wiring.package")) {
                    if (((BundleProtectionDomain)((BundleRevisionImpl)cap.getRevision()).getProtectionDomain()).impliesDirect(new PackagePermission((String)cap.getAttributes().get("osgi.wiring.package"), "exportonly"))) continue;
                    iter.remove();
                    continue;
                }
                if (cap.getNamespace().equals("osgi.wiring.host") || cap.getNamespace().equals("osgi.wiring.bundle") || cap.getNamespace().equals("osgi.ee") || ((BundleProtectionDomain)((BundleRevisionImpl)cap.getRevision()).getProtectionDomain()).impliesDirect(new CapabilityPermission(cap.getNamespace(), "provide"))) continue;
                iter.remove();
            }
        }
        this.m_resolvedCaps = ImmutableList.newInstance(capList);
        this.m_includedPkgFilters = includedPkgFilters.isEmpty() ? Collections.EMPTY_MAP : includedPkgFilters;
        this.m_excludedPkgFilters = excludedPkgFilters.isEmpty() ? Collections.EMPTY_MAP : excludedPkgFilters;
        ArrayList<R4Library> libList = this.m_revision.getDeclaredNativeLibraries() == null ? new ArrayList<R4Library>() : new ArrayList<R4Library>(this.m_revision.getDeclaredNativeLibraries());
        for (int fragIdx = 0; this.m_fragments != null && fragIdx < this.m_fragments.size(); ++fragIdx) {
            List<R4Library> libs = ((BundleRevisionImpl)this.m_fragments.get(fragIdx)).getDeclaredNativeLibraries();
            for (int reqIdx = 0; libs != null && reqIdx < libs.size(); ++reqIdx) {
                libList.add(libs.get(reqIdx));
            }
        }
        this.m_resolvedNativeLibs = libList.isEmpty() ? null : ImmutableList.newInstance(libList);
        ClassLoader bootLoader = m_defBootClassLoader;
        if (revision.getBundle().getBundleId() != 0L && (map = this.m_configMap.get("felix.bootdelegation.classloaders")) instanceof Map && (l = ((Map)map).get(this.m_revision.getBundle())) instanceof ClassLoader) {
            bootLoader = (ClassLoader)l;
        }
        this.m_bootClassLoader = bootLoader;
        this.m_implicitBootDelegation = this.m_configMap.get("felix.bootdelegation.implicit") == null || Boolean.valueOf((String)this.m_configMap.get("felix.bootdelegation.implicit")) != false;
        this.m_useLocalURLs = this.m_configMap.get("felix.jarurls") != null;
    }

    private static List<List<String>> parsePkgFilters(BundleCapability cap, String filtername) {
        ArrayList<List<String>> filters = null;
        String include = cap.getDirectives().get(filtername);
        if (include != null) {
            List<String> filterStrings = ManifestParser.parseDelimitedString(include, ",");
            filters = new ArrayList<List<String>>(filterStrings.size());
            for (int filterIdx = 0; filterIdx < filterStrings.size(); ++filterIdx) {
                List<String> substrings = SimpleFilter.parseSubstring(filterStrings.get(filterIdx));
                filters.add(substrings);
            }
        }
        return filters;
    }

    public String toString() {
        return this.m_revision.getBundle().toString();
    }

    public synchronized void dispose() {
        if (this.m_fragmentContents != null) {
            for (Content content : this.m_fragmentContents) {
                content.close();
            }
        }
        this.m_classLoader = null;
        this.m_isDisposed = true;
    }

    public boolean hasPackageSource(String pkgName) {
        return this.m_importedPkgs.containsKey(pkgName) || this.m_requiredPkgs.containsKey(pkgName);
    }

    public BundleRevision getImportedPackageSource(String pkgName) {
        return this.m_importedPkgs.get(pkgName);
    }

    List<Content> getFragmentContents() {
        return this.m_fragmentContents;
    }

    @Override
    public boolean isCurrent() {
        BundleRevision current = this.getBundle().adapt(BundleRevision.class);
        return current != null && current.getWiring() == this;
    }

    @Override
    public synchronized boolean isInUse() {
        return !this.m_isDisposed;
    }

    @Override
    public List<Capability> getResourceCapabilities(String namespace) {
        return BundleRevisionImpl.asCapabilityList(this.getCapabilities(namespace));
    }

    @Override
    public List<BundleCapability> getCapabilities(String namespace) {
        if (this.isInUse()) {
            List<BundleCapability> result = this.m_resolvedCaps;
            if (namespace != null) {
                result = new ArrayList<BundleCapability>();
                for (BundleCapability cap : this.m_resolvedCaps) {
                    if (!cap.getNamespace().equals(namespace)) continue;
                    result.add(cap);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public List<Requirement> getResourceRequirements(String namespace) {
        return BundleRevisionImpl.asRequirementList(this.getRequirements(namespace));
    }

    @Override
    public List<BundleRequirement> getRequirements(String namespace) {
        if (this.isInUse()) {
            List<BundleRequirement> searchReqs = this.m_resolvedReqs;
            List<BundleRequirement> wovenReqs = this.m_wovenReqs;
            List<BundleRequirement> result = this.m_resolvedReqs;
            if (wovenReqs != null) {
                searchReqs = new ArrayList<BundleRequirement>(this.m_resolvedReqs);
                searchReqs.addAll(wovenReqs);
                result = searchReqs;
            }
            if (namespace != null) {
                result = new ArrayList<BundleRequirement>();
                for (BundleRequirement req : searchReqs) {
                    if (!req.getNamespace().equals(namespace)) continue;
                    result.add(req);
                }
            }
            return result;
        }
        return null;
    }

    public List<R4Library> getNativeLibraries() {
        return this.m_resolvedNativeLibs;
    }

    private static List<Wire> asWireList(List wires) {
        return wires;
    }

    @Override
    public List<Wire> getProvidedResourceWires(String namespace) {
        return BundleWiringImpl.asWireList(this.getProvidedWires(namespace));
    }

    @Override
    public List<BundleWire> getProvidedWires(String namespace) {
        if (this.isInUse()) {
            return ((BundleImpl)this.m_revision.getBundle()).getFramework().getDependencies().getProvidedWires(this.m_revision, namespace);
        }
        return null;
    }

    @Override
    public List<Wire> getRequiredResourceWires(String namespace) {
        return BundleWiringImpl.asWireList(this.getRequiredWires(namespace));
    }

    @Override
    public List<BundleWire> getRequiredWires(String namespace) {
        if (this.isInUse()) {
            List<BundleWire> result = this.m_wires;
            if (namespace != null) {
                result = new ArrayList<BundleWire>();
                for (BundleWire bw : this.m_wires) {
                    if (!bw.getRequirement().getNamespace().equals(namespace)) continue;
                    result.add(bw);
                }
            }
            return result;
        }
        return null;
    }

    public synchronized void addDynamicWire(BundleWire wire) {
        ArrayList<BundleWire> wires = new ArrayList<BundleWire>(this.m_wires);
        wires.add(wire);
        HashMap<String, BundleRevision> importedPkgs = new HashMap<String, BundleRevision>(this.m_importedPkgs);
        importedPkgs.put((String)wire.getCapability().getAttributes().get("osgi.wiring.package"), wire.getProviderWiring().getRevision());
        this.m_wires = ImmutableList.newInstance(wires);
        this.m_importedPkgs = importedPkgs;
    }

    @Override
    public BundleRevision getResource() {
        return null;
    }

    @Override
    public BundleRevision getRevision() {
        return this.m_revision;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.m_isDisposed) {
            return null;
        }
        return this.getClassLoaderInternal();
    }

    private synchronized ClassLoader getClassLoaderInternal() {
        if (!this.m_isDisposed && this.m_classLoader == null) {
            Class<BundleClassLoader> clazz;
            if (m_isPreJava5) {
                clazz = BundleClassLoader.class;
            } else {
                try {
                    clazz = BundleClassLoaderJava5.class;
                }
                catch (Throwable th) {
                    m_isPreJava5 = true;
                    clazz = BundleClassLoader.class;
                }
            }
            try {
                Constructor ctor = BundleRevisionImpl.getSecureAction().getConstructor(clazz, new Class[]{BundleWiringImpl.class, ClassLoader.class});
                this.m_classLoader = (BundleClassLoader)BundleRevisionImpl.getSecureAction().invoke(ctor, new Object[]{this, this.determineParentClassLoader()});
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create module class loader: " + ex.getMessage() + " [" + ex.getClass().getName() + "]");
            }
        }
        return this.m_classLoader;
    }

    @Override
    public List<URL> findEntries(String path, String filePattern, int options) {
        if (this.isInUse()) {
            if (!Util.isFragment(this.m_revision)) {
                Enumeration e = ((BundleImpl)this.m_revision.getBundle()).getFramework().findBundleEntries(this.m_revision, path, filePattern, (options & 1) > 0);
                ArrayList entries = new ArrayList();
                while (e != null && e.hasMoreElements()) {
                    entries.add(e.nextElement());
                }
                return ImmutableList.newInstance(entries);
            }
            return Collections.EMPTY_LIST;
        }
        return null;
    }

    @Override
    public synchronized Collection<String> listResources(String path, String filePattern, int options) {
        List<String> pattern;
        Collection<ResourceSource> sources;
        TreeSet<String> resources = null;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if ((sources = this.listResourcesInternal(path, pattern = SimpleFilter.parseSubstring(filePattern = filePattern == null ? "*" : filePattern), options)) != null) {
            boolean debug = (options & 0x100000) > 0;
            resources = new TreeSet<String>();
            for (ResourceSource source : sources) {
                if (debug) {
                    resources.add(source.toString());
                    continue;
                }
                resources.add(source.m_resource);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ResourceSource> listResourcesInternal(String path, List<String> pattern, int options) {
        if (this.isInUse()) {
            boolean recurse = (options & 1) > 0;
            boolean localOnly = (options & 2) > 0;
            HashSet<String> cycles = (HashSet<String>)this.m_listResourcesCycleCheck.get();
            if (cycles == null) {
                cycles = new HashSet<String>();
                this.m_listResourcesCycleCheck.set(cycles);
            }
            if (cycles.contains(path)) {
                return Collections.EMPTY_LIST;
            }
            cycles.add(path);
            try {
                TreeSet<ResourceSource> treeSet;
                TreeSet<ResourceSource> remoteResources = new TreeSet<ResourceSource>();
                HashSet<String> noMerging = new HashSet<String>();
                for (BundleWire bw : this.m_wires) {
                    if (bw.getCapability().getNamespace().equals("osgi.wiring.package")) {
                        remoteResources.addAll(this.calculateRemotePackageResources(bw, bw.getCapability(), recurse, path, pattern, noMerging));
                        continue;
                    }
                    if (!bw.getCapability().getNamespace().equals("osgi.wiring.bundle")) continue;
                    List<BundleCapability> exports = bw.getProviderWiring().getRevision().getDeclaredCapabilities("osgi.wiring.package");
                    for (BundleCapability export : exports) {
                        remoteResources.addAll(this.calculateRemotePackageResources(bw, export, recurse, path, pattern, null));
                    }
                    List<BundleWire> requiredBundles = bw.getProviderWiring().getRequiredWires("osgi.wiring.bundle");
                    for (BundleWire rbWire : requiredBundles) {
                        String visibility = rbWire.getRequirement().getDirectives().get("visibility");
                        if (visibility == null || !visibility.equals("reexport")) continue;
                        List<BundleCapability> reexports = rbWire.getProviderWiring().getRevision().getDeclaredCapabilities("osgi.wiring.package");
                        for (BundleCapability reexport : reexports) {
                            remoteResources.addAll(this.calculateRemotePackageResources(bw, reexport, recurse, path, pattern, null));
                        }
                    }
                }
                TreeSet<ResourceSource> localResources = new TreeSet<ResourceSource>();
                List<Content> contentPath = this.m_revision.getContentPath();
                for (Content content : contentPath) {
                    Enumeration<String> e = content.getEntries();
                    if (e == null) continue;
                    while (e.hasMoreElements()) {
                        String resource = e.nextElement();
                        String resourcePath = BundleWiringImpl.getTrailingPath(resource);
                        if (noMerging.contains(resourcePath) || (recurse || !resourcePath.equals(path)) && (!recurse || !resourcePath.startsWith(path)) || !BundleWiringImpl.matchesPattern(pattern, BundleWiringImpl.getPathHead(resource))) continue;
                        localResources.add(new ResourceSource(resource, this.m_revision));
                    }
                }
                if (localOnly) {
                    treeSet = localResources;
                    return treeSet;
                }
                remoteResources.addAll(localResources);
                treeSet = remoteResources;
                return treeSet;
            }
            finally {
                cycles.remove(path);
                if (cycles.isEmpty()) {
                    this.m_listResourcesCycleCheck.set(null);
                }
            }
        }
        return null;
    }

    private Collection<ResourceSource> calculateRemotePackageResources(BundleWire bw, BundleCapability cap, boolean recurse, String path, List<String> pattern, Set<String> noMerging) {
        Collection<Object> resources = Collections.EMPTY_SET;
        String subpath = (String)cap.getAttributes().get("osgi.wiring.package");
        subpath = subpath.replace('.', '/') + '/';
        if (noMerging != null) {
            noMerging.add(subpath);
        }
        if (!recurse && subpath.equals(path) || recurse && subpath.startsWith(path)) {
            resources = ((BundleWiringImpl)bw.getProviderWiring()).listResourcesInternal(subpath, pattern, 0);
            Iterator<Object> it = resources.iterator();
            while (it.hasNext()) {
                ResourceSource reqResource = (ResourceSource)it.next();
                if (reqResource.m_resource.charAt(reqResource.m_resource.length() - 1) != '/') continue;
                it.remove();
            }
        } else if (!recurse && subpath.startsWith(path)) {
            int idx = subpath.indexOf(47, path.length());
            if (idx >= 0) {
                subpath = subpath.substring(0, idx + 1);
            }
            if (BundleWiringImpl.matchesPattern(pattern, BundleWiringImpl.getPathHead(subpath))) {
                resources = Collections.singleton(new ResourceSource(subpath, bw.getProviderWiring().getRevision()));
            }
        }
        return resources;
    }

    private static String getPathHead(String resource) {
        int idx;
        if (resource.length() == 0) {
            return resource;
        }
        int n = idx = resource.charAt(resource.length() - 1) == '/' ? resource.lastIndexOf(47, resource.length() - 2) : resource.lastIndexOf(47);
        if (idx < 0) {
            return resource;
        }
        return resource.substring(idx + 1);
    }

    private static String getTrailingPath(String resource) {
        int idx;
        if (resource.length() == 0) {
            return null;
        }
        int n = idx = resource.charAt(resource.length() - 1) == '/' ? resource.lastIndexOf(47, resource.length() - 2) : resource.lastIndexOf(47);
        if (idx < 0) {
            return "";
        }
        return resource.substring(0, idx + 1);
    }

    private static boolean matchesPattern(List<String> pattern, String resource) {
        if (resource.charAt(resource.length() - 1) == '/') {
            resource = resource.substring(0, resource.length() - 1);
        }
        return SimpleFilter.compareSubstring(pattern, resource);
    }

    @Override
    public Bundle getBundle() {
        return this.m_revision.getBundle();
    }

    private URL createURL(int port, String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            return BundleRevisionImpl.getSecureAction().createURL(null, "bundle://" + this.m_revision.getId() + ":" + port + path, ((BundleImpl)this.getBundle()).getFramework().getBundleStreamHandler());
        }
        catch (MalformedURLException ex) {
            this.m_logger.log(this.m_revision.getBundle(), 1, "Unable to create resource URL.", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResourcesByDelegation(String name) {
        HashSet<String> requestSet = (HashSet<String>)this.m_cycleCheck.get();
        if (requestSet == null) {
            requestSet = new HashSet<String>();
            this.m_cycleCheck.set(requestSet);
        }
        if (!requestSet.contains(name)) {
            requestSet.add(name);
            try {
                Enumeration enumeration = this.findResourcesByDelegation(name);
                return enumeration;
            }
            finally {
                requestSet.remove(name);
            }
        }
        return null;
    }

    private Enumeration findResourcesByDelegation(String name) {
        BundleRevision provider;
        Enumeration urls = null;
        ArrayList<Enumeration> completeUrlList = new ArrayList<Enumeration>();
        String pkgName = Util.getResourcePackage(name);
        if (this.shouldBootDelegate(pkgName)) {
            try {
                ClassLoader bdcl = this.getBootDelegationClassLoader();
                urls = bdcl.getResources(name);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (pkgName.startsWith("java.")) {
                return urls;
            }
            completeUrlList.add(urls);
        }
        if ((provider = this.m_importedPkgs.get(pkgName)) != null) {
            urls = ((BundleWiringImpl)provider.getWiring()).getResourcesByDelegation(name);
            if (urls != null && urls.hasMoreElements()) {
                completeUrlList.add(urls);
            }
            return new CompoundEnumeration(completeUrlList.toArray(new Enumeration[completeUrlList.size()]));
        }
        List<BundleRevision> providers = this.m_requiredPkgs.get(pkgName);
        if (providers != null) {
            for (BundleRevision p : providers) {
                urls = ((BundleWiringImpl)p.getWiring()).getResourcesByDelegation(name);
                if (urls == null || !urls.hasMoreElements()) continue;
                completeUrlList.add(urls);
            }
        }
        if ((urls = this.m_revision.getResourcesLocal(name)) != null && urls.hasMoreElements()) {
            completeUrlList.add(urls);
        } else {
            try {
                provider = this.m_resolver.resolve(this.m_revision, pkgName);
            }
            catch (ResolveException ex) {
            }
            catch (BundleException ex) {
                // empty catch block
            }
            if (provider != null && (urls = ((BundleWiringImpl)provider.getWiring()).getResourcesByDelegation(name)) != null && urls.hasMoreElements()) {
                completeUrlList.add(urls);
            }
        }
        return new CompoundEnumeration(completeUrlList.toArray(new Enumeration[completeUrlList.size()]));
    }

    private ClassLoader determineParentClassLoader() {
        String cfg = (String)this.m_configMap.get("org.osgi.framework.bundle.parent");
        String string = cfg = cfg == null ? "boot" : cfg;
        ClassLoader parent = cfg.equalsIgnoreCase("app") ? BundleRevisionImpl.getSecureAction().getSystemClassLoader() : (cfg.equalsIgnoreCase("ext") ? BundleRevisionImpl.getSecureAction().getParentClassLoader(BundleRevisionImpl.getSecureAction().getSystemClassLoader()) : (cfg.equalsIgnoreCase("framework") ? BundleRevisionImpl.getSecureAction().getClassLoader(BundleRevisionImpl.class) : (this.m_bootClassLoader == null ? BundleRevisionImpl.getSecureAction().getSystemClassLoader() : null)));
        return parent;
    }

    boolean shouldBootDelegate(String pkgName) {
        if (this.m_bootClassLoader != m_defBootClassLoader) {
            return true;
        }
        boolean result = false;
        if (pkgName.length() > 0) {
            for (int i = 0; !result && i < ((BundleImpl)this.getBundle()).getFramework().getBootPackages().length; ++i) {
                if (((BundleImpl)this.getBundle()).getFramework().getBootPackageWildcards()[i] && pkgName.startsWith(((BundleImpl)this.getBundle()).getFramework().getBootPackages()[i])) {
                    return true;
                }
                if (!((BundleImpl)this.getBundle()).getFramework().getBootPackages()[i].equals(pkgName)) continue;
                return true;
            }
        }
        return result;
    }

    synchronized ClassLoader getBootDelegationClassLoader() {
        ClassLoader parent = this.m_classLoader == null ? this.determineParentClassLoader() : BundleRevisionImpl.getSecureAction().getParentClassLoader(this.m_classLoader);
        return parent == null ? this.m_bootClassLoader : parent;
    }

    public Class getClassByDelegation(String name) throws ClassNotFoundException {
        if (name != null && name.length() > 0 && name.charAt(0) == '[') {
            return Class.forName(name, false, this.getClassLoader());
        }
        if (this.isFiltered(name)) {
            throw new ClassNotFoundException(name);
        }
        ClassLoader cl = this.getClassLoaderInternal();
        if (cl == null) {
            throw new ClassNotFoundException("Unable to load class '" + name + "' because the bundle wiring for " + this.m_revision.getSymbolicName() + " is no longer valid.");
        }
        return cl.loadClass(name);
    }

    private boolean isFiltered(String name) {
        String pkgName = Util.getClassPackage(name);
        List<List<String>> includeFilters = this.m_includedPkgFilters.get(pkgName);
        List<List<String>> excludeFilters = this.m_excludedPkgFilters.get(pkgName);
        if (includeFilters == null && excludeFilters == null) {
            return false;
        }
        String className = Util.getClassName(name);
        boolean included = includeFilters == null;
        for (int i = 0; !included && includeFilters != null && i < includeFilters.size(); ++i) {
            included = SimpleFilter.compareSubstring(includeFilters.get(i), className);
        }
        boolean excluded = false;
        for (int i = 0; !excluded && excludeFilters != null && i < excludeFilters.size(); ++i) {
            excluded = SimpleFilter.compareSubstring(excludeFilters.get(i), className);
        }
        return !included || excluded;
    }

    public URL getResourceByDelegation(String name) {
        try {
            return (URL)this.findClassOrResourceByDelegation(name, false);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(this.m_revision.getBundle(), 4, ex.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object findClassOrResourceByDelegation(String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        Object result = null;
        HashSet<String> requestSet = (HashSet<String>)this.m_cycleCheck.get();
        if (requestSet == null) {
            requestSet = new HashSet<String>();
            this.m_cycleCheck.set(requestSet);
        }
        if (!requestSet.add(name)) return null;
        try {
            String pkgName;
            block14: {
                String string = pkgName = isClass ? Util.getClassPackage(name) : Util.getResourcePackage(name);
                if (this.shouldBootDelegate(pkgName)) {
                    try {
                        ClassLoader bdcl = this.getBootDelegationClassLoader();
                        Object object = result = isClass ? bdcl.loadClass(name) : bdcl.getResource(name);
                        if (pkgName.startsWith("java.") || result != null) {
                            Serializable serializable = result;
                            return serializable;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        if (!pkgName.startsWith("java.")) break block14;
                        throw ex;
                    }
                }
            }
            if ((result = this.searchImports(pkgName, name, isClass)) == null) {
                if (isClass) {
                    ClassLoader cl = this.getClassLoaderInternal();
                    if (cl == null) {
                        throw new ClassNotFoundException("Unable to load class '" + name + "' because the bundle wiring for " + this.m_revision.getSymbolicName() + " is no longer valid.");
                    }
                    result = ((BundleClassLoader)cl).findClass(name);
                } else {
                    result = this.m_revision.getResourceLocal(name);
                }
                if (result == null) {
                    result = this.searchDynamicImports(pkgName, name, isClass);
                }
            }
        }
        finally {
            requestSet.remove(name);
        }
        if (result != null) return result;
        if (!isClass) throw new ResourceNotFoundException(name + " not found by " + this.getBundle());
        throw new ClassNotFoundException(name + " not found by " + this.getBundle());
    }

    private Object searchImports(String pkgName, String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        BundleRevision provider = this.m_importedPkgs.get(pkgName);
        if (provider != null) {
            Serializable result;
            Serializable serializable = result = isClass ? ((BundleWiringImpl)provider.getWiring()).getClassByDelegation(name) : ((BundleWiringImpl)provider.getWiring()).getResourceByDelegation(name);
            if (result != null) {
                return result;
            }
            if (isClass) {
                throw new ClassNotFoundException(name);
            }
            throw new ResourceNotFoundException(name);
        }
        List<BundleRevision> providers = this.m_requiredPkgs.get(pkgName);
        if (providers != null) {
            for (BundleRevision p : providers) {
                try {
                    Serializable result = isClass ? ((BundleWiringImpl)p.getWiring()).getClassByDelegation(name) : ((BundleWiringImpl)p.getWiring()).getResourceByDelegation(name);
                    if (result == null) continue;
                    return result;
                }
                catch (ClassNotFoundException ex) {
                }
            }
        }
        return null;
    }

    private Object searchDynamicImports(String pkgName, final String name, final boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        BundleRevision provider = null;
        try {
            provider = this.m_resolver.resolve(this.m_revision, pkgName);
        }
        catch (ResolveException ex) {
        }
        catch (BundleException ex) {
            // empty catch block
        }
        if (provider != null) {
            return isClass ? ((BundleWiringImpl)provider.getWiring()).getClassByDelegation(name) : ((BundleWiringImpl)provider.getWiring()).getResourceByDelegation(name);
        }
        if (this.m_implicitBootDelegation) {
            final Class[] classes = m_sm.getClassContext();
            try {
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return BundleWiringImpl.this.doImplicitBootDelegation(classes, name, isClass);
                        }
                    });
                }
                return this.doImplicitBootDelegation(classes, name, isClass);
            }
            catch (PrivilegedActionException ex) {
                Exception cause = ex.getException();
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)cause;
                }
                throw (ResourceNotFoundException)cause;
            }
        }
        return null;
    }

    private Object doImplicitBootDelegation(Class[] classes, String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        for (int i = 1; !(i >= classes.length || Thread.class.equals((Object)classes[i]) || this.isClassLoadedFromBundleRevision(classes[i]) || BundleImpl.class.equals((Object)classes[i])); ++i) {
            if (!this.isClassExternal(classes[i])) continue;
            try {
                return isClass ? BundleRevisionImpl.getSecureAction().getClassLoader(this.getClass()).loadClass(name) : BundleRevisionImpl.getSecureAction().getClassLoader(this.getClass()).getResource(name);
            }
            catch (NoClassDefFoundError ex) {
                break;
            }
        }
        return null;
    }

    private boolean isClassLoadedFromBundleRevision(Class clazz) {
        if (BundleClassLoader.class.isInstance(BundleRevisionImpl.getSecureAction().getClassLoader(clazz))) {
            return true;
        }
        ClassLoader last = null;
        ClassLoader cl = BundleRevisionImpl.getSecureAction().getClassLoader(clazz);
        while (cl != null && last != cl) {
            last = cl;
            if (BundleClassLoader.class.isInstance(cl)) {
                return true;
            }
            cl = BundleRevisionImpl.getSecureAction().getClassLoader(cl.getClass());
        }
        return false;
    }

    private boolean isClassExternal(Class clazz) {
        if (clazz.getName().startsWith("org.apache.felix.framework.")) {
            return false;
        }
        if (clazz.getName().startsWith("org.osgi.framework.")) {
            return false;
        }
        if (ClassLoader.class.equals((Object)clazz)) {
            return false;
        }
        return !Class.class.equals((Object)clazz);
    }

    static URL convertToLocalUrl(URL url) {
        if (url.getProtocol().equals("bundle")) {
            try {
                url = ((URLHandlersBundleURLConnection)url.openConnection()).getLocalURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return url;
    }

    private static String diagnoseClassLoadError(StatefulResolver resolver, BundleRevision revision, String name) {
        String pkgName = Util.getClassPackage(name);
        if (pkgName.length() == 0) {
            return null;
        }
        String importer = revision.getBundle().toString();
        List<BundleWire> wires = revision.getWiring() == null ? null : revision.getWiring().getProvidedWires(null);
        for (int i = 0; wires != null && i < wires.size(); ++i) {
            if (!wires.get(i).getCapability().getNamespace().equals("osgi.wiring.package") || !wires.get(i).getCapability().getAttributes().get("osgi.wiring.package").equals(pkgName)) continue;
            String exporter = wires.get(i).getProviderWiring().getBundle().toString();
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is imported by bundle ");
            sb.append(importer);
            sb.append(" from bundle ");
            sb.append(exporter);
            sb.append(", but the exported package from bundle ");
            sb.append(exporter);
            sb.append(" does not contain the requested class '");
            sb.append(name);
            sb.append("'. Please verify that the class name is correct in the importing bundle ");
            sb.append(importer);
            sb.append(" and/or that the exported package is correctly bundled in ");
            sb.append(exporter);
            sb.append(". ***");
            return sb.toString();
        }
        List<BundleRequirement> reqs = revision.getWiring().getRequirements(null);
        if (resolver.isAllowedDynamicImport(revision, pkgName)) {
            Map dirs = Collections.EMPTY_MAP;
            Map<String, Object> attrs = Collections.singletonMap("osgi.wiring.package", pkgName);
            BundleRequirementImpl req = new BundleRequirementImpl(revision, "osgi.wiring.package", dirs, attrs);
            List<BundleCapability> exporters = resolver.findProviders(req, false);
            BundleRevision provider = null;
            try {
                provider = resolver.resolve(revision, pkgName);
            }
            catch (Exception ex) {
                provider = null;
            }
            String exporter = exporters.isEmpty() ? null : exporters.iterator().next().getRevision().getBundle().toString();
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found, but this is likely normal since package '");
            sb.append(pkgName);
            sb.append("' is dynamically imported by bundle ");
            sb.append(importer);
            sb.append(".");
            if (exporters.size() > 0 && provider == null) {
                sb.append(" However, bundle ");
                sb.append(exporter);
                sb.append(" does export this package with attributes that do not match.");
            }
            sb.append(" ***");
            return sb.toString();
        }
        Map dirs = Collections.EMPTY_MAP;
        Map<String, Object> attrs = Collections.singletonMap("osgi.wiring.package", pkgName);
        BundleRequirementImpl req = new BundleRequirementImpl(revision, "osgi.wiring.package", dirs, attrs);
        List<BundleCapability> exports = resolver.findProviders(req, false);
        if (exports.size() > 0) {
            boolean classpath = false;
            try {
                BundleRevisionImpl.getSecureAction().getClassLoader(BundleClassLoader.class).loadClass(name);
                classpath = true;
            }
            catch (NoClassDefFoundError err) {
            }
            catch (Exception ex) {
                // empty catch block
            }
            String exporter = exports.iterator().next().getRevision().getBundle().toString();
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found because bundle ");
            sb.append(importer);
            sb.append(" does not import '");
            sb.append(pkgName);
            sb.append("' even though bundle ");
            sb.append(exporter);
            sb.append(" does export it.");
            if (classpath) {
                sb.append(" Additionally, the class is also available from the system class loader. There are two fixes: 1) Add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(importer);
                sb.append("; imports are necessary for each class directly touched by bundle code or indirectly touched, such as super classes if their methods are used. ");
                sb.append("2) Add package '");
                sb.append(pkgName);
                sb.append("' to the '");
                sb.append("org.osgi.framework.bootdelegation");
                sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            } else {
                sb.append(" To resolve this issue, add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(importer);
                sb.append(".");
            }
            sb.append(" ***");
            return sb.toString();
        }
        try {
            BundleRevisionImpl.getSecureAction().getClassLoader(BundleClassLoader.class).loadClass(name);
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is not imported by bundle ");
            sb.append(importer);
            sb.append(", nor is there any bundle that exports package '");
            sb.append(pkgName);
            sb.append("'. However, the class '");
            sb.append(name);
            sb.append("' is available from the system class loader. There are two fixes: 1) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.system.packages.extra");
            sb.append("' property and modify bundle ");
            sb.append(importer);
            sb.append(" to import this package; this causes the system bundle to export class path packages. 2) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.bootdelegation");
            sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            sb.append(" ***");
            return sb.toString();
        }
        catch (Exception ex2) {
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found. Bundle ");
            sb.append(importer);
            sb.append(" does not import package '");
            sb.append(pkgName);
            sb.append("', nor is the package exported by any other bundle or available from the system class loader.");
            sb.append(" ***");
            return sb.toString();
        }
    }

    static {
        ClassLoader cl = null;
        try {
            Constructor ctor = BundleRevisionImpl.getSecureAction().getDeclaredConstructor(SecureClassLoader.class, new Class[]{ClassLoader.class});
            BundleRevisionImpl.getSecureAction().setAccesssible(ctor);
            cl = (ClassLoader)BundleRevisionImpl.getSecureAction().invoke(ctor, new Object[]{null});
        }
        catch (Throwable ex) {
            cl = null;
            System.err.println("Problem creating boot delegation class loader: " + ex);
        }
        m_defBootClassLoader = cl;
        m_sm = new SecurityManagerEx();
        m_deferredActivation = new ThreadLocal();
        m_isPreJava5 = false;
        Constructor<?> dexFileClassConstructor = null;
        Method dexFileClassLoadDex = null;
        Method dexFileClassLoadClass = null;
        try {
            Class<?> dexFileClass;
            try {
                dexFileClass = Class.forName("dalvik.system.DexFile");
            }
            catch (Exception ex) {
                dexFileClass = Class.forName("android.dalvik.DexFile");
            }
            try {
                dexFileClassLoadDex = dexFileClass.getMethod("loadDex", String.class, String.class, Integer.TYPE);
            }
            catch (Exception ex) {
                // empty catch block
            }
            dexFileClassConstructor = dexFileClass.getConstructor(File.class);
            dexFileClassLoadClass = dexFileClass.getMethod("loadClass", String.class, ClassLoader.class);
        }
        catch (Throwable ex) {
            dexFileClassConstructor = null;
            dexFileClassLoadDex = null;
            dexFileClassLoadClass = null;
        }
        m_dexFileClassConstructor = dexFileClassConstructor;
        m_dexFileClassLoadDex = dexFileClassLoadDex;
        m_dexFileClassLoadClass = dexFileClassLoadClass;
    }

    public static class BundleClassLoader
    extends SecureClassLoader
    implements BundleReference {
        private volatile boolean m_isActivationTriggered = false;
        private final Map m_jarContentToDexFile;
        private Object[][] m_cachedLibs = new Object[0][];
        private static final int LIBNAME_IDX = 0;
        private static final int LIBPATH_IDX = 1;
        private final Map<String, Thread> m_classLocks = new HashMap<String, Thread>();
        private BundleWiringImpl m_wiring;

        public BundleClassLoader(BundleWiringImpl wiring, ClassLoader parent) {
            super(parent);
            this.m_jarContentToDexFile = m_dexFileClassLoadClass != null ? new HashMap() : null;
            this.m_wiring = wiring;
        }

        public boolean isActivationTriggered() {
            return this.m_isActivationTriggered;
        }

        public Bundle getBundle() {
            return this.m_wiring.getBundle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class clazz;
            Map<String, Thread> map = this.m_classLocks;
            synchronized (map) {
                clazz = this.findLoadedClass(name);
            }
            if (clazz == null) {
                try {
                    clazz = (Class)this.m_wiring.findClassOrResourceByDelegation(name, true);
                }
                catch (ResourceNotFoundException ex) {
                }
                catch (ClassNotFoundException cnfe) {
                    ClassNotFoundException ex = cnfe;
                    if (this.m_wiring.m_logger.getLogLevel() >= 4) {
                        String msg = BundleWiringImpl.diagnoseClassLoadError(this.m_wiring.m_resolver, this.m_wiring.m_revision, name);
                        ex = msg != null ? new ClassNotFoundException(msg, cnfe) : ex;
                    }
                    throw ex;
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        protected Class findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (this.m_wiring.m_isDisposed) {
                throw new ClassNotFoundException("Unable to load class '" + name + "' because the bundle wiring for " + this.m_wiring.m_revision.getSymbolicName() + " is no longer valid.");
            }
            if (clazz == null) {
                String actual = name.replace('.', '/') + ".class";
                byte[] bytes = null;
                List<Content> contentPath = this.m_wiring.m_revision.getContentPath();
                Content content = null;
                for (int i = 0; bytes == null && i < contentPath.size(); ++i) {
                    bytes = contentPath.get(i).getEntryAsBytes(actual);
                    content = contentPath.get(i);
                }
                if (bytes != null) {
                    Map<String, Thread> activationPolicy2;
                    String pkgName = Util.getClassPackage(name);
                    Felix felix = ((BundleImpl)this.m_wiring.m_revision.getBundle()).getFramework();
                    Set<ServiceReference<WeavingHook>> hooks = felix.getHooks(WeavingHook.class);
                    WovenClassImpl wci = null;
                    if (!hooks.isEmpty()) {
                        wci = new WovenClassImpl(name, this.m_wiring, bytes);
                        for (ServiceReference serviceReference : hooks) {
                            WeavingHook wh;
                            if (felix.isHookBlackListed(serviceReference) || (wh = (WeavingHook)felix.getService(felix, serviceReference)) == null) continue;
                            try {
                                BundleRevisionImpl.getSecureAction().invokeWeavingHook(wh, wci);
                            }
                            catch (Throwable th) {
                                if (!(th instanceof WeavingException)) {
                                    felix.blackListHook(serviceReference);
                                }
                                felix.fireFrameworkEvent(2, serviceReference.getBundle(), th);
                                wci.complete(null, null, null);
                                ClassFormatError error = new ClassFormatError("Weaving hook failed.");
                                error.initCause(th);
                                throw error;
                            }
                            finally {
                                felix.ungetService(felix, serviceReference);
                            }
                        }
                    }
                    Map<String, Thread> i$ = this.m_classLocks;
                    synchronized (i$) {
                        Thread thread = Thread.currentThread();
                        while (this.m_classLocks.containsKey(name) && this.m_classLocks.get(name) != thread) {
                            try {
                                this.m_classLocks.wait();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        clazz = this.findLoadedClass(name);
                        if (clazz == null) {
                            this.m_classLocks.put(name, thread);
                        }
                    }
                    byte[] wovenBytes = null;
                    Class clazz2 = null;
                    List<String> wovenImports = null;
                    try {
                        if (clazz == null) {
                            boolean isTriggerClass;
                            if (wci != null) {
                                wovenBytes = wci._getBytes();
                                bytes = wovenBytes;
                                wovenImports = wci.getDynamicImportsInternal();
                                ArrayList<BundleRequirement> allWovenReqs = new ArrayList<BundleRequirement>();
                                for (String s : wovenImports) {
                                    try {
                                        List<BundleRequirement> wovenReqs = ManifestParser.parseDynamicImportHeader(this.m_wiring.m_logger, this.m_wiring.m_revision, s);
                                        allWovenReqs.addAll(wovenReqs);
                                    }
                                    catch (BundleException ex) {}
                                }
                                if (!allWovenReqs.isEmpty()) {
                                    HashSet<String> filters = new HashSet<String>();
                                    if (this.m_wiring.m_wovenReqs != null) {
                                        for (BundleRequirement req : this.m_wiring.m_wovenReqs) {
                                            filters.add(((BundleRequirementImpl)req).getFilter().toString());
                                        }
                                    }
                                    int idx = allWovenReqs.size();
                                    while (idx < allWovenReqs.size()) {
                                        BundleRequirement wovenReq = (BundleRequirement)allWovenReqs.get(idx);
                                        String filter = ((BundleRequirementImpl)wovenReq).getFilter().toString();
                                        if (!filters.contains(filter)) {
                                            filters.add(filter);
                                            ++idx;
                                            continue;
                                        }
                                        allWovenReqs.remove(idx);
                                    }
                                    if (!allWovenReqs.isEmpty()) {
                                        if (this.m_wiring.m_wovenReqs != null) {
                                            allWovenReqs.addAll(0, this.m_wiring.m_wovenReqs);
                                        }
                                        this.m_wiring.m_wovenReqs = allWovenReqs;
                                    }
                                }
                            }
                            int activationPolicy2 = ((BundleImpl)this.getBundle()).isDeclaredActivationPolicyUsed() ? ((BundleRevisionImpl)this.getBundle().adapt(BundleRevision.class)).getDeclaredActivationPolicy() : 0;
                            boolean bl = isTriggerClass = this.m_isActivationTriggered ? false : this.m_wiring.m_revision.isActivationTrigger(pkgName);
                            if (!this.m_isActivationTriggered && isTriggerClass && activationPolicy2 == 1 && this.getBundle().getState() == 8) {
                                ArrayList<Object[]> deferredList2 = (ArrayList<Object[]>)m_deferredActivation.get();
                                if (deferredList2 == null) {
                                    deferredList2 = new ArrayList<Object[]>();
                                    m_deferredActivation.set(deferredList2);
                                }
                                deferredList2.add(new Object[]{name, this.getBundle()});
                            }
                            if (pkgName.length() > 0 && this.getPackage(pkgName) == null) {
                                Object[] params = this.definePackage(pkgName);
                                try {
                                    this.definePackage(pkgName, (String)params[0], (String)params[1], (String)params[2], (String)params[3], (String)params[4], (String)params[5], null);
                                }
                                catch (IllegalArgumentException ex) {
                                    // empty catch block
                                }
                            }
                            if (content instanceof JarContent) {
                                try {
                                    clazz = this.getDexFileClass((JarContent)content, name, this);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            if (clazz == null) {
                                clazz = this.m_wiring.m_revision.getProtectionDomain() != null ? this.defineClass(name, bytes, 0, bytes.length, this.m_wiring.m_revision.getProtectionDomain()) : this.defineClass(name, bytes, 0, bytes.length);
                                Class<?> clazz3 = clazz;
                            }
                            if (!this.m_isActivationTriggered && isTriggerClass && clazz != null) {
                                this.m_isActivationTriggered = true;
                            }
                        }
                        if (wci != null) {
                            void var12_17;
                            wci.complete((Class)var12_17, wovenBytes, wovenImports);
                        }
                        activationPolicy2 = this.m_classLocks;
                    }
                    catch (Throwable throwable) {
                        if (wci != null) {
                            wci.complete(clazz2, wovenBytes, wovenImports);
                        }
                        Map<String, Thread> map = this.m_classLocks;
                        synchronized (map) {
                            this.m_classLocks.remove(name);
                            this.m_classLocks.notifyAll();
                        }
                        throw throwable;
                    }
                    synchronized (activationPolicy2) {
                        this.m_classLocks.remove(name);
                        this.m_classLocks.notifyAll();
                    }
                    List deferredList = (List)m_deferredActivation.get();
                    if (deferredList != null && deferredList.size() > 0 && ((Object[])deferredList.get(0))[0].equals(name)) {
                        m_deferredActivation.set(null);
                        while (!deferredList.isEmpty()) {
                            Object[] lazy = (Object[])deferredList.remove(deferredList.size() - 1);
                            try {
                                felix.getFramework().activateBundle((BundleImpl)lazy[1], true);
                            }
                            catch (Throwable ex) {
                                this.m_wiring.m_logger.log((BundleImpl)lazy[1], 2, "Unable to lazily start bundle.", ex);
                            }
                        }
                    }
                }
            }
            return clazz;
        }

        private Object[] definePackage(String pkgName) {
            String spectitle = (String)this.m_wiring.m_revision.getHeaders().get("Specification-Title");
            String specversion = (String)this.m_wiring.m_revision.getHeaders().get("Specification-Version");
            String specvendor = (String)this.m_wiring.m_revision.getHeaders().get("Specification-Vendor");
            String impltitle = (String)this.m_wiring.m_revision.getHeaders().get("Implementation-Title");
            String implversion = (String)this.m_wiring.m_revision.getHeaders().get("Implementation-Version");
            String implvendor = (String)this.m_wiring.m_revision.getHeaders().get("Implementation-Vendor");
            if (spectitle != null || specversion != null || specvendor != null || impltitle != null || implversion != null || implvendor != null) {
                return new Object[]{spectitle, specversion, specvendor, impltitle, implversion, implvendor};
            }
            return new Object[]{null, null, null, null, null, null};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class getDexFileClass(JarContent content, String name, ClassLoader loader) throws Exception {
            if (this.m_jarContentToDexFile == null) {
                return null;
            }
            Object dexFile = null;
            if (!this.m_jarContentToDexFile.containsKey(content)) {
                try {
                    if (m_dexFileClassLoadDex != null) {
                        dexFile = m_dexFileClassLoadDex.invoke(null, content.getFile().getAbsolutePath(), content.getFile().getAbsolutePath() + ".dex", new Integer(0));
                    }
                    dexFile = m_dexFileClassConstructor.newInstance(content.getFile());
                }
                finally {
                    this.m_jarContentToDexFile.put(content, dexFile);
                }
            } else {
                dexFile = this.m_jarContentToDexFile.get(content);
            }
            if (dexFile != null) {
                return (Class)m_dexFileClassLoadClass.invoke(dexFile, name.replace('.', '/'), loader);
            }
            return null;
        }

        public URL getResource(String name) {
            URL url = this.m_wiring.getResourceByDelegation(name);
            if (this.m_wiring.m_useLocalURLs) {
                url = BundleWiringImpl.convertToLocalUrl(url);
            }
            return url;
        }

        protected URL findResource(String name) {
            return this.m_wiring.m_revision.getResourceLocal(name);
        }

        protected Enumeration findResources(String name) {
            Enumeration urls = this.m_wiring.getResourcesByDelegation(name);
            if (this.m_wiring.m_useLocalURLs) {
                urls = new ToLocalUrlEnumeration(urls);
            }
            return urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String findLibrary(String name) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            String result = null;
            BundleClassLoader bundleClassLoader = this;
            synchronized (bundleClassLoader) {
                for (int i = 0; result == null && i < this.m_cachedLibs.length; ++i) {
                    if (!this.m_cachedLibs[i][0].equals(name)) continue;
                    result = (String)this.m_cachedLibs[i][1];
                }
                if (result == null) {
                    List<R4Library> libs = this.m_wiring.getNativeLibraries();
                    for (int libIdx = 0; libs != null && libIdx < libs.size(); ++libIdx) {
                        if (!libs.get(libIdx).match(this.m_wiring.m_configMap, name)) continue;
                        result = this.m_wiring.m_revision.getContent().getEntryAsNativeLibrary(libs.get(libIdx).getEntryName());
                        for (int i = 0; result == null && this.m_wiring.m_fragmentContents != null && i < this.m_wiring.m_fragmentContents.size(); ++i) {
                            result = ((Content)this.m_wiring.m_fragmentContents.get(i)).getEntryAsNativeLibrary(libs.get(libIdx).getEntryName());
                        }
                    }
                    if (result != null) {
                        Object[][] tmp = new Object[this.m_cachedLibs.length + 1][];
                        System.arraycopy(this.m_cachedLibs, 0, tmp, 0, this.m_cachedLibs.length);
                        tmp[this.m_cachedLibs.length] = new Object[]{name, result};
                        this.m_cachedLibs = tmp;
                    }
                }
            }
            return result;
        }

        public String toString() {
            return this.m_wiring.toString();
        }

        static {
            try {
                Method method = BundleRevisionImpl.getSecureAction().getDeclaredMethod(ClassLoader.class, "registerAsParallelCapable", null);
                BundleRevisionImpl.getSecureAction().setAccesssible(method);
                method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class BundleClassLoaderJava5
    extends BundleClassLoader {
        private BundleWiringImpl m_wiring;

        public BundleClassLoaderJava5(BundleWiringImpl wiring, ClassLoader parent) {
            super(wiring, parent);
            this.m_wiring = wiring;
        }

        public Enumeration getResources(String name) {
            Enumeration urls = this.m_wiring.getResourcesByDelegation(name);
            if (this.m_wiring.m_useLocalURLs) {
                urls = new ToLocalUrlEnumeration(urls);
            }
            return urls;
        }

        protected Enumeration findResources(String name) {
            return this.m_wiring.m_revision.getResourcesLocal(name);
        }

        static {
            try {
                Method method = BundleRevisionImpl.getSecureAction().getDeclaredMethod(ClassLoader.class, "registerAsParallelCapable", null);
                BundleRevisionImpl.getSecureAction().setAccesssible(method);
                method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceSource
    implements Comparable<ResourceSource> {
        public final String m_resource;
        public final BundleRevision m_revision;

        public ResourceSource(String resource, BundleRevision revision) {
            this.m_resource = resource;
            this.m_revision = revision;
        }

        public boolean equals(Object o) {
            if (o instanceof ResourceSource) {
                return this.m_resource.equals(((ResourceSource)o).m_resource);
            }
            return false;
        }

        public int hashCode() {
            return this.m_resource.hashCode();
        }

        @Override
        public int compareTo(ResourceSource t) {
            return this.m_resource.compareTo(t.m_resource);
        }

        public String toString() {
            return this.m_resource + " -> " + this.m_revision.getSymbolicName() + " [" + this.m_revision + "]";
        }
    }

    static class ToLocalUrlEnumeration
    implements Enumeration {
        final Enumeration m_enumeration;

        ToLocalUrlEnumeration(Enumeration enumeration) {
            this.m_enumeration = enumeration;
        }

        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        public Object nextElement() {
            return BundleWiringImpl.convertToLocalUrl((URL)this.m_enumeration.nextElement());
        }
    }
}

