/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.simplecorrelator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventDetailsTopComponent;
import rs.co.ast.aspen.gui.module.alertevents.eval.AlertEventTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.AlertEventsTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.ClusteringServiceTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.CorrelationContextTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.CounterManagerTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.CountryTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.DataMapManagerTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.DataMapperTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.NotificationManagerTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.RawLogTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.ScriptUtilsTest;
import rs.co.ast.aspen.gui.module.alertevents.eval.VirusTotalTest;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorPanel;

public class SimpleCorrelatorScriptEditorPanel
extends JPanel {
    private final RSyntaxTextArea taScriptText;
    private boolean scriptValid;
    private JPanel cp;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea taScriptValidationText;
    private JTextField tfSearch;

    public SimpleCorrelatorScriptEditorPanel() {
        this.initComponents();
        this.taScriptText = new RSyntaxTextArea(20, 60);
        this.taScriptText.setTabSize(4);
        this.taScriptText.setCodeFoldingEnabled(true);
        SyntaxScheme scheme = this.taScriptText.getSyntaxScheme();
        scheme.getStyle((int)10).foreground = new Color(153, 0, 0);
        scheme.getStyle((int)6).foreground = new Color(68, 85, 136);
        scheme.getStyle((int)7).foreground = new Color(0, 128, 128);
        scheme.getStyle((int)17).foreground = new Color(153, 0, 115);
        scheme.getStyle((int)1).foreground = new Color(0, 128, 0);
        scheme.getStyle((int)22).foreground = Color.DARK_GRAY;
        this.taScriptText.setSyntaxEditingStyle("text/javascript");
        Font font = this.taScriptText.getFontForTokenType(22);
        scheme.getStyle((int)22).font = font = font.deriveFont(1);
        this.taScriptText.setEnabled(Boolean.FALSE.booleanValue());
        this.tfSearch.setEditable(Boolean.FALSE);
        JPopupMenu taScriptPopupMenu = this.taScriptText.getPopupMenu();
        JMenuItem toggleEditMode = new JMenuItem(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.CodeEditor.menuToggleEditMode"));
        taScriptPopupMenu.add(toggleEditMode);
        toggleEditMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleCorrelatorScriptEditorPanel.this.taScriptText.isEnabled()) {
                    SimpleCorrelatorScriptEditorPanel.this.tfSearch.setEditable(Boolean.FALSE);
                    SimpleCorrelatorScriptEditorPanel.this.taScriptText.setEnabled(Boolean.FALSE.booleanValue());
                } else {
                    SimpleCorrelatorScriptEditorPanel.this.tfSearch.setEditable(Boolean.TRUE);
                    SimpleCorrelatorScriptEditorPanel.this.taScriptText.setEnabled(Boolean.TRUE.booleanValue());
                }
            }
        });
        this.taScriptText.setText(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.description"));
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.taScriptText);
        this.cp.add((Component)sp);
        this.taScriptText.setCaretPosition(0);
        this.taScriptText.addCaretListener(e -> this.validateScriptSyntax(this.taScriptText.getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateScriptSyntax(String script) {
        boolean valid = false;
        String errorMessage = "";
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            engine.eval(String.format("var DataMapper = Java.type(\"%s\")", DataMapperTest.class.getName()));
            engine.eval(String.format("var RawLog = Java.type(\"%s\")", RawLogTest.class.getName()));
            engine.eval(String.format("var SecurityEvent = Java.type(\"%s\")", AlertEventTest.class.getName()));
            engine.eval(String.format("var ScriptUtils = Java.type(\"%s\")", ScriptUtilsTest.class.getName()));
            engine.eval(String.format("var VirusTotal = Java.type(\"%s\")", VirusTotalTest.class.getName()));
            engine.eval(String.format("var API = Java.type(\"%s\")", VirusTotalTest.API.class.getName()));
            engine.eval("var System = Java.type(\"java.lang.System\");");
            engine.put("SLIDING", (Object)CorrelationContextTest.Mode.SLIDING_WINDOW);
            engine.put("FIXED", (Object)CorrelationContextTest.Mode.FIXED_WINDOW);
            engine.put("ASC", Boolean.TRUE);
            engine.put("DESC", Boolean.FALSE);
            engine.put("DataMap", new DataMapManagerTest());
            engine.put("log", Logger.getLogger(AlertEventDetailsTopComponent.class.getName()));
            engine.put("Notification", new NotificationManagerTest(new ClusteringServiceTest()));
            engine.put("Country", new CountryTest());
            engine.put("SecurityEvents", new AlertEventsTest());
            engine.put("Counter", new CounterManagerTest());
            engine.eval(script);
            valid = true;
        }
        catch (ScriptException ex) {
            valid = false;
            errorMessage = ex.getLocalizedMessage();
        }
        finally {
            if (valid) {
                this.taScriptValidationText.setForeground(Color.black);
                this.taScriptValidationText.setDisabledTextColor(Color.BLACK);
                this.taScriptValidationText.setText(NbBundle.getMessage(SimpleCorrelatorPanel.class, (String)"SimpleCorrelatorPanel.scriptValidator.valid.message"));
            } else {
                this.taScriptValidationText.setDisabledTextColor(Color.red);
                this.taScriptValidationText.setForeground(Color.red);
                this.taScriptValidationText.setText(errorMessage);
            }
            this.scriptValid = valid;
        }
    }

    public RSyntaxTextArea getTaScriptText() {
        return this.taScriptText;
    }

    public boolean isScriptValid() {
        return this.scriptValid;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfSearch = new JTextField();
        this.cp = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.taScriptValidationText = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SimpleCorrelatorScriptEditorPanel.class, (String)"SimpleCorrelatorScriptEditorPanel.jLabel1.text"));
        this.tfSearch.setText(NbBundle.getMessage(SimpleCorrelatorScriptEditorPanel.class, (String)"SimpleCorrelatorScriptEditorPanel.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleCorrelatorScriptEditorPanel.this.tfSearchActionPerformed(evt);
            }
        });
        this.cp.setLayout(new BorderLayout());
        this.taScriptValidationText.setColumns(20);
        this.taScriptValidationText.setRows(5);
        this.taScriptValidationText.setDisabledTextColor(new Color(51, 51, 51));
        this.taScriptValidationText.setEnabled(false);
        this.jScrollPane1.setViewportView(this.taScriptValidationText);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 865, Short.MAX_VALUE).addComponent(this.cp, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfSearch))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfSearch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cp, -1, 496, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 69, -2).addContainerGap()));
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        if (this.tfSearch.getText().isEmpty()) {
            this.taScriptText.setCaretPosition(0);
        }
        SearchContext context = new SearchContext();
        context.setSearchFor(this.tfSearch.getText());
        context.setMatchCase(false);
        context.setRegularExpression(true);
        context.setSearchForward(true);
        context.setWholeWord(false);
        context.setMarkAll(true);
        SearchEngine.find((JTextArea)this.taScriptText, (SearchContext)context);
    }
}

