/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.simplecorrelator;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.EventField;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorPanel;

public class ParamsTabelModel
extends AbstractTableModel {
    private static final DateTimeFormatter ISO_TIME_FORMAT = ISODateTimeFormat.dateTime();
    private final List<Item> data = new ArrayList<Item>();
    private final String[] columnNames = new String[]{SimpleCorrelatorPanel.PK, SimpleCorrelatorPanel.SK, NbBundle.getMessage(ParamsTabelModel.class, (String)"ParamsTabelPanel.paramsTabelMoel.paramsTabelHeader"), NbBundle.getMessage(ParamsTabelModel.class, (String)"ParamsTabelPanel.paramsTabelMoel.paramsAsArrayTabelHeader"), NbBundle.getMessage(ParamsTabelModel.class, (String)"ParamsTabelPanel.paramsTabelMoel.fieldTabelHeader"), NbBundle.getMessage(ParamsTabelModel.class, (String)"ParamsTabelPanel.paramsTabelMoel.valueTabelHeader")};
    private final Class[] columnClass = new Class[]{Boolean.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class};

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 4 && columnIndex != 5;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClass[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Item row = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.isPrimaryKey();
            }
            case 1: {
                return row.isSecondaryKey();
            }
            case 2: {
                return row.isParams();
            }
            case 3: {
                return row.isParamsAsArray();
            }
            case 4: {
                return row.getField();
            }
            case 5: {
                return row.getValue();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Item row = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                row.setPrimaryKey((Boolean)aValue);
                for (int i = 0; i < this.data.size(); ++i) {
                    if (i == rowIndex) continue;
                    this.data.get(i).setPrimaryKey(false);
                }
                this.fireTableDataChanged();
                break;
            }
            case 1: {
                row.setSecondaryKey((Boolean)aValue);
                for (int i = 0; i < this.data.size(); ++i) {
                    if (i == rowIndex) continue;
                    this.data.get(i).setSecondaryKey(false);
                }
                this.fireTableDataChanged();
                break;
            }
            case 2: {
                row.setParams((Boolean)aValue);
                break;
            }
            case 3: {
                row.setParamsAsArray((Boolean)aValue);
                break;
            }
            case 4: {
                row.setField((String)aValue);
                break;
            }
            case 5: {
                row.setValue((String)aValue);
                break;
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public List<Item> getData() {
        return this.data;
    }

    public void setTabelData(List<EventField> eventFields) {
        boolean pk = false;
        boolean sk = false;
        for (EventField e : eventFields) {
            if (e.getKey().equalsIgnoreCase("what.") || e.getKey().equalsIgnoreCase("who.")) {
                if (!pk) {
                    if (!(e.getField().equalsIgnoreCase("priority") || e.getField().equalsIgnoreCase("text") || e.getField().equalsIgnoreCase("message"))) {
                        this.data.add(new Item(true, false, true, e.getField(), e.getKey(), e.getValue()));
                        pk = true;
                        continue;
                    }
                    this.data.add(new Item(false, false, true, e.getField(), e.getKey(), e.getValue()));
                    continue;
                }
                this.data.add(new Item(false, false, true, e.getField(), e.getKey(), e.getValue()));
                continue;
            }
            if (e.getKey().equalsIgnoreCase("where.")) {
                if (!sk) {
                    if (e.getField().equalsIgnoreCase("hostname")) {
                        this.data.add(new Item(false, true, true, e.getField(), e.getKey(), e.getValue()));
                        sk = true;
                        continue;
                    }
                    this.data.add(new Item(false, false, true, e.getField(), e.getKey(), e.getValue()));
                    continue;
                }
                this.data.add(new Item(false, false, true, e.getField(), e.getKey(), e.getValue()));
                continue;
            }
            if (e.getKey().equalsIgnoreCase("when.")) {
                String value = e.getValue();
                try {
                    value = ISO_TIME_FORMAT.print(Long.valueOf(value).longValue());
                }
                catch (NumberFormatException ex) {
                    value = e.getValue();
                }
                this.data.add(new Item(false, false, false, e.getField(), e.getKey(), value));
                continue;
            }
            this.data.add(new Item(false, false, false, e.getField(), e.getKey(), e.getValue()));
        }
        this.fireTableDataChanged();
    }

    public class Item {
        private final String PARAMS_TEMPLATE = "%s : event.%s%s == null ? \"-\" : event.%s%s";
        private final String PARAMS_TEMPLATE_ARRAY = "%s : [event.%s%s == null ? \"-\" : event.%s%s]";
        private final String EVENT = "event";
        private boolean primaryKey;
        private boolean secondaryKey;
        private boolean params;
        private boolean paramsAsArray;
        private String field;
        private String paramsText;
        private String paramsTextArray;
        private String key;
        private String value;

        public Item(boolean primaryKey, boolean secondaryKey, boolean params, String field, String key, String value) {
            this.primaryKey = primaryKey;
            this.secondaryKey = secondaryKey;
            this.params = params;
            this.field = field;
            this.key = key;
            this.value = value;
            this.paramsText = String.format("%s : event.%s%s == null ? \"-\" : event.%s%s", field, key, field, key, field);
            this.paramsTextArray = String.format("%s : [event.%s%s == null ? \"-\" : event.%s%s]", field, key, field, key, field);
            this.paramsAsArray = false;
        }

        public String getEVENT() {
            return "event";
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isSecondaryKey() {
            return this.secondaryKey;
        }

        public boolean isParams() {
            return this.params;
        }

        public String getField() {
            return this.field;
        }

        public String getParamsText() {
            return this.paramsText;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
        }

        public void setSecondaryKey(boolean secondaryKey) {
            this.secondaryKey = secondaryKey;
        }

        public void setParams(boolean params) {
            this.params = params;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setParamsText(String paramsText) {
            this.paramsText = paramsText;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isParamsAsArray() {
            return this.paramsAsArray;
        }

        public void setParamsAsArray(boolean paramsAsArray) {
            this.paramsAsArray = paramsAsArray;
        }

        public String getTextForScript() {
            return this.paramsAsArray ? this.paramsTextArray : this.paramsText;
        }

        public String toString() {
            return this.field;
        }
    }
}

