/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.simplecorrelator;

import org.apache.commons.lang3.StringEscapeUtils;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.SimpleCorrelatorTableModel;

public class ConditionTreeNode {
    private String key;
    private String value;
    private SimpleCorrelatorTableModel.Operation operation;

    public ConditionTreeNode(String key, String value, SimpleCorrelatorTableModel.Operation operation) {
        this.key = key;
        this.value = StringEscapeUtils.escapeEcmaScript((String)value).toLowerCase();
        this.operation = operation;
    }

    public ConditionTreeNode(SimpleCorrelatorTableModel.Item item) {
        this.key = item.getKey();
        this.value = StringEscapeUtils.escapeEcmaScript((String)item.getValue()).toLowerCase();
        this.operation = item.getOperation();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringEscapeUtils.escapeEcmaScript((String)value).toLowerCase();
    }

    public SimpleCorrelatorTableModel.Operation getOperation() {
        return this.operation;
    }

    public void setOperation(SimpleCorrelatorTableModel.Operation operation) {
        this.operation = operation;
    }

    public String toString() {
        StringBuilder condition = new StringBuilder();
        if (this.operation.equals((Object)SimpleCorrelatorTableModel.Operation.ISINLIST)) {
            this.value = this.value.replace(", ", ",");
            String[] split = this.value.split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    condition.append("[");
                }
                this.appendQuotes(condition, split[i]);
                if (i != split.length - 1) {
                    condition.append(", ");
                    continue;
                }
                condition.append("]");
            }
        } else {
            this.appendQuotes(condition, this.value);
        }
        StringBuilder sb = new StringBuilder();
        switch (this.operation) {
            case STARTSWITH: 
            case ENDSWITH: 
            case CONTAINS: {
                sb.append("event.").append(this.key).append(".toLowerCase()").append(".").append((Object)this.operation).append("(").append((CharSequence)condition).append(")");
                break;
            }
            case GETHOUROFTHEDAY: {
                sb.append("new org.joda.time.DateTime(java.lang.Long.valueOf(").append("event.").append(this.key).append(")).getHourOfDay()").append("===").append((CharSequence)condition);
                break;
            }
            case ISINLIST: {
                sb.append("isInList(").append("event.").append(this.key).append(", ").append((CharSequence)condition).append(")");
                break;
            }
            default: {
                sb.append("event.").append(this.key).append(".toLowerCase()").append(" ").append((Object)this.operation).append((CharSequence)condition);
            }
        }
        return sb.toString();
    }

    private void appendQuotes(StringBuilder sb, String s) {
        if (this.key.contains("when.")) {
            sb.append(" ").append(s).append(" ");
        } else {
            sb.append(" '").append(s).append("' ");
        }
    }
}

