/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.table.DefaultTableModel;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class AlertResultTableModel
extends DefaultTableModel {
    private List<String> columnNames = new ArrayList<String>();
    private List<Map<String, String>> data = new ArrayList<Map<String, String>>();
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 && this.columnNames.get(columnIndex).contains("func.")) {
            return Integer.class;
        }
        return String.class;
    }

    public int getColumnIndexByColumnName(String columnName) {
        return this.columnNames.indexOf(columnName);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames != null ? this.columnNames.get(column) : "unknown";
    }

    @Override
    public int getColumnCount() {
        return this.columnNames != null ? this.columnNames.size() : 0;
    }

    public void addColumn(String columnName) {
        if (columnName != null) {
            this.columnNames.add(columnName);
            this.fireTableStructureChanged();
        }
    }

    public void removeColumn(String columnName) {
        if (columnName != null) {
            this.columnNames.remove(columnName);
            this.fireTableStructureChanged();
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        String col = this.columnNames.get(column);
        String val = this.data.get(row).get(col);
        if (column == 0) {
            return Integer.valueOf(val);
        }
        if (val != null && (col.contains("when.generated") || col.contains("when.persisted") || col.contains("when.request_time"))) {
            if (col.contains("when.request_time")) {
                val = val.replace(".", "");
            }
            try {
                Long lVal = Long.valueOf(val);
                val = this.isoTimeFormat.print(lVal.longValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    public void setData(List<Map<String, String>> data) {
        if (data != null) {
            TreeSet<String> kolone = new TreeSet<String>(new Comparator<String>(){
                List<String> order = Arrays.asList("func", "what", "when", "where", "who", "extra");

                @Override
                public int compare(String o1, String o2) {
                    String[] o2Split;
                    String[] o1Split = o1.split("\\.");
                    if (o1Split[0].equals((o2Split = o2.split("\\."))[0])) {
                        return o1Split[1].compareToIgnoreCase(o2Split[1]);
                    }
                    return Integer.valueOf(this.order.indexOf(o1Split[0])).compareTo(this.order.indexOf(o2Split[0]));
                }
            });
            kolone.add("func.count");
            for (Map<String, String> row : data) {
                for (String k : row.keySet()) {
                    kolone.add(k);
                }
            }
            LinkedHashSet<String> cols = new LinkedHashSet<String>();
            for (String kol : kolone) {
                cols.add(kol);
            }
            this.columnNames = new ArrayList<String>(cols);
            this.fireTableStructureChanged();
            this.data = data;
            this.fireTableDataChanged();
        }
    }

    public List<Map<String, String>> getData() {
        return this.data;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public boolean isColumnVisible(String columnName) {
        for (String col : this.columnNames) {
            if (!col.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public void resetData() {
        this.columnNames.clear();
        this.data.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void resetDataKeepColumns() {
        this.data.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }
}

