/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openide.options.ContextSystemOption;
import org.openide.text.PrintPreferences;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class PrintSettings
extends ContextSystemOption {
    static final long serialVersionUID = -9102470021814206818L;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    public static final String PROP_PAGE_FORMAT = "pageFormat";
    public static final String PROP_WRAP = "wrap";
    public static final String PROP_HEADER_FORMAT = "headerFormat";
    public static final String PROP_FOOTER_FORMAT = "footerFormat";
    public static final String PROP_HEADER_FONT = "headerFont";
    public static final String PROP_FOOTER_FONT = "footerFont";
    public static final String PROP_HEADER_ALIGNMENT = "headerAlignment";
    public static final String PROP_FOOTER_ALIGNMENT = "footerAlignment";
    public static final String PROP_LINE_ASCENT_CORRECTION = "lineAscentCorrection";
    private static final String HELP_ID = "editing.printing";

    @Override
    public String displayName() {
        return NbBundle.getMessage(PrintSettings.class, (String)"CTL_Print_settings");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public static PageFormat getPageFormat(PrinterJob pj) {
        return PrintPreferences.getPageFormat((PrinterJob)pj);
    }

    public PageFormat getPageFormat() {
        return PrintSettings.getPageFormat(PrinterJob.getPrinterJob());
    }

    public void setPageFormat(PageFormat pf) {
        PrintPreferences.setPageFormat((PageFormat)pf);
        this.firePropertyChange(PROP_PAGE_FORMAT, null, pf);
    }

    public boolean getWrap() {
        return PrintPreferences.getWrap();
    }

    public void setWrap(boolean b) {
        PrintPreferences.setWrap((boolean)b);
        this.firePropertyChange(PROP_WRAP, b ? Boolean.FALSE : Boolean.TRUE, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getHeaderFormat() {
        return PrintPreferences.getHeaderFormat();
    }

    public void setHeaderFormat(String s) {
        PrintPreferences.setHeaderFormat((String)s);
        this.firePropertyChange(PROP_HEADER_FORMAT, null, s);
    }

    public String getFooterFormat() {
        return PrintPreferences.getFooterFormat();
    }

    public void setFooterFormat(String s) {
        PrintPreferences.setFooterFormat((String)s);
        this.firePropertyChange(PROP_FOOTER_FORMAT, null, s);
    }

    public Font getHeaderFont() {
        return PrintPreferences.getHeaderFont();
    }

    public void setHeaderFont(Font f) {
        PrintPreferences.setHeaderFont((Font)f);
        this.firePropertyChange(PROP_HEADER_FONT, null, f);
    }

    public Font getFooterFont() {
        return PrintPreferences.getFooterFont();
    }

    public void setFooterFont(Font f) {
        PrintPreferences.setFooterFont((Font)f);
        this.firePropertyChange(PROP_FOOTER_FONT, null, f);
    }

    public int getHeaderAlignment() {
        return this.fromAlignment(PrintPreferences.getHeaderAlignment());
    }

    public void setHeaderAlignment(int alignment) {
        PrintPreferences.setHeaderAlignment((PrintPreferences.Alignment)this.toAlignment(alignment));
        this.firePropertyChange(PROP_HEADER_ALIGNMENT, null, new Integer(alignment));
    }

    private PrintPreferences.Alignment toAlignment(int alignment) {
        PrintPreferences.Alignment retval = PrintPreferences.Alignment.CENTER;
        switch (alignment) {
            case 1: {
                retval = PrintPreferences.Alignment.CENTER;
                break;
            }
            case 0: {
                retval = PrintPreferences.Alignment.LEFT;
                break;
            }
            case 2: {
                retval = PrintPreferences.Alignment.RIGHT;
            }
        }
        return retval;
    }

    private int fromAlignment(PrintPreferences.Alignment alignment) {
        int retval = 1;
        if (PrintPreferences.Alignment.CENTER.equals((Object)alignment)) {
            retval = 1;
        } else if (PrintPreferences.Alignment.LEFT.equals((Object)alignment)) {
            retval = 0;
        } else if (PrintPreferences.Alignment.RIGHT.equals((Object)alignment)) {
            retval = 2;
        }
        return retval;
    }

    public int getFooterAlignment() {
        return this.fromAlignment(PrintPreferences.getFooterAlignment());
    }

    public void setFooterAlignment(int alignment) {
        PrintPreferences.setFooterAlignment((PrintPreferences.Alignment)this.toAlignment(alignment));
        this.firePropertyChange(PROP_FOOTER_ALIGNMENT, null, new Integer(alignment));
    }

    public float getLineAscentCorrection() {
        return PrintPreferences.getLineAscentCorrection();
    }

    public void setLineAscentCorrection(float correction) {
        PrintPreferences.setLineAscentCorrection((float)correction);
        this.firePropertyChange(PROP_LINE_ASCENT_CORRECTION, null, new Float(correction));
    }

    @Override
    public void writeExternal(ObjectOutput obtos) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput obtis) throws IOException, ClassNotFoundException {
    }

    public static class AlignmentEditor
    extends PropertyEditorSupport {
        private String sCENTER;
        private String sRIGHT;
        private String sLEFT = NbBundle.getMessage(PrintSettings.class, (String)"CTL_LEFT");
        private String[] tags = new String[]{this.sLEFT, this.sCENTER = NbBundle.getMessage(PrintSettings.class, (String)"CTL_CENTER"), this.sRIGHT = NbBundle.getMessage(PrintSettings.class, (String)"CTL_RIGHT")};

        @Override
        public String[] getTags() {
            return this.tags;
        }

        @Override
        public String getAsText() {
            return this.tags[(Integer)this.getValue()];
        }

        @Override
        public void setAsText(String s) {
            if (s.equals(this.sLEFT)) {
                this.setValue(new Integer(0));
            } else if (s.equals(this.sCENTER)) {
                this.setValue(new Integer(1));
            } else {
                this.setValue(new Integer(2));
            }
        }
    }

    public static class PageFormatEditor
    extends PropertyEditorSupport {
        @Override
        public String getAsText() {
            return null;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            PageFormat pf = (PageFormat)this.getValue();
            PrinterJob pj = PrinterJob.getPrinterJob();
            PageFormat npf = pj.pageDialog(pf);
            ((PrintSettings)PrintSettings.findObject(PrintSettings.class)).setPageFormat((PageFormat)npf.clone());
            pj.cancel();
            return null;
        }
    }
}

