/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.export;

import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.gui.rawlogs.export.FetchResult;
import rs.co.ast.aspen.gui.rawlogs.export.listeners.ProgressValueChangedSupport;

public class PDFDataSource
extends ProgressValueChangedSupport
implements JRDataSource {
    private List<RawLog> logs;
    private float elapsed = 0.0f;
    private long totalSearchDuration = 0L;
    private long totalHits = 0L;
    private int position_list = -1;
    private int pageSize;

    public PDFDataSource(FetchResult result) {
        this.logs = result.getEvents();
        this.totalSearchDuration = result.getTotalSearchDuration();
        this.totalHits = result.getTotalHits();
        this.pageSize = 10000L > this.totalHits ? (int)this.totalHits : 10000;
    }

    public boolean next() throws JRException {
        this.elapsed = (float)this.totalSearchDuration - (float)this.totalSearchDuration * ((float)Math.abs(this.position_list) / (float)this.pageSize);
        this.fireProgressValueChangedEvent(this.position_list, this.position_list + 1, this.logs.size(), this.elapsed);
        return this.logs.size() > ++this.position_list;
    }

    public Object getFieldValue(JRField jrf) throws JRException {
        if (this.position_list < this.logs.size()) {
            switch (jrf.getName()) {
                case "id": {
                    return this.logs.get(this.position_list).getId();
                }
                case "source": {
                    return this.logs.get(this.position_list).getSource();
                }
                case "date": {
                    DateTime dDate = new DateTime((Object)this.logs.get(this.position_list).getTimestamp());
                    DateTimeFormatter dDtf = ISODateTimeFormat.yearMonthDay();
                    return dDate.toString(dDtf);
                }
                case "time": {
                    DateTime tDate = new DateTime((Object)this.logs.get(this.position_list).getTimestamp());
                    DateTimeFormatter tDtf = ISODateTimeFormat.hourMinuteSecondFraction();
                    return tDate.toString(tDtf);
                }
                case "text": {
                    return this.logs.get(this.position_list).getText();
                }
                case "metaData": {
                    return this.logs.get(this.position_list).getMetaData().toString();
                }
            }
        }
        return "unknown field " + jrf.getName();
    }
}

