/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import rs.co.ast.aspen.api.service.RawLog;

public class RawLogTableRenderer
extends JTextPane
implements TableCellRenderer {
    private static DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime();
    private List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();

    public RawLogTableRenderer() {
        this.setOpaque(true);
        this.setEditable(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        RawLog log = (RawLog)value;
        StringBuilder sb = new StringBuilder();
        switch (column) {
            case 0: {
                sb.append(isoTimeFormat.print(log.getTimestamp().longValue()));
                break;
            }
            case 1: {
                sb.append(log.getSource());
                break;
            }
            case 2: {
                sb.append(log.getText());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index");
            }
        }
        this.setText(sb.toString());
        this.adjustRowHeight(table, row, column);
        return this;
    }

    private void adjustRowHeight(JTable table, int row, int column) {
        int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
        this.setSize(new Dimension(cWidth, 1000));
        int prefH = this.getPreferredSize().height;
        while (this.rowColHeight.size() <= row) {
            this.rowColHeight.add(new ArrayList(column));
        }
        List<Integer> colHeights = this.rowColHeight.get(row);
        while (colHeights.size() <= column) {
            colHeights.add(0);
        }
        colHeights.set(column, prefH);
        int maxH = prefH;
        for (Integer colHeight : colHeights) {
            if (colHeight <= maxH) continue;
            maxH = colHeight;
        }
        if (table.getRowHeight(row) != maxH) {
            table.setRowHeight(row, maxH);
        }
    }
}

