/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.BatchNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.custom.SkeletonBone;
import com.jme3.scene.debug.custom.SkeletonInterBoneWire;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SkeletonDebugger
extends BatchNode {
    private SkeletonBone bones;
    private Skeleton skeleton;
    private SkeletonInterBoneWire interBoneWires;
    private List<Bone> selectedBones = new ArrayList<Bone>();
    ColorRGBA selectedColor = ColorRGBA.Orange;
    ColorRGBA baseColor = new ColorRGBA(0.05f, 0.05f, 0.05f, 1.0f);

    public SkeletonDebugger() {
    }

    public SkeletonDebugger(String name, Skeleton skeleton, boolean guessBonesOrientation) {
        super(name);
        this.skeleton = skeleton;
        skeleton.reset();
        skeleton.updateWorldVectors();
        HashMap<Integer, Float> boneLengths = new HashMap<Integer, Float>();
        for (Bone bone : skeleton.getRoots()) {
            this.computeLength(bone, boneLengths, skeleton);
        }
        this.bones = new SkeletonBone(skeleton, boneLengths, guessBonesOrientation);
        this.attachChild(this.bones);
        this.interBoneWires = new SkeletonInterBoneWire(skeleton, boneLengths, guessBonesOrientation);
        Geometry g = new Geometry(name + "_interwires", this.interBoneWires);
        g.setBatchHint(Spatial.BatchHint.Never);
        this.attachChild(g);
    }

    protected void initialize(AssetManager assetManager) {
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", new ColorRGBA(0.05f, 0.05f, 0.05f, 1.0f));
        this.setMaterial(mat);
        Material mat2 = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat2.setBoolean("VertexColor", true);
        this.bones.setMaterial(mat2);
        this.batch();
    }

    @Override
    public final void setMaterial(Material material) {
        if (this.batches.isEmpty()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((Spatial)this.children.get(i)).setMaterial(material);
            }
        } else {
            super.setMaterial(material);
        }
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    private void computeLength(Bone b, Map<Integer, Float> boneLengths, Skeleton skeleton) {
        if (b.getChildren().isEmpty()) {
            if (b.getParent() != null) {
                boneLengths.put(skeleton.getBoneIndex(b), Float.valueOf(boneLengths.get(skeleton.getBoneIndex(b.getParent())).floatValue() * 0.75f));
            } else {
                boneLengths.put(skeleton.getBoneIndex(b), Float.valueOf(0.1f));
            }
        } else {
            float length = Float.MAX_VALUE;
            for (Bone bone : b.getChildren()) {
                float len = b.getModelSpacePosition().subtract(bone.getModelSpacePosition()).length();
                if (!(len < length)) continue;
                length = len;
            }
            boneLengths.put(skeleton.getBoneIndex(b), Float.valueOf(length));
            for (Bone bone : b.getChildren()) {
                this.computeLength(bone, boneLengths, skeleton);
            }
        }
    }

    @Override
    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        this.bones.updateGeometry();
        if (this.interBoneWires != null) {
            this.interBoneWires.updateGeometry();
        }
    }

    protected Bone select(Geometry g) {
        Node oldNode = this.bones.getSelectedNode();
        Bone b = this.bones.select(g);
        if (b == null) {
            return null;
        }
        if (oldNode != null) {
            this.markSelected(oldNode, false);
        }
        this.markSelected(this.bones.getSelectedNode(), true);
        return b;
    }

    public SkeletonBone getBoneShapes() {
        return this.bones;
    }

    public SkeletonInterBoneWire getInterBoneWires() {
        return this.interBoneWires;
    }

    protected void markSelected(Node n, boolean selected) {
        ColorRGBA c = this.baseColor;
        if (selected) {
            c = this.selectedColor;
        }
        for (Spatial spatial : n.getChildren()) {
            if (!(spatial instanceof Geometry)) continue;
            Geometry geom = (Geometry)spatial;
            Geometry batch = (Geometry)this.getChild(this.getName() + "-batch0");
            VertexBuffer vb = batch.getMesh().getBuffer(VertexBuffer.Type.Color);
            FloatBuffer color = (FloatBuffer)vb.getData();
            color.position(SkeletonDebugger.getGeometryStartIndex(geom) * 4);
            for (int i = 0; i < geom.getVertexCount(); ++i) {
                color.put(c.r).put(c.g).put(c.b).put(c.a);
            }
            color.rewind();
            vb.updateData(color);
        }
    }
}

