/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.custom.SkeletonDebugger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SkeletonDebugAppState
extends AbstractAppState {
    private Node debugNode = new Node("debugNode");
    private Map<Skeleton, SkeletonDebugger> skeletons = new HashMap<Skeleton, SkeletonDebugger>();
    private Map<Skeleton, Bone> selectedBones = new HashMap<Skeleton, Bone>();
    private Application app;
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void onAction(String name, boolean isPressed, float tpf) {
            if (name.equals("shoot") && isPressed) {
                CollisionResults results = new CollisionResults();
                Vector2f click2d = SkeletonDebugAppState.this.app.getInputManager().getCursorPosition();
                Vector3f click3d = SkeletonDebugAppState.this.app.getCamera().getWorldCoordinates(new Vector2f(click2d.x, click2d.y), 0.0f).clone();
                Vector3f dir = SkeletonDebugAppState.this.app.getCamera().getWorldCoordinates(new Vector2f(click2d.x, click2d.y), 1.0f).subtractLocal(click3d);
                Ray ray = new Ray(click3d, dir);
                SkeletonDebugAppState.this.debugNode.collideWith(ray, results);
                if (results.size() > 0) {
                    Geometry target = results.getClosestCollision().getGeometry();
                    for (SkeletonDebugger skeleton : SkeletonDebugAppState.this.skeletons.values()) {
                        Bone selectedBone = skeleton.select(target);
                        if (selectedBone == null) continue;
                        SkeletonDebugAppState.this.selectedBones.put(skeleton.getSkeleton(), selectedBone);
                        System.err.println("-----------------------");
                        System.err.println("Selected Bone : " + selectedBone.getName() + " in skeleton " + skeleton.getName());
                        System.err.println("Root Bone : " + (selectedBone.getParent() == null));
                        System.err.println("-----------------------");
                        System.err.println("Bind translation: " + selectedBone.getBindPosition());
                        System.err.println("Bind rotation: " + selectedBone.getBindRotation());
                        System.err.println("Bind scale: " + selectedBone.getBindScale());
                        System.err.println("---");
                        System.err.println("Local translation: " + selectedBone.getLocalPosition());
                        System.err.println("Local rotation: " + selectedBone.getLocalRotation());
                        System.err.println("Local scale: " + selectedBone.getLocalScale());
                        System.err.println("---");
                        System.err.println("Model translation: " + selectedBone.getModelSpacePosition());
                        System.err.println("Model rotation: " + selectedBone.getModelSpaceRotation());
                        System.err.println("Model scale: " + selectedBone.getModelSpaceScale());
                        System.err.println("---");
                        System.err.println("Bind inverse Transform: ");
                        System.err.println(selectedBone.getBindInverseTransform());
                        return;
                    }
                }
            }
        }
    };

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        ViewPort vp = app.getRenderManager().createMainView("debug", app.getCamera());
        vp.attachScene(this.debugNode);
        vp.setClearDepth(true);
        this.app = app;
        for (SkeletonDebugger skeletonDebugger : this.skeletons.values()) {
            skeletonDebugger.initialize(app.getAssetManager());
        }
        app.getInputManager().addListener(this.actionListener, "shoot");
        app.getInputManager().addMapping("shoot", new MouseButtonTrigger(0), new MouseButtonTrigger(1));
        super.initialize(stateManager, app);
    }

    @Override
    public void update(float tpf) {
        this.debugNode.updateLogicalState(tpf);
        this.debugNode.updateGeometricState();
    }

    public SkeletonDebugger addSkeleton(SkeletonControl skeletonControl, boolean guessBonesOrientation) {
        Skeleton skeleton = skeletonControl.getSkeleton();
        Spatial forSpatial = skeletonControl.getSpatial();
        return this.addSkeleton(skeleton, forSpatial, guessBonesOrientation);
    }

    public SkeletonDebugger addSkeleton(Skeleton skeleton, Spatial forSpatial, boolean guessBonesOrientation) {
        SkeletonDebugger sd = new SkeletonDebugger(forSpatial.getName() + "_Skeleton", skeleton, guessBonesOrientation);
        sd.setLocalTransform(forSpatial.getWorldTransform());
        if (forSpatial instanceof Node) {
            ArrayList<Geometry> geoms = new ArrayList<Geometry>();
            this.findGeoms((Node)forSpatial, geoms);
            if (geoms.size() == 1) {
                sd.setLocalTransform(((Geometry)geoms.get(0)).getWorldTransform());
            }
        }
        this.skeletons.put(skeleton, sd);
        this.debugNode.attachChild(sd);
        if (this.isInitialized()) {
            sd.initialize(this.app.getAssetManager());
        }
        return sd;
    }

    private void findGeoms(Node node, List<Geometry> geoms) {
        for (Spatial spatial : node.getChildren()) {
            if (spatial instanceof Geometry) {
                geoms.add((Geometry)spatial);
                continue;
            }
            if (!(spatial instanceof Node)) continue;
            this.findGeoms((Node)spatial, geoms);
        }
    }

    public Map<Skeleton, Bone> getSelectedBones() {
        return this.selectedBones;
    }

    public Node getDebugNode() {
        return this.debugNode;
    }

    public void setDebugNode(Node debugNode) {
        this.debugNode = debugNode;
    }
}

