/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.queue;

import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.scene.Geometry;

public class TransparentComparator
implements GeometryComparator {
    private Camera cam;
    private final Vector3f tempVec = new Vector3f();

    @Override
    public void setCamera(Camera cam) {
        this.cam = cam;
    }

    private float distanceToCam2(Geometry spat) {
        if (spat == null) {
            return Float.NEGATIVE_INFINITY;
        }
        if (spat.queueDistance != Float.NEGATIVE_INFINITY) {
            return spat.queueDistance;
        }
        Vector3f camPosition = this.cam.getLocation();
        Vector3f viewVector = this.cam.getDirection();
        Vector3f spatPosition = null;
        spatPosition = spat.getWorldBound() != null ? spat.getWorldBound().getCenter() : spat.getWorldTranslation();
        spatPosition.subtract(camPosition, this.tempVec);
        spat.queueDistance = this.tempVec.dot(this.tempVec);
        float retval = Math.abs(this.tempVec.dot(viewVector) / viewVector.dot(viewVector));
        viewVector.mult(retval, this.tempVec);
        spat.queueDistance = this.tempVec.length();
        return spat.queueDistance;
    }

    private float distanceToCam(Geometry spat) {
        return spat.getWorldBound().distanceToEdge(this.cam.getLocation());
    }

    @Override
    public int compare(Geometry o1, Geometry o2) {
        float d2;
        float d1 = this.distanceToCam(o1);
        if (d1 == (d2 = this.distanceToCam(o2))) {
            return 0;
        }
        if (d1 < d2) {
            return 1;
        }
        return -1;
    }
}

