/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.post.FilterPostProcessor;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;

public abstract class Filter
implements Savable {
    private String name;
    protected Pass defaultPass;
    protected List<Pass> postRenderPasses;
    protected Material material;
    protected boolean enabled = true;
    protected FilterPostProcessor processor;

    public Filter(String name) {
        this.name = name;
    }

    protected Image.Format getDefaultPassTextureFormat() {
        return this.processor.getDefaultPassTextureFormat();
    }

    protected Image.Format getDefaultPassDepthFormat() {
        return Image.Format.Depth;
    }

    protected Filter() {
        this("filter");
    }

    protected final void init(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.defaultPass = new Pass();
        this.defaultPass.init(renderManager.getRenderer(), w, h, this.getDefaultPassTextureFormat(), this.getDefaultPassDepthFormat());
        this.initFilter(manager, renderManager, vp, w, h);
    }

    protected final void cleanup(Renderer r) {
        this.processor = null;
        if (this.defaultPass != null) {
            this.defaultPass.cleanup(r);
        }
        if (this.postRenderPasses != null) {
            for (Pass pass : this.postRenderPasses) {
                pass.cleanup(r);
            }
        }
        this.cleanUpFilter(r);
    }

    protected abstract void initFilter(AssetManager var1, RenderManager var2, ViewPort var3, int var4, int var5);

    protected void cleanUpFilter(Renderer r) {
    }

    protected abstract Material getMaterial();

    protected void setDepthTexture(Texture depthTexture) {
        this.getMaterial().setTexture("DepthTexture", depthTexture);
    }

    protected void postQueue(RenderQueue queue) {
    }

    protected void preFrame(float tpf) {
    }

    protected void postFrame(RenderManager renderManager, ViewPort viewPort, FrameBuffer prevFilterBuffer, FrameBuffer sceneBuffer) {
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", "");
        oc.write(this.enabled, "enabled", true);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", "");
        this.enabled = ic.readBoolean("enabled", true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected FrameBuffer getRenderFrameBuffer() {
        return this.defaultPass.renderFrameBuffer;
    }

    protected void setRenderFrameBuffer(FrameBuffer renderFrameBuffer) {
        this.defaultPass.renderFrameBuffer = renderFrameBuffer;
    }

    protected Texture2D getRenderedTexture() {
        return this.defaultPass.renderedTexture;
    }

    protected void setRenderedTexture(Texture2D renderedTexture) {
        this.defaultPass.renderedTexture = renderedTexture;
    }

    protected boolean isRequiresDepthTexture() {
        return false;
    }

    protected boolean isRequiresSceneTexture() {
        return true;
    }

    protected boolean isRequiresBilinear() {
        return false;
    }

    protected List<Pass> getPostRenderPasses() {
        return this.postRenderPasses;
    }

    public void setEnabled(boolean enabled) {
        if (this.processor != null) {
            this.processor.setFilterState(this, enabled);
        } else {
            this.enabled = enabled;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setProcessor(FilterPostProcessor proc) {
        this.processor = proc;
    }

    protected void postFilter(Renderer r, FrameBuffer buffer) {
    }

    public class Pass {
        protected FrameBuffer renderFrameBuffer;
        protected Texture2D renderedTexture;
        protected Texture2D depthTexture;
        protected Material passMaterial;
        protected String name;

        public Pass(String name) {
            this.name = name;
        }

        public Pass() {
        }

        public void init(Renderer renderer, int width, int height, Image.Format textureFormat, Image.Format depthBufferFormat, int numSamples, boolean renderDepth) {
            EnumSet<Caps> caps = renderer.getCaps();
            if (numSamples > 1 && caps.contains((Object)Caps.FrameBufferMultisample) && caps.contains((Object)Caps.OpenGL31)) {
                this.renderFrameBuffer = new FrameBuffer(width, height, numSamples);
                this.renderedTexture = new Texture2D(width, height, numSamples, textureFormat);
                this.renderFrameBuffer.setDepthBuffer(depthBufferFormat);
                if (renderDepth) {
                    this.depthTexture = new Texture2D(width, height, numSamples, depthBufferFormat);
                    this.renderFrameBuffer.setDepthTexture(this.depthTexture);
                }
            } else {
                this.renderFrameBuffer = new FrameBuffer(width, height, 1);
                this.renderedTexture = new Texture2D(width, height, textureFormat);
                this.renderFrameBuffer.setDepthBuffer(depthBufferFormat);
                if (renderDepth) {
                    this.depthTexture = new Texture2D(width, height, depthBufferFormat);
                    this.renderFrameBuffer.setDepthTexture(this.depthTexture);
                }
            }
            this.renderFrameBuffer.setColorTexture(this.renderedTexture);
        }

        public void init(Renderer renderer, int width, int height, Image.Format textureFormat, Image.Format depthBufferFormat) {
            this.init(renderer, width, height, textureFormat, depthBufferFormat, 1);
        }

        public void init(Renderer renderer, int width, int height, Image.Format textureFormat, Image.Format depthBufferFormat, int numSamples) {
            this.init(renderer, width, height, textureFormat, depthBufferFormat, numSamples, false);
        }

        public void init(Renderer renderer, int width, int height, Image.Format textureFormat, Image.Format depthBufferFormat, int numSample, Material material) {
            this.init(renderer, width, height, textureFormat, depthBufferFormat, numSample);
            this.passMaterial = material;
        }

        public boolean requiresSceneAsTexture() {
            return false;
        }

        public boolean requiresDepthAsTexture() {
            return false;
        }

        public void beforeRender() {
        }

        public FrameBuffer getRenderFrameBuffer() {
            return this.renderFrameBuffer;
        }

        public void setRenderFrameBuffer(FrameBuffer renderFrameBuffer) {
            this.renderFrameBuffer = renderFrameBuffer;
        }

        public Texture2D getDepthTexture() {
            return this.depthTexture;
        }

        public Texture2D getRenderedTexture() {
            return this.renderedTexture;
        }

        public void setRenderedTexture(Texture2D renderedTexture) {
            this.renderedTexture = renderedTexture;
        }

        public Material getPassMaterial() {
            return this.passMaterial;
        }

        public void setPassMaterial(Material passMaterial) {
            this.passMaterial = passMaterial;
        }

        public void cleanup(Renderer r) {
            this.renderFrameBuffer.dispose();
            this.renderedTexture.getImage().dispose();
            if (this.depthTexture != null) {
                this.depthTexture.getImage().dispose();
            }
        }

        public String toString() {
            return this.name == null ? super.toString() : this.name;
        }
    }
}

