/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.logic;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingSphere;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.LightProbe;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.material.logic.DefaultTechniqueDefLogic;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.util.TempVars;
import java.util.EnumSet;

public final class SinglePassAndImageBasedLightingLogic
extends DefaultTechniqueDefLogic {
    private static final String DEFINE_SINGLE_PASS_LIGHTING = "SINGLE_PASS_LIGHTING";
    private static final String DEFINE_NB_LIGHTS = "NB_LIGHTS";
    private static final String DEFINE_INDIRECT_LIGHTING = "INDIRECT_LIGHTING";
    private static final RenderState ADDITIVE_LIGHT = new RenderState();
    private final ColorRGBA ambientLightColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private LightProbe lightProbe = null;
    private final int singlePassLightingDefineId;
    private final int nbLightsDefineId;
    private final int indirectLightingDefineId;

    public SinglePassAndImageBasedLightingLogic(TechniqueDef techniqueDef) {
        super(techniqueDef);
        this.singlePassLightingDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_SINGLE_PASS_LIGHTING, VarType.Boolean);
        this.nbLightsDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_NB_LIGHTS, VarType.Int);
        this.indirectLightingDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_INDIRECT_LIGHTING, VarType.Boolean);
    }

    @Override
    public Shader makeCurrent(AssetManager assetManager, RenderManager renderManager, EnumSet<Caps> rendererCaps, LightList lights, DefineList defines) {
        defines.set(this.nbLightsDefineId, renderManager.getSinglePassLightBatchSize() * 3);
        defines.set(this.singlePassLightingDefineId, true);
        if (lights != null) {
            this.lightProbe = this.extractIndirectLights(lights, false);
            if (this.lightProbe == null) {
                defines.set(this.indirectLightingDefineId, false);
            } else {
                defines.set(this.indirectLightingDefineId, true);
            }
        }
        return super.makeCurrent(assetManager, renderManager, rendererCaps, lights, defines);
    }

    protected int updateLightListUniforms(Shader shader, Geometry g, LightList lightList, int numLights, RenderManager rm, int startIndex, int lastTexUnit) {
        int curIndex;
        if (numLights == 0) {
            return 0;
        }
        Uniform lightData = shader.getUniform("g_LightData");
        lightData.setVector4Length(numLights * 3);
        Uniform ambientColor = shader.getUniform("g_AmbientLightColor");
        Uniform lightProbeData = shader.getUniform("g_LightProbeData");
        lightProbeData.setVector4Length(1);
        Uniform shCoeffs = shader.getUniform("g_ShCoeffs");
        Uniform lightProbePemMap = shader.getUniform("g_PrefEnvMap");
        this.lightProbe = null;
        if (startIndex != 0) {
            rm.getRenderer().applyRenderState(ADDITIVE_LIGHT);
            ambientColor.setValue(VarType.Vector4, ColorRGBA.Black);
        } else {
            this.lightProbe = this.extractIndirectLights(lightList, true);
            ambientColor.setValue(VarType.Vector4, this.ambientLightColor);
        }
        if (this.lightProbe != null) {
            BoundingSphere s = (BoundingSphere)this.lightProbe.getBounds();
            lightProbeData.setVector4InArray(this.lightProbe.getPosition().x, this.lightProbe.getPosition().y, this.lightProbe.getPosition().z, 1.0f / s.getRadius() + (float)this.lightProbe.getNbMipMaps(), 0);
            shCoeffs.setValue(VarType.Vector3Array, this.lightProbe.getShCoeffs());
            int pemUnit = lastTexUnit++;
            rm.getRenderer().setTexture(pemUnit, this.lightProbe.getPrefilteredEnvMap());
            lightProbePemMap.setValue(VarType.Int, pemUnit);
        } else {
            lightProbeData.setVector4InArray(0.0f, 0.0f, 0.0f, -1.0f, 0);
        }
        int lightDataIndex = 0;
        TempVars vars = TempVars.get();
        Vector4f tmpVec = vars.vect4f1;
        int endIndex = numLights + startIndex;
        block5: for (curIndex = startIndex; curIndex < endIndex && curIndex < lightList.size(); ++curIndex) {
            Light l = lightList.get(curIndex);
            if (l.getType() == Light.Type.Ambient) {
                ++endIndex;
                continue;
            }
            ColorRGBA color = l.getColor();
            if (l.getType() != Light.Type.Probe) {
                lightData.setVector4InArray(color.getRed(), color.getGreen(), color.getBlue(), l.getType().getId(), lightDataIndex);
                ++lightDataIndex;
            }
            switch (l.getType()) {
                case Directional: {
                    DirectionalLight dl = (DirectionalLight)l;
                    Vector3f dir = dl.getDirection();
                    tmpVec.set(dir.getX(), dir.getY(), dir.getZ(), 0.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), -1.0f, lightDataIndex);
                    lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                case Point: {
                    PointLight pl = (PointLight)l;
                    Vector3f pos = pl.getPosition();
                    float invRadius = pl.getInvRadius();
                    tmpVec.set(pos.getX(), pos.getY(), pos.getZ(), 1.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), invRadius, lightDataIndex);
                    lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                case Spot: {
                    SpotLight sl = (SpotLight)l;
                    Vector3f pos2 = sl.getPosition();
                    Vector3f dir2 = sl.getDirection();
                    float invRange = sl.getInvSpotRange();
                    float spotAngleCos = sl.getPackedAngleCos();
                    tmpVec.set(pos2.getX(), pos2.getY(), pos2.getZ(), 1.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), invRange, lightDataIndex);
                    tmpVec.set(dir2.getX(), dir2.getY(), dir2.getZ(), 0.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), spotAngleCos, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type of light: " + (Object)((Object)l.getType()));
                }
            }
        }
        vars.release();
        while (lightDataIndex < numLights * 3) {
            lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, lightDataIndex);
            ++lightDataIndex;
        }
        return curIndex;
    }

    @Override
    public void render(RenderManager renderManager, Shader shader, Geometry geometry, LightList lights, int lastTexUnit) {
        int nbRenderedLights = 0;
        Renderer renderer = renderManager.getRenderer();
        int batchSize = renderManager.getSinglePassLightBatchSize();
        if (lights.size() == 0) {
            this.updateLightListUniforms(shader, geometry, lights, batchSize, renderManager, 0, lastTexUnit);
            renderer.setShader(shader);
            SinglePassAndImageBasedLightingLogic.renderMeshFromGeometry(renderer, geometry);
        } else {
            while (nbRenderedLights < lights.size()) {
                nbRenderedLights = this.updateLightListUniforms(shader, geometry, lights, batchSize, renderManager, nbRenderedLights, lastTexUnit);
                renderer.setShader(shader);
                SinglePassAndImageBasedLightingLogic.renderMeshFromGeometry(renderer, geometry);
            }
        }
    }

    protected LightProbe extractIndirectLights(LightList lightList, boolean removeLights) {
        this.ambientLightColor.set(0.0f, 0.0f, 0.0f, 1.0f);
        LightProbe probe = null;
        for (int j = 0; j < lightList.size(); ++j) {
            Light l = lightList.get(j);
            if (l instanceof AmbientLight) {
                this.ambientLightColor.addLocal(l.getColor());
                if (removeLights) {
                    lightList.remove(l);
                    --j;
                }
            }
            if (!(l instanceof LightProbe)) continue;
            probe = (LightProbe)l;
            if (!removeLights) continue;
            lightList.remove(l);
            --j;
        }
        this.ambientLightColor.a = 1.0f;
        return probe;
    }

    static {
        ADDITIVE_LIGHT.setBlendMode(RenderState.BlendMode.AlphaAdditive);
        ADDITIVE_LIGHT.setDepthWrite(false);
    }
}

