/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Statistics;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;

public class StatsView
extends Node
implements Control,
JmeCloneable {
    private BitmapText statText;
    private Statistics statistics;
    private String[] statLabels;
    private int[] statData;
    private boolean enabled = true;
    private final StringBuilder stringBuilder = new StringBuilder();

    public StatsView(String name, AssetManager manager, Statistics stats) {
        super(name);
        this.setQueueBucket(RenderQueue.Bucket.Gui);
        this.setCullHint(Spatial.CullHint.Never);
        this.statistics = stats;
        this.statistics.setEnabled(this.enabled);
        this.statLabels = this.statistics.getLabels();
        this.statData = new int[this.statLabels.length];
        BitmapFont font = manager.loadFont("Interface/Fonts/Console.fnt");
        this.statText = new BitmapText(font);
        this.statText.setLocalTranslation(0.0f, this.statText.getLineHeight() * (float)this.statLabels.length, 0.0f);
        this.attachChild(this.statText);
        this.addControl(this);
    }

    public float getHeight() {
        return this.statText.getLineHeight() * (float)this.statLabels.length;
    }

    @Override
    public void update(float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        this.statistics.getData(this.statData);
        this.stringBuilder.setLength(0);
        for (int i = this.statLabels.length - 1; i >= 0; --i) {
            this.stringBuilder.append(this.statLabels[i]).append(" = ").append(this.statData[i]).append('\n');
        }
        this.statText.setText(this.stringBuilder);
    }

    @Override
    public Control cloneForSpatial(Spatial spatial) {
        return (Control)((Object)spatial);
    }

    @Override
    public StatsView jmeClone() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void setSpatial(Spatial spatial) {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.statistics.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void render(RenderManager rm, ViewPort vp) {
    }
}

