/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import org.ejml.alg.dense.decompose.lu.LUDecompositionBase_CD64;
import org.ejml.alg.dense.linsol.lu.LinearSolverLuBase_CD64;
import org.ejml.data.CDenseMatrix64F;

public class LinearSolverLu_CD64
extends LinearSolverLuBase_CD64 {
    public LinearSolverLu_CD64(LUDecompositionBase_CD64 decomp) {
        super(decomp);
    }

    public void solve(CDenseMatrix64F b, CDenseMatrix64F x) {
        if (b.numCols != x.numCols || b.numRows != this.numRows || x.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        int bnumCols = b.numCols;
        int bstride = b.getRowStride();
        double[] dataB = b.data;
        double[] dataX = x.data;
        double[] vv = this.decomp._getVV();
        for (int j = 0; j < bnumCols; ++j) {
            int index = j * 2;
            int i = 0;
            while (i < this.numRows) {
                vv[i * 2] = dataB[index];
                vv[i * 2 + 1] = dataB[index + 1];
                ++i;
                index += bstride;
            }
            this.decomp._solveVectorInternal(vv);
            index = j * 2;
            i = 0;
            while (i < this.numRows) {
                dataX[index] = vv[i * 2];
                dataX[index + 1] = vv[i * 2 + 1];
                ++i;
                index += bstride;
            }
        }
    }
}

